/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.FTNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.BasicServiceCode;
import org.restcomm.protocols.ss7.map.api.service.supplementary.ForwardingFeature;
import org.restcomm.protocols.ss7.map.api.service.supplementary.ForwardingOptions;
import org.restcomm.protocols.ss7.map.api.service.supplementary.SSStatus;
import org.restcomm.protocols.ss7.map.primitives.FTNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.BasicServiceCodeImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.ForwardingOptionsImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.SSStatusImpl;

public class ForwardingFeatureImpl
extends SequenceBase
implements ForwardingFeature {
    public static final int _ID_ssStatus = 4;
    public static final int _ID_forwardedToNumber = 5;
    public static final int _ID_forwardedToSubaddress = 8;
    public static final int _ID_forwardingOptions = 6;
    public static final int _ID_noReplyConditionTime = 7;
    public static final int _ID_longForwardedToNumber = 9;
    private BasicServiceCode basicService;
    private SSStatus ssStatus;
    private ISDNAddressString torwardedToNumber;
    private ISDNAddressString forwardedToSubaddress;
    private ForwardingOptions forwardingOptions;
    private Integer noReplyConditionTime;
    private FTNAddressString longForwardedToNumber;

    public ForwardingFeatureImpl() {
        super("ForwardingFeature");
    }

    public ForwardingFeatureImpl(BasicServiceCode basicService, SSStatus ssStatus, ISDNAddressString torwardedToNumber, ISDNAddressString forwardedToSubaddress, ForwardingOptions forwardingOptions, Integer noReplyConditionTime, FTNAddressString longForwardedToNumber) {
        super("ForwardingFeature");
        this.basicService = basicService;
        this.ssStatus = ssStatus;
        this.torwardedToNumber = torwardedToNumber;
        this.forwardedToSubaddress = forwardedToSubaddress;
        this.forwardingOptions = forwardingOptions;
        this.noReplyConditionTime = noReplyConditionTime;
        this.longForwardedToNumber = longForwardedToNumber;
    }

    @Override
    public BasicServiceCode getBasicService() {
        return this.basicService;
    }

    @Override
    public SSStatus getSsStatus() {
        return this.ssStatus;
    }

    @Override
    public ISDNAddressString getForwardedToNumber() {
        return this.torwardedToNumber;
    }

    @Override
    public ISDNAddressString getForwardedToSubaddress() {
        return this.forwardedToSubaddress;
    }

    @Override
    public ForwardingOptions getForwardingOptions() {
        return this.forwardingOptions;
    }

    @Override
    public Integer getNoReplyConditionTime() {
        return this.noReplyConditionTime;
    }

    @Override
    public FTNAddressString getLongForwardedToNumber() {
        return this.longForwardedToNumber;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.basicService = null;
        this.ssStatus = null;
        this.torwardedToNumber = null;
        this.forwardedToSubaddress = null;
        this.forwardingOptions = null;
        this.noReplyConditionTime = null;
        this.longForwardedToNumber = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block9: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 2: 
                    case 3: {
                        this.basicService = new BasicServiceCodeImpl();
                        ((BasicServiceCodeImpl)this.basicService).decodeAll(ais);
                        continue block9;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " ssStatus: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ssStatus = new SSStatusImpl();
                        ((SSStatusImpl)this.ssStatus).decodeAll(ais);
                        continue block9;
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " torwardedToNumber: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.torwardedToNumber = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.torwardedToNumber).decodeAll(ais);
                        continue block9;
                    }
                    case 8: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " forwardedToSubaddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.forwardedToSubaddress = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.forwardedToSubaddress).decodeAll(ais);
                        continue block9;
                    }
                    case 6: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " forwardingOptions: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.forwardingOptions = new ForwardingOptionsImpl();
                        ((ForwardingOptionsImpl)this.forwardingOptions).decodeAll(ais);
                        continue block9;
                    }
                    case 7: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " noReplyConditionTime: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.noReplyConditionTime = (int)ais.readInteger();
                        continue block9;
                    }
                    case 9: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " longForwardedToNumber: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.longForwardedToNumber = new FTNAddressStringImpl();
                        ((FTNAddressStringImpl)this.longForwardedToNumber).decodeAll(ais);
                        continue block9;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.basicService != null) {
                ((BasicServiceCodeImpl)this.basicService).encodeAll(asnOs);
            }
            if (this.ssStatus != null) {
                ((SSStatusImpl)this.ssStatus).encodeAll(asnOs, 2, 4);
            }
            if (this.torwardedToNumber != null) {
                ((ISDNAddressStringImpl)this.torwardedToNumber).encodeAll(asnOs, 2, 5);
            }
            if (this.forwardedToSubaddress != null) {
                ((ISDNAddressStringImpl)this.forwardedToSubaddress).encodeAll(asnOs, 2, 8);
            }
            if (this.forwardingOptions != null) {
                ((ForwardingOptionsImpl)this.forwardingOptions).encodeAll(asnOs, 2, 6);
            }
            if (this.noReplyConditionTime != null) {
                asnOs.writeInteger(2, 7, this.noReplyConditionTime.intValue());
            }
            if (this.longForwardedToNumber != null) {
                ((FTNAddressStringImpl)this.longForwardedToNumber).encodeAll(asnOs, 2, 9);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.basicService != null) {
            sb.append("basicService=");
            sb.append(this.basicService);
        }
        if (this.ssStatus != null) {
            sb.append(", ssStatus=");
            sb.append(this.ssStatus);
        }
        if (this.torwardedToNumber != null) {
            sb.append(", torwardedToNumber=");
            sb.append(this.torwardedToNumber);
        }
        if (this.forwardedToSubaddress != null) {
            sb.append(", forwardedToSubaddress=");
            sb.append(this.forwardedToSubaddress);
        }
        if (this.forwardingOptions != null) {
            sb.append(", forwardingOptions=");
            sb.append(this.forwardingOptions);
        }
        if (this.noReplyConditionTime != null) {
            sb.append(", noReplyConditionTime=");
            sb.append(this.noReplyConditionTime);
        }
        if (this.longForwardedToNumber != null) {
            sb.append(", longForwardedToNumber=");
            sb.append(this.longForwardedToNumber);
        }
        sb.append("]");
        return sb.toString();
    }
}

