/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.sms;

import java.io.IOException;
import java.nio.charset.Charset;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.sms.SmsSignalInfo;
import org.restcomm.protocols.ss7.map.api.smstpdu.SmsTpdu;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.restcomm.protocols.ss7.map.smstpdu.SmsTpduImpl;

public class SmsSignalInfoImpl
implements SmsSignalInfo,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "SmsSignalInfo";
    private byte[] data;
    private Charset gsm8Charset;

    public SmsSignalInfoImpl() {
    }

    public SmsSignalInfoImpl(byte[] data, Charset gsm8Charset) {
        this.data = data;
        this.setGsm8Charset(gsm8Charset);
    }

    public SmsSignalInfoImpl(SmsTpdu tpdu, Charset gsm8Charset) throws MAPException {
        if (tpdu == null) {
            throw new MAPException("SmsTpdu must not be null");
        }
        this.setGsm8Charset(gsm8Charset);
        this.data = tpdu.encodeData();
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public Charset getGsm8Charset() {
        return this.gsm8Charset;
    }

    @Override
    public void setGsm8Charset(Charset gsm8Charset) {
        this.gsm8Charset = gsm8Charset;
    }

    @Override
    public SmsTpdu decodeTpdu(boolean mobileOriginatedMessage) throws MAPException {
        return SmsTpduImpl.createInstance(this.data, mobileOriginatedMessage, this.getGsm8Charset());
    }

    @Override
    public int getTag() throws MAPException {
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SmsSignalInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SmsSignalInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SmsSignalInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SmsSignalInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws IOException, AsnException {
        this.data = ansIS.readOctetStringData(length);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SmsSignalInfo: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.data == null || this.data.length == 0) {
            throw new MAPException("Error when encoding SmsSignalInfo: data is empty");
        }
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        SmsTpduImpl tpdu2;
        StringBuilder sb = new StringBuilder();
        sb.append("SmsSignalInfo [");
        boolean moExists = false;
        try {
            tpdu2 = SmsTpduImpl.createInstance(this.data, true, this.getGsm8Charset());
            sb.append("MO case: ");
            sb.append(tpdu2.toString());
            moExists = true;
        }
        catch (MAPException tpdu2) {
            // empty catch block
        }
        try {
            if (moExists) {
                sb.append("\n");
            }
            tpdu2 = SmsTpduImpl.createInstance(this.data, false, this.getGsm8Charset());
            sb.append("MT case: ");
            sb.append(tpdu2.toString());
        }
        catch (MAPException mAPException) {
            // empty catch block
        }
        sb.append("]");
        return sb.toString();
    }
}

