/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPMessageType;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.primitives.SubscriberIdentity;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeSubscriptionInterrogationRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.RequestedSubscriptionInfo;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SubscriberIdentityImpl;
import org.restcomm.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation.RequestedSubscriptionInfoImpl;

public class AnyTimeSubscriptionInterrogationRequestImpl
extends MobilityMessageImpl
implements AnyTimeSubscriptionInterrogationRequest,
MAPAsnPrimitive {
    private static final int _TAG_SUBSCRIBER_IDENTITY = 0;
    private static final int _TAG_REQUESTED_SUBSCRIPTION_INFO = 1;
    private static final int _TAG_GSM_SCF_ADDRESS = 2;
    private static final int _TAG_EXTENSION_CONTAINER = 3;
    private static final int _TAG_LONG_FTN_SUPPORTED = 4;
    public static final String _PrimitiveName = "AnyTimeSubscriptionInterrogationRequest";
    private SubscriberIdentity subscriberIdentity;
    private RequestedSubscriptionInfo requestedSubscriptionInfo;
    private ISDNAddressString gsmSCFAddress;
    private MAPExtensionContainer mapExtensionContainer;
    private boolean isLongFTNSupported;

    public AnyTimeSubscriptionInterrogationRequestImpl() {
    }

    public AnyTimeSubscriptionInterrogationRequestImpl(SubscriberIdentity subscriberIdentity, RequestedSubscriptionInfo requestedSubscriptionInfo, ISDNAddressString gsmSCFAddress, MAPExtensionContainer mapExtensionContainer, boolean isLongFTNSupported) {
        this.subscriberIdentity = subscriberIdentity;
        this.requestedSubscriptionInfo = requestedSubscriptionInfo;
        this.gsmSCFAddress = gsmSCFAddress;
        this.mapExtensionContainer = mapExtensionContainer;
        this.isLongFTNSupported = isLongFTNSupported;
    }

    @Override
    public SubscriberIdentity getSubscriberIdentity() {
        return this.subscriberIdentity;
    }

    @Override
    public RequestedSubscriptionInfo getRequestedSubscriptionInfo() {
        return this.requestedSubscriptionInfo;
    }

    @Override
    public ISDNAddressString getGsmScfAddress() {
        return this.gsmSCFAddress;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.mapExtensionContainer;
    }

    @Override
    public boolean getLongFTNSupported() {
        return this.isLongFTNSupported;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AnyTimeSubscriptionInterrogationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AnyTimeSubscriptionInterrogationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AnyTimeSubscriptionInterrogationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AnyTimeSubscriptionInterrogationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        this.subscriberIdentity = null;
        this.requestedSubscriptionInfo = null;
        this.gsmSCFAddress = null;
        this.mapExtensionContainer = null;
        this.isLongFTNSupported = false;
        block7: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationRequest: Parameter subscriberIdentity is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.subscriberIdentity = new SubscriberIdentityImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((SubscriberIdentityImpl)this.subscriberIdentity).decodeAll(ais2);
                        continue block7;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationRequest: Parameter requestedInfo is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.requestedSubscriptionInfo = new RequestedSubscriptionInfoImpl();
                        ((RequestedSubscriptionInfoImpl)this.requestedSubscriptionInfo).decodeAll(ais);
                        continue block7;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationRequest: Parameter gsmSCFAddress is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.gsmSCFAddress = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.gsmSCFAddress).decodeAll(ais);
                        continue block7;
                    }
                    case 3: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationRequest: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.mapExtensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.mapExtensionContainer).decodeAll(ais);
                        continue block7;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationRequest: Parameter longFTNSupported is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.isLongFTNSupported = Boolean.TRUE;
                        continue block7;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.subscriberIdentity == null) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationRequest: subscriberIdentity parameter is mandatory but is not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.requestedSubscriptionInfo == null) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationRequest: requestedSubscriptionInfo parameter is mandatory but is not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.gsmSCFAddress == null) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationRequest: gsmSCFAddress parameter is mandatory but is not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AnyTimeSubscriptionInterrogationRequest: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.subscriberIdentity == null) {
            throw new MAPException("Error while encoding AnyTimeSubscriptionInterrogationRequest the mandatory parameter subscriberIdentity is not defined");
        }
        if (this.requestedSubscriptionInfo == null) {
            throw new MAPException("Error while encoding AnyTimeSubscriptionInterrogationRequest the mandatory parameter requestedSubscriptionInfo is not defined");
        }
        if (this.gsmSCFAddress == null) {
            throw new MAPException("Error while encoding AnyTimeSubscriptionInterrogationRequest the mandatory parameter gsmSCFAddress is not defined");
        }
        try {
            asnOs.writeTag(2, false, 0);
            int pos = asnOs.StartContentDefiniteLength();
            ((SubscriberIdentityImpl)this.subscriberIdentity).encodeAll(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException while encoding AnyTimeSubscriptionInterrogationRequest parameter subscriberIdentity [0] SubscriberIdentity");
        }
        ((RequestedSubscriptionInfoImpl)this.requestedSubscriptionInfo).encodeAll(asnOs, 2, 1);
        ((ISDNAddressStringImpl)this.gsmSCFAddress).encodeAll(asnOs, 2, 2);
        if (this.mapExtensionContainer != null) {
            ((MAPExtensionContainerImpl)this.mapExtensionContainer).encodeAll(asnOs, 2, 3);
        }
        if (this.isLongFTNSupported) {
            try {
                asnOs.writeNull(2, 4);
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding parameter longFTNSupported: ", e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding parameter longFTNSupported: ", e);
            }
        }
    }

    @Override
    public MAPMessageType getMessageType() {
        return MAPMessageType.anyTimeSubscriptionInterrogation_Request;
    }

    @Override
    public int getOperationCode() {
        return 62;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.subscriberIdentity != null) {
            sb.append("subscriberIdentity=");
            sb.append(this.subscriberIdentity);
        }
        if (this.requestedSubscriptionInfo != null) {
            sb.append(", requestedSubscriptionInfo=");
            sb.append(this.requestedSubscriptionInfo);
        }
        if (this.gsmSCFAddress != null) {
            sb.append(", gsmSCFAddress=");
            sb.append(this.gsmSCFAddress);
        }
        if (this.mapExtensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.mapExtensionContainer);
        }
        if (this.isLongFTNSupported) {
            sb.append(", isLongFTNSupported");
        }
        sb.append("]");
        return sb.toString();
    }
}

