/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import java.util.Arrays;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.LAC;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class LACImpl
implements LAC,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "LAC";
    private byte[] data;

    public LACImpl() {
    }

    public LACImpl(byte[] data) {
        this.data = data;
    }

    public LACImpl(int lac) throws MAPException {
        this.data = new byte[2];
        this.data[0] = (byte)(lac / 256);
        this.data[1] = (byte)(lac % 256);
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getLac() throws MAPException {
        if (this.data == null) {
            throw new MAPException("Data must not be empty");
        }
        if (this.data.length != 2) {
            throw new MAPException("Data length must be equal 5");
        }
        int res = (this.data[0] & 0xFF) * 256 + (this.data[1] & 0xFF);
        return res;
    }

    @Override
    public int getTag() throws MAPException {
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LAC: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LAC: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LAC: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LAC: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        try {
            this.data = ansIS.readOctetStringData(length);
            if (this.data.length != 2) {
                throw new MAPParsingComponentException("Error decoding LAC: the field must contain from 2 to 2 octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LAIFixedLength: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LAC: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.data == null) {
            throw new MAPException("Error while encoding the LAC: data is not defined");
        }
        if (this.data.length != 2) {
            throw new MAPException("Error while encoding the LAC: field length must be equal 2");
        }
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        int lac = 0;
        boolean goodData = false;
        try {
            lac = this.getLac();
            goodData = true;
        }
        catch (MAPException mAPException) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (goodData) {
            sb.append("Lac=");
            sb.append(lac);
        } else {
            sb.append("Data=");
            sb.append(this.printDataArr());
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr() {
        StringBuilder sb = new StringBuilder();
        if (this.data != null) {
            for (byte b : this.data) {
                sb.append(b);
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LACImpl other = (LACImpl)obj;
        return Arrays.equals(this.data, other.data);
    }
}

