/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.authentication.CurrentSecurityContext;
import org.restcomm.protocols.ss7.map.api.service.mobility.authentication.GSMSecurityContextData;
import org.restcomm.protocols.ss7.map.api.service.mobility.authentication.UMTSSecurityContextData;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.restcomm.protocols.ss7.map.service.mobility.authentication.GSMSecurityContextDataImpl;
import org.restcomm.protocols.ss7.map.service.mobility.authentication.UMTSSecurityContextDataImpl;

public class CurrentSecurityContextImpl
implements CurrentSecurityContext,
MAPAsnPrimitive {
    public static final int _TAG_gsmSecurityContextData = 0;
    public static final int _TAG_umtsSecurityContextData = 1;
    public static final String _PrimitiveName = "CurrentSecurityContext";
    private GSMSecurityContextData gsmSecurityContextData;
    private UMTSSecurityContextData umtsSecurityContextData;

    public CurrentSecurityContextImpl() {
        this.gsmSecurityContextData = null;
        this.umtsSecurityContextData = null;
    }

    public CurrentSecurityContextImpl(GSMSecurityContextData gsmSecurityContextData) {
        this.gsmSecurityContextData = gsmSecurityContextData;
    }

    public CurrentSecurityContextImpl(UMTSSecurityContextData umtsSecurityContextData) {
        this.umtsSecurityContextData = umtsSecurityContextData;
    }

    @Override
    public GSMSecurityContextData getGSMSecurityContextData() {
        return this.gsmSecurityContextData;
    }

    @Override
    public UMTSSecurityContextData getUMTSSecurityContextData() {
        return this.umtsSecurityContextData;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.gsmSecurityContextData != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding CurrentSecurityContext: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding CurrentSecurityContext: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding CurrentSecurityContext: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding CurrentSecurityContext: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.gsmSecurityContextData = null;
        this.umtsSecurityContextData = null;
        int tag = ais.getTag();
        if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding CurrentSecurityContext: Primitive has bad tag class or is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (tag) {
            case 0: {
                this.gsmSecurityContextData = new GSMSecurityContextDataImpl();
                ((GSMSecurityContextDataImpl)this.gsmSecurityContextData).decodeData(ais, length);
                break;
            }
            case 1: {
                this.umtsSecurityContextData = new UMTSSecurityContextDataImpl();
                ((UMTSSecurityContextDataImpl)this.umtsSecurityContextData).decodeData(ais, length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while decoding CurrentSecurityContext: bad choice tag", MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding CurrentSecurityContext: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.gsmSecurityContextData == null && this.umtsSecurityContextData == null || this.gsmSecurityContextData != null && this.umtsSecurityContextData != null) {
            throw new MAPException("Error while decoding CurrentSecurityContext: One and only one choice must be selected");
        }
        if (this.gsmSecurityContextData != null) {
            ((GSMSecurityContextDataImpl)this.gsmSecurityContextData).encodeData(asnOs);
        } else {
            ((UMTSSecurityContextDataImpl)this.umtsSecurityContextData).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.gsmSecurityContextData != null) {
            sb.append(this.gsmSecurityContextData.toString());
            sb.append(", ");
        }
        if (this.umtsSecurityContextData != null) {
            sb.append(this.umtsSecurityContextData.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

