/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.service.lsm.AdditionalNumber;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class AdditionalNumberImpl
implements AdditionalNumber,
MAPAsnPrimitive {
    private static final int _TAG_MSC_NUMBER = 0;
    private static final int _TAG_SGSN_NUMBER = 1;
    public static final String _PrimitiveName = "AdditionalNumber";
    private ISDNAddressString mSCNumber = null;
    private ISDNAddressString sGSNNumber = null;

    public AdditionalNumberImpl() {
    }

    public AdditionalNumberImpl(ISDNAddressString mSCNumber, ISDNAddressString sGSNNumber) {
        this.mSCNumber = mSCNumber;
        this.sGSNNumber = sGSNNumber;
    }

    @Override
    public ISDNAddressString getMSCNumber() {
        return this.mSCNumber;
    }

    @Override
    public ISDNAddressString getSGSNNumber() {
        return this.sGSNNumber;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.mSCNumber != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AdditionalNumber: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AdditionalNumber: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AdditionalNumber: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AdditionalNumber: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (asnIS.getTagClass() != 2 || !asnIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding AdditionalNumber: bad tag class or is not primitive: TagClass=" + asnIS.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (asnIS.getTag()) {
            case 0: {
                this.mSCNumber = new ISDNAddressStringImpl();
                ((ISDNAddressStringImpl)this.mSCNumber).decodeData(asnIS, length);
                break;
            }
            case 1: {
                this.sGSNNumber = new ISDNAddressStringImpl();
                ((ISDNAddressStringImpl)this.sGSNNumber).decodeData(asnIS, length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while decoding AdditionalNumber: Expexted msc-Number [0] ISDN-AddressString or sgsn-Number [1] ISDN-AddressString, but found " + asnIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AdditionalNumber: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.mSCNumber == null && this.sGSNNumber == null) {
            throw new MAPException("Error when encoding AdditionalNumber: both mscNumber and sgsnNumber must not be null");
        }
        if (this.mSCNumber != null && this.sGSNNumber != null) {
            throw new MAPException("Error when encoding AdditionalNumber: both mscNumber and sgsnNumber must not be not null");
        }
        if (this.mSCNumber != null) {
            ((ISDNAddressStringImpl)this.mSCNumber).encodeData(asnOs);
        } else {
            ((ISDNAddressStringImpl)this.sGSNNumber).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AdditionalNumber [");
        if (this.mSCNumber != null) {
            sb.append("msc-Number=");
            sb.append(this.mSCNumber.toString());
        }
        if (this.sGSNNumber != null) {
            sb.append("sgsn-Number=");
            sb.append(this.sGSNNumber.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mSCNumber == null ? 0 : this.mSCNumber.hashCode());
        result = 31 * result + (this.sGSNNumber == null ? 0 : this.sGSNNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdditionalNumberImpl other = (AdditionalNumberImpl)obj;
        if (this.mSCNumber == null ? other.mSCNumber != null : !this.mSCNumber.equals(other.mSCNumber)) {
            return false;
        }
        return !(this.sGSNNumber == null ? other.sGSNNumber != null : !this.sGSNNumber.equals(other.sGSNNumber));
    }
}

