/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.errors.MAPErrorMessageSsIncompatibility;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.BasicServiceCode;
import org.restcomm.protocols.ss7.map.api.service.supplementary.SSCode;
import org.restcomm.protocols.ss7.map.api.service.supplementary.SSStatus;
import org.restcomm.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.BasicServiceCodeImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.SSCodeImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.SSStatusImpl;

public class MAPErrorMessageSsIncompatibilityImpl
extends MAPErrorMessageImpl
implements MAPErrorMessageSsIncompatibility {
    private static final String SS_CODE = "ssCode";
    private static final String BASIC_SERVICE = "basicService";
    private static final String SS_STATUS = "ssStatus";
    public static final int _tag_ss_Code = 1;
    public static final int _tag_ss_Status = 4;
    private SSCode ssCode;
    private BasicServiceCode basicService;
    private SSStatus ssStatus;
    protected String _PrimitiveName = "MAPErrorMessageSsIncompatibility";
    protected static final XMLFormat<MAPErrorMessageSsIncompatibilityImpl> MAP_ERROR_MESSAGE_SS_INCOMPATIBILITY_XML = new XMLFormat<MAPErrorMessageSsIncompatibilityImpl>(MAPErrorMessageSsIncompatibilityImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, MAPErrorMessageSsIncompatibilityImpl errorMessage) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.read(xml, errorMessage);
            errorMessage.ssCode = xml.get(MAPErrorMessageSsIncompatibilityImpl.SS_CODE, SSCodeImpl.class);
            errorMessage.basicService = xml.get(MAPErrorMessageSsIncompatibilityImpl.BASIC_SERVICE, BasicServiceCodeImpl.class);
            errorMessage.ssStatus = xml.get(MAPErrorMessageSsIncompatibilityImpl.SS_STATUS, SSStatusImpl.class);
        }

        @Override
        public void write(MAPErrorMessageSsIncompatibilityImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.write(errorMessage, xml);
            xml.add((SSCodeImpl)errorMessage.ssCode, MAPErrorMessageSsIncompatibilityImpl.SS_CODE, SSCodeImpl.class);
            xml.add((BasicServiceCodeImpl)errorMessage.getBasicService(), MAPErrorMessageSsIncompatibilityImpl.BASIC_SERVICE, BasicServiceCodeImpl.class);
            xml.add((SSStatusImpl)errorMessage.getSSStatus(), MAPErrorMessageSsIncompatibilityImpl.SS_STATUS, SSStatusImpl.class);
        }
    };

    public MAPErrorMessageSsIncompatibilityImpl(SSCode ssCode, BasicServiceCode basicService, SSStatus ssStatus) {
        super(20L);
        this.ssCode = ssCode;
        this.basicService = basicService;
        this.ssStatus = ssStatus;
    }

    public MAPErrorMessageSsIncompatibilityImpl() {
        super(20L);
    }

    @Override
    public boolean isEmSsIncompatibility() {
        return true;
    }

    @Override
    public MAPErrorMessageSsIncompatibility getEmSsIncompatibility() {
        return this;
    }

    @Override
    public SSCode getSSCode() {
        return this.ssCode;
    }

    @Override
    public BasicServiceCode getBasicService() {
        return this.basicService;
    }

    @Override
    public SSStatus getSSStatus() {
        return this.ssStatus;
    }

    @Override
    public void setSSCode(SSCode val) {
        this.ssCode = val;
    }

    @Override
    public void setBasicService(BasicServiceCode val) {
        this.basicService = val;
    }

    @Override
    public void setSSStatus(SSStatus val) {
        this.ssStatus = val;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssCode = null;
        this.basicService = null;
        this.ssStatus = null;
        if (localAis.getTagClass() != 0 || localAis.getTag() != 16 || localAis.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": bad tag class or tag or parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        AsnInputStream ais = localAis.readSequenceStreamData(length);
        block8: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 1: {
                            this.ssCode = new SSCodeImpl();
                            ((SSCodeImpl)this.ssCode).decodeAll(ais);
                            continue block8;
                        }
                        case 2: 
                        case 3: {
                            this.basicService = new BasicServiceCodeImpl();
                            ((BasicServiceCodeImpl)this.basicService).decodeAll(ais);
                            continue block8;
                        }
                        case 4: {
                            this.ssStatus = new SSStatusImpl();
                            ((SSStatusImpl)this.ssStatus).decodeAll(ais);
                            continue block8;
                        }
                    }
                    ais.advanceElement();
                    continue block8;
                }
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ssCode == null && this.basicService == null && this.ssStatus == null) {
            return;
        }
        if (this.ssCode != null) {
            ((SSCodeImpl)this.ssCode).encodeAll(asnOs, 2, 1);
        }
        if (this.basicService != null) {
            ((BasicServiceCodeImpl)this.basicService).encodeAll(asnOs, ((BasicServiceCodeImpl)this.basicService).getTagClass(), ((BasicServiceCodeImpl)this.basicService).getTag());
        }
        if (this.ssStatus != null) {
            ((SSStatusImpl)this.ssStatus).encodeAll(asnOs, 2, 4);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.ssCode != null) {
            sb.append("ssCode=" + this.ssCode.toString());
        }
        if (this.basicService != null) {
            sb.append(", basicService=" + this.basicService.toString());
        }
        if (this.ssStatus != null) {
            sb.append(", ssStatus=" + this.ssStatus.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

