/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl.parameter;

import org.restcomm.protocols.ss7.m3ua.impl.parameter.ParameterImpl;
import org.restcomm.protocols.ss7.m3ua.parameter.ErrorCode;

public class ErrorCodeImpl
extends ParameterImpl
implements ErrorCode {
    private int code;

    public ErrorCodeImpl(int code) {
        this.code = code;
        this.tag = (short)12;
    }

    public ErrorCodeImpl(byte[] data) {
        this.code = 0;
        this.code |= data[0] & 0xFF;
        this.code <<= 8;
        this.code |= data[1] & 0xFF;
        this.code <<= 8;
        this.code |= data[2] & 0xFF;
        this.code <<= 8;
        this.code |= data[3] & 0xFF;
        this.tag = (short)12;
    }

    @Override
    protected byte[] getValue() {
        byte[] data = new byte[]{(byte)(this.code >>> 24), (byte)(this.code >>> 16), (byte)(this.code >>> 8), (byte)this.code};
        return data;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public String toString() {
        return String.format("ErrorCode code=%d Error=%s", this.code, this.getErrorMessage(this.code));
    }

    private String getErrorMessage(int code) {
        switch (code) {
            case 1: {
                return "Invalid_Version";
            }
            case 3: {
                return "Unsupported_Message_Class";
            }
            case 4: {
                return "Unsupported_Message_Type";
            }
            case 5: {
                return "Unsupported_Traffic_Mode_Type";
            }
            case 6: {
                return "Unexpected_Message";
            }
            case 7: {
                return "Protocol_Error";
            }
            case 9: {
                return "Invalid_Stream_Identifier";
            }
            case 13: {
                return "Refused_Management_Blocking";
            }
            case 14: {
                return "ASP_Identifier_Required";
            }
            case 15: {
                return "Invalid_ASP_Identifier";
            }
            case 17: {
                return "Invalid_Parameter_Value";
            }
            case 18: {
                return "Parameter_Field_Error";
            }
            case 19: {
                return "Unexpected_Parameter";
            }
            case 20: {
                return "Destination_Status_Unknown";
            }
            case 21: {
                return "Invalid_Network_Appearance";
            }
            case 22: {
                return "Missing_Parameter";
            }
            case 25: {
                return "Invalid_Routing_Context";
            }
            case 26: {
                return "No_Configured_AS_for_ASP";
            }
        }
        return Integer.toString(code);
    }
}

