/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl;

import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.m3ua.Functionality;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspState;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSM;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSMState;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.TransitionHandler;
import org.restcomm.protocols.ss7.m3ua.message.mgmt.Notify;
import org.restcomm.protocols.ss7.m3ua.parameter.Status;

public class THLocalAsPendToAct
implements TransitionHandler {
    private static final Logger logger = Logger.getLogger(THLocalAsPendToAct.class);
    private AsImpl asImpl = null;
    private FSM fsm;

    public THLocalAsPendToAct(AsImpl asImpl, FSM fsm) {
        this.asImpl = asImpl;
        this.fsm = fsm;
    }

    @Override
    public boolean process(FSMState state) {
        if (this.asImpl.getTrafficModeType().getMode() == 3) {
            return false;
        }
        try {
            if (this.asImpl.getFunctionality() != Functionality.IPSP) {
                FastCollection.Record n = this.asImpl.appServerProcs.head();
                FastCollection.Record end = this.asImpl.appServerProcs.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    AspImpl remAspImpl = (AspImpl)((FastList.Node)n).getValue();
                    FSM aspPeerFSM = remAspImpl.getPeerFSM();
                    AspState aspState = AspState.getState(aspPeerFSM.getState().getName());
                    if (aspState != AspState.INACTIVE && aspState != AspState.ACTIVE) continue;
                    Notify msg = this.createNotify(remAspImpl);
                    remAspImpl.getAspFactory().write(msg);
                }
            }
            AspImpl causeAsp = (AspImpl)this.fsm.getAttribute("asp");
            this.asImpl.sendPendingPayloadData(causeAsp);
            return true;
        }
        catch (Exception e) {
            logger.error(String.format("Error while translating Rem AS to INACTIVE message. %s", this.fsm.toString()), e);
            return false;
        }
    }

    private Notify createNotify(AspImpl remAsp) {
        Notify msg = (Notify)this.asImpl.getMessageFactory().createMessage(0, 1);
        Status status = this.asImpl.getParameterFactory().createStatus(1, 3);
        msg.setStatus(status);
        if (remAsp.getASPIdentifier() != null) {
            msg.setASPIdentifier(remAsp.getASPIdentifier());
        }
        if (this.asImpl.getRoutingContext() != null) {
            msg.setRoutingContext(this.asImpl.getRoutingContext());
        }
        return msg;
    }
}

