/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl;

import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastSet;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.m3ua.ExchangeType;
import org.restcomm.protocols.ss7.m3ua.Functionality;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AsStateListener;
import org.restcomm.protocols.ss7.m3ua.impl.AspImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspState;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSM;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSMState;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSMStateEventHandler;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.UnknownTransitionException;
import org.restcomm.protocols.ss7.m3ua.message.mgmt.Notify;
import org.restcomm.protocols.ss7.m3ua.parameter.Status;

public class RemAsStatePenTimeout
implements FSMStateEventHandler {
    private AsImpl asImpl;
    private FSM fsm;
    private static final Logger logger = Logger.getLogger(RemAsStatePenTimeout.class);
    boolean inactive = false;

    public RemAsStatePenTimeout(AsImpl asImpl, FSM fsm) {
        this.asImpl = asImpl;
        this.fsm = fsm;
    }

    @Override
    public void onEvent(FSMState state) {
        this.inactive = false;
        this.asImpl.clearPendingQueue();
        FastCollection.Record n = this.asImpl.appServerProcs.head();
        FastCollection.Record end = this.asImpl.appServerProcs.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            AspImpl remAspImpl = (AspImpl)((FastList.Node)n).getValue();
            FSM aspPeerFSM = remAspImpl.getPeerFSM();
            AspState aspState = AspState.getState(aspPeerFSM.getState().getName());
            if (aspState != AspState.INACTIVE) continue;
            try {
                if (!this.inactive) {
                    this.fsm.signal("asinactive");
                    this.inactive = true;
                }
                if (this.asImpl.getFunctionality() == Functionality.IPSP) continue;
                Notify msg = this.createNotify(remAspImpl);
                remAspImpl.getAspFactory().write(msg);
            }
            catch (UnknownTransitionException e) {
                logger.error(String.format("Error while translating Rem AS to INACTIVE. %s", this.fsm.toString()), e);
            }
        }
        if (!this.inactive) {
            try {
                this.fsm.signal("asdown");
                this.inactive = true;
            }
            catch (UnknownTransitionException e) {
                logger.error(String.format("Error while translating Rem AS to DOWN. %s", this.fsm.toString()), e);
            }
        }
        if (this.asImpl.getExchangeType() == ExchangeType.SE) {
            FastSet<AsStateListener> asStateListeners = this.asImpl.getAsStateListeners();
            FastCollection.Record r = asStateListeners.head();
            FastCollection.Record end2 = asStateListeners.tail();
            while ((r = r.getNext()) != end2) {
                AsStateListener asAsStateListener = asStateListeners.valueOf(r);
                try {
                    asAsStateListener.onAsInActive(this.asImpl);
                }
                catch (Exception e) {
                    logger.error(String.format("Error while calling AsStateListener=%s onAsInActive method for As=%s", asAsStateListener, this.asImpl));
                }
            }
        }
    }

    private Notify createNotify(AspImpl remAsp) {
        Notify msg = (Notify)this.asImpl.getMessageFactory().createMessage(0, 1);
        Status status = this.asImpl.getParameterFactory().createStatus(1, 2);
        msg.setStatus(status);
        if (remAsp.getASPIdentifier() != null) {
            msg.setASPIdentifier(remAsp.getASPIdentifier());
        }
        msg.setRoutingContext(this.asImpl.getRoutingContext());
        return msg;
    }
}

