/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl;

import java.util.Arrays;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.m3ua.As;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.M3UAManagementImpl;
import org.restcomm.protocols.ss7.m3ua.impl.RouteAsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.RouteMap;
import org.restcomm.protocols.ss7.m3ua.impl.RouteRow;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.TrafficModeTypeImpl;
import org.restcomm.protocols.ss7.mtp.RoutingLabelFormat;

public class M3UARouteManagement {
    private static final Logger logger = Logger.getLogger(M3UARouteManagement.class);
    private static final String KEY_SEPARATOR = ":";
    private static final int WILDCARD = -1;
    private static final int BIT_ONE = 1;
    private M3UAManagementImpl m3uaManagement = null;
    private final int asSelectionMask;
    private int asSlsShiftPlaces = 0;
    protected RouteMap<String, RouteAsImpl> route = new RouteMap();
    private FastSet<RouteRow> routeTable = new FastSet();
    private int count = 0;

    protected M3UARouteManagement(M3UAManagementImpl m3uaManagement) {
        this.m3uaManagement = m3uaManagement;
        RoutingLabelFormat routingLabelFormat = this.m3uaManagement.getRoutingLabelFormat();
        switch (this.m3uaManagement.getMaxAsForRoute()) {
            case 1: 
            case 2: {
                if (this.m3uaManagement.isUseLsbForLinksetSelection()) {
                    this.asSelectionMask = 1;
                    this.asSlsShiftPlaces = 0;
                    break;
                }
                this.asSelectionMask = 128;
                this.asSlsShiftPlaces = 7;
                break;
            }
            case 3: 
            case 4: {
                if (this.m3uaManagement.isUseLsbForLinksetSelection()) {
                    this.asSelectionMask = 3;
                    this.asSlsShiftPlaces = 0;
                    break;
                }
                this.asSelectionMask = 192;
                this.asSlsShiftPlaces = 6;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.m3uaManagement.isUseLsbForLinksetSelection()) {
                    this.asSelectionMask = 7;
                    this.asSlsShiftPlaces = 0;
                    break;
                }
                this.asSelectionMask = 224;
                this.asSlsShiftPlaces = 5;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                if (this.m3uaManagement.isUseLsbForLinksetSelection()) {
                    this.asSelectionMask = 15;
                    this.asSlsShiftPlaces = 0;
                    break;
                }
                this.asSelectionMask = 240;
                this.asSlsShiftPlaces = 4;
                break;
            }
            default: {
                if (this.m3uaManagement.isUseLsbForLinksetSelection()) {
                    this.asSelectionMask = 1;
                    this.asSlsShiftPlaces = 0;
                    break;
                }
                this.asSelectionMask = 128;
                this.asSlsShiftPlaces = 7;
            }
        }
    }

    protected void reset() {
        FastCollection.Record e = this.route.head();
        FastMap.Entry end = this.route.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            String key = (String)((FastMap.Entry)e).getKey();
            RouteAsImpl routeAs = (RouteAsImpl)((FastMap.Entry)e).getValue();
            routeAs.setM3uaManagement(this.m3uaManagement);
            routeAs.reset();
            Object[] asList = routeAs.getAsArray();
            try {
                String[] keys = key.split(KEY_SEPARATOR);
                int dpc = Integer.parseInt(keys[0]);
                this.count = 0;
                while (this.count < asList.length) {
                    AsImpl asImpl = (AsImpl)asList[this.count];
                    if (asImpl != null) {
                        this.addAsToDPC(dpc, asImpl);
                    }
                    ++this.count;
                }
            }
            catch (Exception ex) {
                logger.error(String.format("Error while adding key=%s to As list=%s", key, Arrays.toString(asList)));
            }
        }
    }

    protected void addRoute(int dpc, int opc, int si, String asName, int traffmode) throws Exception {
        AsImpl asImpl = null;
        FastCollection.Record n = this.m3uaManagement.appServers.head();
        FastCollection.Record end = this.m3uaManagement.appServers.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            if (((As)((FastList.Node)n).getValue()).getName().compareTo(asName) != 0) continue;
            asImpl = (AsImpl)((FastList.Node)n).getValue();
            break;
        }
        if (asImpl == null) {
            throw new Exception(String.format("No AS found for given name %s", asName));
        }
        String key = new StringBuffer().append(dpc).append(KEY_SEPARATOR).append(opc).append(KEY_SEPARATOR).append(si).toString();
        RouteAsImpl asArray = (RouteAsImpl)this.route.get(key);
        if (asArray == null) {
            asArray = new RouteAsImpl();
            asArray.setTrafficModeType(new TrafficModeTypeImpl(traffmode));
            this.route.put(key, asArray);
            asArray.setM3uaManagement(this.m3uaManagement);
        }
        asArray.addRoute(dpc, opc, si, asImpl, traffmode);
        this.addAsToDPC(dpc, asImpl);
    }

    protected void removeRoute(int dpc, int opc, int si, String asName) throws Exception {
        AsImpl asImpl = null;
        FastCollection.Record n = this.m3uaManagement.appServers.head();
        FastCollection.Record end = this.m3uaManagement.appServers.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            if (((As)((FastList.Node)n).getValue()).getName().compareTo(asName) != 0) continue;
            asImpl = (AsImpl)((FastList.Node)n).getValue();
            break;
        }
        if (asImpl == null) {
            throw new Exception(String.format("No AS found for given name %s", asName));
        }
        String key = new StringBuffer().append(dpc).append(KEY_SEPARATOR).append(opc).append(KEY_SEPARATOR).append(si).toString();
        RouteAsImpl asArray = (RouteAsImpl)this.route.get(key);
        if (asArray == null) {
            throw new Exception(String.format("No AS=%s configured  for dpc=%d opc=%d si=%d", asImpl.getName(), dpc, opc, si));
        }
        asArray.removeRoute(dpc, opc, si, asImpl);
        this.removeAsFromDPC(dpc, asImpl);
        if (!asArray.hasAs()) {
            this.route.remove(key);
        }
        this.m3uaManagement.store();
    }

    protected AsImpl getAsForRoute(int dpc, int opc, int si, int sls) {
        String key = new StringBuffer().append(dpc).append(KEY_SEPARATOR).append(opc).append(KEY_SEPARATOR).append(si).toString();
        RouteAsImpl routeAs = (RouteAsImpl)this.route.get(key);
        if (routeAs == null && (routeAs = (RouteAsImpl)this.route.get(key = new StringBuffer().append(dpc).append(KEY_SEPARATOR).append(opc).append(KEY_SEPARATOR).append(-1).toString())) == null) {
            key = new StringBuffer().append(dpc).append(KEY_SEPARATOR).append(-1).append(KEY_SEPARATOR).append(-1).toString();
            routeAs = (RouteAsImpl)this.route.get(key);
        }
        if (routeAs == null) {
            return null;
        }
        int count = sls & this.asSelectionMask;
        return routeAs.getAsForRoute(count >>= this.asSlsShiftPlaces);
    }

    private void addAsToDPC(int dpc, AsImpl asImpl) {
        RouteRow row = null;
        FastCollection.Record r = this.routeTable.head();
        FastCollection.Record end = this.routeTable.tail();
        while ((r = r.getNext()) != end) {
            RouteRow value = this.routeTable.valueOf(r);
            if (value.getDpc() != dpc) continue;
            row = value;
            break;
        }
        if (row == null) {
            row = new RouteRow(dpc, this.m3uaManagement);
            this.routeTable.add(row);
        }
        row.addServedByAs(asImpl);
    }

    private void removeAsFromDPC(int dpc, AsImpl asImpl) {
        FastCollection.Record e = this.route.head();
        FastMap.Entry end = this.route.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            RouteAsImpl asList;
            String key = (String)((FastMap.Entry)e).getKey();
            String[] keys = key.split(KEY_SEPARATOR);
            if (!keys[0].equals(Integer.toString(dpc)) || !(asList = (RouteAsImpl)((FastMap.Entry)e).getValue()).hasAs(asImpl)) continue;
            return;
        }
        RouteRow row = null;
        FastCollection.Record r = this.routeTable.head();
        FastCollection.Record end2 = this.routeTable.tail();
        while ((r = r.getNext()) != end2) {
            RouteRow value = this.routeTable.valueOf(r);
            if (value.getDpc() != dpc) continue;
            row = value;
            break;
        }
        if (row == null) {
            logger.error(String.format("Removing route As=%s from DPC=%d failed. No RouteRow found!", asImpl, dpc));
        } else {
            row.removeServedByAs(asImpl);
            if (row.servedByAsSize() == 0) {
                this.routeTable.remove(row);
            }
        }
    }

    public void removeAllResourses() throws Exception {
        this.route.clear();
        this.routeTable.clear();
    }
}

