/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;
import org.mobicents.protocols.asn.External;
import org.restcomm.protocols.ss7.tcap.asn.EncodeException;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.UserInformation;
import org.restcomm.protocols.ss7.tcap.asn.comp.PAbortCauseType;

public class UserInformationImpl
implements UserInformation {
    private External ext = new External();

    @Override
    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 8 || localAis.getTagClass() != 0) {
                throw new AsnException("Error decoding UserInformation.sequence: wrong tag or tag class: tag=" + tag + ", tagClass=" + localAis.getTagClass());
            }
            this.ext.decode(localAis);
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException when decoding UserInformation: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException when decoding UserInformation: " + e.getMessage(), e);
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws EncodeException {
        try {
            aos.writeTag(2, false, 30);
            int pos = aos.StartContentDefiniteLength();
            this.ext.encode(aos);
            aos.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException when encoding UserInformation: " + e.getMessage(), e);
        }
    }

    @Override
    public byte[] getEncodeType() throws AsnException {
        return this.ext.getEncodeType();
    }

    @Override
    public void setEncodeType(byte[] data) {
        this.ext.setEncodeType(data);
    }

    @Override
    public BitSetStrictLength getEncodeBitStringType() throws AsnException {
        return this.ext.getEncodeBitStringType();
    }

    @Override
    public void setEncodeBitStringType(BitSetStrictLength data) {
        this.ext.setEncodeBitStringType(data);
    }

    @Override
    public boolean isOid() {
        return this.ext.isOid();
    }

    @Override
    public void setOid(boolean oid) {
        this.ext.setOid(oid);
    }

    @Override
    public boolean isInteger() {
        return this.ext.isInteger();
    }

    @Override
    public void setInteger(boolean integer) {
        this.ext.setInteger(integer);
    }

    @Override
    public boolean isObjDescriptor() {
        return this.ext.isObjDescriptor();
    }

    @Override
    public void setObjDescriptor(boolean objDescriptor) {
        this.ext.setObjDescriptor(objDescriptor);
    }

    @Override
    public long[] getOidValue() {
        return this.ext.getOidValue();
    }

    @Override
    public void setOidValue(long[] oidValue) {
        this.ext.setOidValue(oidValue);
    }

    @Override
    public long getIndirectReference() {
        return this.ext.getIndirectReference();
    }

    @Override
    public void setIndirectReference(long indirectReference) {
        this.ext.setIndirectReference(indirectReference);
    }

    @Override
    public String getObjDescriptorValue() {
        return this.ext.getObjDescriptorValue();
    }

    @Override
    public void setObjDescriptorValue(String objDescriptorValue) {
        this.ext.setObjDescriptorValue(objDescriptorValue);
    }

    @Override
    public boolean isAsn() {
        return this.ext.isAsn();
    }

    @Override
    public void setAsn(boolean asn) {
        this.ext.setAsn(asn);
    }

    @Override
    public boolean isOctet() {
        return this.ext.isOctet();
    }

    @Override
    public void setOctet(boolean octet) {
        this.ext.setOctet(octet);
    }

    @Override
    public boolean isArbitrary() {
        return this.ext.isArbitrary();
    }

    @Override
    public void setArbitrary(boolean arbitrary) {
        this.ext.setArbitrary(arbitrary);
    }
}

