/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.parameter;

public enum ReleaseCauseValue {
    END_USER_ORIGINATED(0),
    ITU_END_USER_CONGESTION_ANSI_END_USER_BUSY(1),
    END_USER_FAILURE(2),
    SCCP_USER_ORIGINATED(3),
    REMOTE_PROCEDURE_ERROR(4),
    INCONSISTENT_CONNECTION_DATA(5),
    ACCESS_FAULURE(6),
    ACCESS_CONGESTION(7),
    SUBSYSTEM_FAILURE(8),
    SUBSYSTEM_CONGESTION(9),
    MTP_FAILURE(10),
    NETWORK_CONGESTION(11),
    EXPIRATION_OF_RESET_TIMER(12),
    EXPIRATION_OF_RECEIVE_INACTIVITY_TIMER(13),
    UNQUALIFIED(15),
    SCCP_FAILURE(16);

    private int code;

    private ReleaseCauseValue(int code) {
        this.code = code;
    }

    public int getValue() {
        return this.code;
    }

    public static ReleaseCauseValue getInstance(int code) {
        switch (code) {
            case 0: {
                return END_USER_ORIGINATED;
            }
            case 1: {
                return ITU_END_USER_CONGESTION_ANSI_END_USER_BUSY;
            }
            case 2: {
                return END_USER_FAILURE;
            }
            case 3: {
                return SCCP_USER_ORIGINATED;
            }
            case 4: {
                return REMOTE_PROCEDURE_ERROR;
            }
            case 5: {
                return INCONSISTENT_CONNECTION_DATA;
            }
            case 6: {
                return ACCESS_FAULURE;
            }
            case 7: {
                return ACCESS_CONGESTION;
            }
            case 8: {
                return SUBSYSTEM_FAILURE;
            }
            case 9: {
                return SUBSYSTEM_CONGESTION;
            }
            case 10: {
                return MTP_FAILURE;
            }
            case 11: {
                return NETWORK_CONGESTION;
            }
            case 12: {
                return EXPIRATION_OF_RESET_TIMER;
            }
            case 13: {
                return EXPIRATION_OF_RECEIVE_INACTIVITY_TIMER;
            }
            case 15: {
                return UNQUALIFIED;
            }
            case 16: {
                return SCCP_FAILURE;
            }
        }
        return UNQUALIFIED;
    }

    public boolean isError() {
        switch (this) {
            case END_USER_FAILURE: 
            case REMOTE_PROCEDURE_ERROR: 
            case ACCESS_FAULURE: 
            case SUBSYSTEM_FAILURE: 
            case MTP_FAILURE: 
            case EXPIRATION_OF_RESET_TIMER: 
            case EXPIRATION_OF_RECEIVE_INACTIVITY_TIMER: 
            case SCCP_FAILURE: {
                return true;
            }
        }
        return false;
    }
}

