/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.protocols.ss7.indicator.GlobalTitleIndicator;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.parameter.AbstractGlobalTitle;
import org.restcomm.protocols.ss7.sccp.impl.parameter.BCDEvenEncodingScheme;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.parameter.EncodingScheme;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle0010;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;

public class GlobalTitle0010Impl
extends AbstractGlobalTitle
implements GlobalTitle0010 {
    private int translationType;
    protected static final XMLFormat<GlobalTitle0010Impl> XML = new XMLFormat<GlobalTitle0010Impl>(GlobalTitle0010Impl.class){

        @Override
        public void write(GlobalTitle0010Impl ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("tt", ai.translationType);
            xml.setAttribute("digits", ai.digits);
        }

        @Override
        public void read(XMLFormat.InputElement xml, GlobalTitle0010Impl ai) throws XMLStreamException {
            ai.translationType = xml.getAttribute("tt").toInt();
            ai.digits = xml.getAttribute("digits").toString();
        }
    };

    public GlobalTitle0010Impl() {
    }

    public GlobalTitle0010Impl(String digits, int translationType) {
        this();
        if (digits == null) {
            throw new IllegalArgumentException();
        }
        this.translationType = translationType;
        this.digits = digits;
        this.encodingScheme = this.getEncodingScheme(translationType);
    }

    protected EncodingScheme getEncodingScheme(int translationType) {
        return BCDEvenEncodingScheme.INSTANCE;
    }

    @Override
    public GlobalTitleIndicator getGlobalTitleIndicator() {
        return GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY;
    }

    @Override
    public int getTranslationType() {
        return this.translationType;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            this.translationType = in.read() & 0xFF;
            this.encodingScheme = this.getEncodingScheme(this.translationType);
            this.digits = this.encodingScheme.decode(in);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void encode(OutputStream out, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            out.write(this.translationType);
            if (this.digits == null) {
                throw new IllegalStateException();
            }
            this.encodingScheme.encode(this.digits, out);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.translationType;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalTitle0010Impl other = (GlobalTitle0010Impl)obj;
        return this.translationType == other.translationType;
    }

    public String toString() {
        return "GlobalTitle0010Impl [digits=" + this.digits + ", translationType=" + this.translationType + ", encodingScheme=" + this.encodingScheme + "]";
    }
}

