/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.restcomm.protocols.ss7.sccp.SccpConnection;
import org.restcomm.protocols.ss7.sccp.SccpConnectionState;
import org.restcomm.protocols.ss7.sccp.SccpListener;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionWithTransmitQueueImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpRoutingControl;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCcMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnItMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRscMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.CreditImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ReleaseCauseImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SequenceNumberImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SequencingSegmentingImpl;
import org.restcomm.protocols.ss7.sccp.message.SccpConnMessage;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;
import org.restcomm.protocols.ss7.sccp.parameter.ReleaseCauseValue;

abstract class SccpConnectionWithTimers
extends SccpConnectionWithTransmitQueueImpl {
    private ConnEstProcess connEstProcess = new ConnEstProcess();
    private IasInactivitySendProcess iasInactivitySendProcess = new IasInactivitySendProcess();
    private IarInactivityReceiveProcess iarInactivityReceiveProcess = new IarInactivityReceiveProcess();
    private RelProcess relProcess = new RelProcess();
    private RepeatRelProcess repeatRelProcess = new RepeatRelProcess();
    private IntProcess intProcess = new IntProcess();
    private GuardProcess guardProcess = new GuardProcess();
    private ResetProcess resetProcess = new ResetProcess();

    public SccpConnectionWithTimers(int sls, int localSsn, LocalReference localReference, ProtocolClass protocol, SccpStackImpl stack, SccpRoutingControl sccpRoutingControl) {
        super(sls, localSsn, localReference, protocol, stack, sccpRoutingControl);
    }

    protected void stopTimers() {
        this.connEstProcess.stopTimer();
        this.iasInactivitySendProcess.stopTimer();
        this.iarInactivityReceiveProcess.stopTimer();
        this.relProcess.stopTimer();
        this.repeatRelProcess.stopTimer();
        this.intProcess.stopTimer();
        this.guardProcess.stopTimer();
        this.resetProcess.stopTimer();
    }

    @Override
    protected void receiveMessage(SccpConnMessage message) throws Exception {
        this.iarInactivityReceiveProcess.resetTimer();
        if (message instanceof SccpConnCcMessageImpl) {
            this.connEstProcess.stopTimer();
        } else if (message instanceof SccpConnRscMessageImpl) {
            this.resetProcess.stopTimer();
        }
        super.receiveMessage(message);
    }

    @Override
    protected void sendMessage(SccpConnMessage message) throws Exception {
        if (this.stack.state != SccpStackImpl.State.RUNNING) {
            this.logger.error("Trying to send SCCP message from SCCP user but SCCP stack is not RUNNING");
            return;
        }
        this.iasInactivitySendProcess.resetTimer();
        super.sendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(SccpConnectionState state) {
        try {
            this.connectionLock.lock();
            super.setState(state);
            if (state == SccpConnectionState.RSR_SENT) {
                this.resetProcess.startTimer();
            } else if (state == SccpConnectionState.DISCONNECT_INITIATED) {
                this.relProcess.startTimer();
                this.iasInactivitySendProcess.stopTimer();
                this.iarInactivityReceiveProcess.stopTimer();
            } else if (state == SccpConnectionState.CONNECTION_INITIATED) {
                this.connEstProcess.startTimer();
            }
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    private class BaseProcess
    implements Runnable {
        protected long delay;
        private Future future;

        private BaseProcess() {
            this.delay = SccpConnectionWithTimers.this.stack.getConnEstTimerDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startTimer() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (this.future != null) {
                    SccpConnectionWithTimers.this.logger.error(new IllegalStateException(String.format("Already started %s timer", this.getClass())));
                }
                this.future = SccpConnectionWithTimers.this.stack.timerExecutors.schedule(this, this.delay, TimeUnit.MILLISECONDS);
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopTimer() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (this.future != null) {
                    this.future.cancel(false);
                    this.future = null;
                }
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }

        public void resetTimer() {
            this.stopTimer();
            this.startTimer();
        }

        public boolean isStarted() {
            return this.future != null;
        }

        @Override
        public void run() {
        }
    }

    protected class ResetProcess
    extends BaseProcess
    implements Runnable {
        protected ResetProcess() {
            this.delay = SccpConnectionWithTimers.this.stack.getResetTimerDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (SccpConnectionWithTimers.this.getState() == SccpConnectionState.CLOSED) {
                    return;
                }
                SccpConnectionWithTimers.this.disconnect(new ReleaseCauseImpl(ReleaseCauseValue.SCCP_FAILURE), new byte[0]);
                SccpConnectionWithTimers.this.stack.removeConnection(SccpConnectionWithTimers.this.getLocalReference());
            }
            catch (Exception e) {
                SccpConnectionWithTimers.this.logger.error(e);
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }
    }

    protected class GuardProcess
    extends BaseProcess
    implements Runnable {
        protected GuardProcess() {
            this.delay = SccpConnectionWithTimers.this.stack.getGuardTimerDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (SccpConnectionWithTimers.this.getState() == SccpConnectionState.CLOSED) {
                    return;
                }
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }
    }

    protected class IntProcess
    extends BaseProcess
    implements Runnable {
        protected IntProcess() {
            this.delay = SccpConnectionWithTimers.this.stack.getIntTimerDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startTimer() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (this.isStarted()) {
                    return;
                }
                super.startTimer();
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (SccpConnectionWithTimers.this.getState() == SccpConnectionState.CLOSED) {
                    return;
                }
                SccpConnectionWithTimers.this.repeatRelProcess.stopTimer();
                SccpListener listener = SccpConnectionWithTimers.this.getListener();
                if (listener != null) {
                    listener.onDisconnectIndication((SccpConnection)((Object)SccpConnectionWithTimers.this), new ReleaseCauseImpl(ReleaseCauseValue.SCCP_FAILURE), new byte[0]);
                }
                SccpConnectionWithTimers.this.stack.removeConnection(SccpConnectionWithTimers.this.getLocalReference());
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }
    }

    protected class RepeatRelProcess
    extends BaseProcess
    implements Runnable {
        protected RepeatRelProcess() {
            this.delay = SccpConnectionWithTimers.this.stack.getRepeatRelTimerDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startTimer() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (this.isStarted()) {
                    return;
                }
                super.startTimer();
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (SccpConnectionWithTimers.this.getState() == SccpConnectionState.CLOSED) {
                    return;
                }
                SccpConnectionWithTimers.this.disconnect(new ReleaseCauseImpl(ReleaseCauseValue.SCCP_FAILURE), new byte[0]);
                SccpConnectionWithTimers.this.repeatRelProcess.startTimer();
            }
            catch (Exception e) {
                SccpConnectionWithTimers.this.logger.error(e);
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }
    }

    protected class RelProcess
    extends BaseProcess
    implements Runnable {
        protected RelProcess() {
            this.delay = SccpConnectionWithTimers.this.stack.getRelTimerDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startTimer() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (this.isStarted()) {
                    return;
                }
                super.startTimer();
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (SccpConnectionWithTimers.this.getState() == SccpConnectionState.CLOSED) {
                    return;
                }
                SccpConnectionWithTimers.this.disconnect(new ReleaseCauseImpl(ReleaseCauseValue.SCCP_FAILURE), new byte[0]);
                SccpConnectionWithTimers.this.intProcess.startTimer();
                SccpConnectionWithTimers.this.repeatRelProcess.startTimer();
            }
            catch (Exception e) {
                SccpConnectionWithTimers.this.logger.error(e);
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }
    }

    protected class IarInactivityReceiveProcess
    extends BaseProcess
    implements Runnable {
        protected IarInactivityReceiveProcess() {
            this.delay = SccpConnectionWithTimers.this.stack.getIarTimerDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (SccpConnectionWithTimers.this.getState() == SccpConnectionState.CLOSED) {
                    return;
                }
                SccpConnectionWithTimers.this.disconnect(new ReleaseCauseImpl(ReleaseCauseValue.EXPIRATION_OF_RECEIVE_INACTIVITY_TIMER), new byte[0]);
            }
            catch (Exception e) {
                SccpConnectionWithTimers.this.logger.error(e);
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }
    }

    protected class IasInactivitySendProcess
    extends BaseProcess
    implements Runnable {
        protected IasInactivitySendProcess() {
            this.delay = SccpConnectionWithTimers.this.stack.getIasTimerDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (SccpConnectionWithTimers.this.getState() == SccpConnectionState.CLOSED || SccpConnectionWithTimers.this.getState() == SccpConnectionState.CONNECTION_INITIATED) {
                    return;
                }
                SccpConnItMessageImpl it = new SccpConnItMessageImpl(SccpConnectionWithTimers.this.getSls(), SccpConnectionWithTimers.this.getLocalSsn());
                it.setProtocolClass(SccpConnectionWithTimers.this.getProtocolClass());
                it.setSourceLocalReferenceNumber(SccpConnectionWithTimers.this.getLocalReference());
                it.setDestinationLocalReferenceNumber(SccpConnectionWithTimers.this.getRemoteReference());
                it.setCredit(new CreditImpl(0));
                it.setSequencingSegmenting(new SequencingSegmentingImpl(new SequenceNumberImpl(0, false), new SequenceNumberImpl(0, false), SccpConnectionWithTimers.this.lastMoreDataSent));
                SccpConnectionWithTimers.this.prepareMessageForSending(it);
                SccpConnectionWithTimers.this.sendMessage(it);
            }
            catch (Exception e) {
                SccpConnectionWithTimers.this.logger.error(e);
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }
    }

    protected class ConnEstProcess
    extends BaseProcess
    implements Runnable {
        protected ConnEstProcess() {
            this.delay = SccpConnectionWithTimers.this.stack.getConnEstTimerDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SccpConnectionWithTimers.this.connectionLock.lock();
                if (SccpConnectionWithTimers.this.getState() == SccpConnectionState.CLOSED) {
                    return;
                }
                SccpConnectionWithTimers.this.disconnect(new ReleaseCauseImpl(ReleaseCauseValue.SCCP_FAILURE), new byte[0]);
            }
            catch (Exception e) {
                SccpConnectionWithTimers.this.logger.error(e);
            }
            finally {
                SccpConnectionWithTimers.this.connectionLock.unlock();
            }
        }
    }
}

