/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.mtp;

import java.nio.ByteBuffer;

public class Utils {
    public static final byte _VALUE_NOT_SET = -1;

    public static final String dump(ByteBuffer buff, int size, boolean asBits) {
        return Utils.dump(buff.array(), size, asBits);
    }

    public static final String dump(byte[] buff, int size, boolean asBits) {
        String s = "";
        for (int i = 0; i < size; ++i) {
            String ss = null;
            ss = !asBits ? Integer.toHexString(buff[i] & 0xFF) : Integer.toBinaryString(buff[i] & 0xFF);
            ss = Utils.fillInZeroPrefix(ss, asBits);
            s = s + " " + ss;
        }
        return s;
    }

    public static final String fillInZeroPrefix(String ss, boolean asBits) {
        if (asBits) {
            if (ss.length() < 8) {
                for (int j = ss.length(); j < 8; ++j) {
                    ss = "0" + ss;
                }
            }
        } else if (ss.length() < 2) {
            ss = "0" + ss;
        }
        return ss;
    }

    public static final String dump(int[] buff, int size) {
        String s = "";
        for (int i = 0; i < size; ++i) {
            String ss = Integer.toHexString(buff[i] & 0xFF);
            if (ss.length() == 1) {
                ss = "0" + ss;
            }
            s = s + " " + ss;
        }
        return s;
    }

    public static void createTrace(Throwable t, StringBuilder sb, boolean top) {
        if (!top) {
            sb.append("\nCaused by: " + t.toString());
        }
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            sb.append("\tat " + trace[i]);
        }
        Throwable ourCause = t.getCause();
        if (ourCause != null) {
            Utils.createTrace(ourCause, sb, false);
        }
    }

    public static String createTrace(Throwable t) {
        StringBuilder sb = new StringBuilder();
        Utils.createTrace(t, sb, true);
        return sb.toString();
    }

    public static String hexDump(String label, byte[] bytes) {
        int indent;
        int modulo = 16;
        int brk = 8;
        StringBuffer sb = new StringBuffer(indent + 1);
        for (indent = label == null ? 0 : label.length(); indent > 0; --indent) {
            sb.append(" ");
        }
        String ind = sb.toString();
        if (bytes == null) {
            return null;
        }
        sb = new StringBuffer(bytes.length * 4);
        StringBuffer cb = new StringBuffer(16);
        boolean nl = true;
        int i = 0;
        for (i = 1; i <= bytes.length; ++i) {
            if (nl) {
                nl = false;
                if (i > 1) {
                    sb.append(ind);
                } else if (label != null) {
                    sb.append(label);
                }
                String ha = Integer.toHexString(i - 1);
                for (int j = ha.length(); j <= 8; ++j) {
                    sb.append("0");
                }
                sb.append(ha).append(" ");
            }
            sb.append(" ");
            int c = bytes[i - 1] & 0xFF;
            String hx = Integer.toHexString(c).toUpperCase();
            if (hx.length() == 1) {
                sb.append("0");
            }
            sb.append(hx);
            cb.append(c < 33 || c > 126 ? (char)'.' : (char)c);
            if (i % 8 == 0) {
                sb.append(" ");
            }
            if (i % 16 != 0) continue;
            sb.append("|").append(cb).append("|\n");
            nl = true;
            cb = new StringBuffer(16);
        }
        int mod = i % 16;
        if (mod != 1) {
            while (mod <= 16) {
                sb.append("   ");
                if (mod % 8 == 0) {
                    sb.append(" ");
                }
                ++mod;
            }
            sb.append("|").append(cb).append("|\n");
        }
        return sb.toString();
    }
}

