/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.mtp;

import org.restcomm.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.restcomm.protocols.ss7.mtp.RoutingLabelFormat;

public class Mtp3TransferPrimitiveFactory {
    private final RoutingLabelFormat pointCodeFormat;

    public Mtp3TransferPrimitiveFactory(RoutingLabelFormat pointCodeFormat) {
        this.pointCodeFormat = pointCodeFormat;
    }

    public Mtp3TransferPrimitive createMtp3TransferPrimitive(int si, int ni, int mp, int opc, int dpc, int sls, byte[] data) {
        Mtp3TransferPrimitive mtp3TransferPrimitive = new Mtp3TransferPrimitive(si, ni, mp, opc, dpc, sls, data, this.pointCodeFormat);
        return mtp3TransferPrimitive;
    }

    public Mtp3TransferPrimitive createMtp3TransferPrimitive(byte[] msg) {
        Mtp3TransferPrimitive mtp3TransferPrimitive = null;
        byte sio = msg[0];
        int si = sio & 0xF;
        int ssi = (sio & 0xF0) >> 4;
        int ni = ssi >> 2;
        int mp = ssi & 3;
        int dpc = 0;
        int opc = 0;
        int sls = 0;
        byte[] data = null;
        switch (this.pointCodeFormat) {
            case ITU: {
                byte b1 = msg[1];
                byte b2 = msg[2];
                byte b3 = msg[3];
                byte b4 = msg[4];
                dpc = (b2 & 0x3F) << 8 | b1 & 0xFF;
                opc = (b4 & 0xF) << 10 | (b3 & 0xFF) << 2 | (b2 & 0xC0) >> 6;
                sls = (b4 & 0xF0) >> 4;
                data = new byte[msg.length - 5];
                System.arraycopy(msg, 5, data, 0, data.length);
                break;
            }
            case ANSI_Sls8Bit: {
                dpc = (msg[3] & 0xFF) << 16 | (msg[2] & 0xFF) << 8 | msg[1] & 0xFF;
                opc = (msg[6] & 0xFF) << 16 | (msg[5] & 0xFF) << 8 | msg[4] & 0xFF;
                sls = msg[7] & 0xFF;
                data = new byte[msg.length - 8];
                System.arraycopy(msg, 8, data, 0, data.length);
                break;
            }
            case ANSI_Sls5Bit: {
                dpc = (msg[3] & 0xFF) << 16 | (msg[2] & 0xFF) << 8 | msg[1] & 0xFF;
                opc = (msg[6] & 0xFF) << 16 | (msg[5] & 0xFF) << 8 | msg[4] & 0xFF;
                sls = msg[7] & 0x1F;
                data = new byte[msg.length - 8];
                System.arraycopy(msg, 8, data, 0, data.length);
                break;
            }
        }
        mtp3TransferPrimitive = new Mtp3TransferPrimitive(si, ni, mp, opc, dpc, sls, data, this.pointCodeFormat);
        return mtp3TransferPrimitive;
    }
}

