/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPMessageType;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.BasicServiceCode;
import org.restcomm.protocols.ss7.map.api.service.supplementary.ForwardingFeature;
import org.restcomm.protocols.ss7.map.api.service.supplementary.GenericServiceInfo;
import org.restcomm.protocols.ss7.map.api.service.supplementary.InterrogateSSResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.SSStatus;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.BasicServiceCodeImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.ForwardingFeatureImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.GenericServiceInfoImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.SSStatusImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.SupplementaryMessageImpl;

public class InterrogateSSResponseImpl
extends SupplementaryMessageImpl
implements InterrogateSSResponse {
    public static final int _TAG_ssStatus = 0;
    public static final int _TAG_basicServiceGroupList = 2;
    public static final int _TAG_forwardingFeatureList = 3;
    public static final int _TAG_genericServiceInfo = 4;
    public static final String _PrimitiveName = "InterrogateSSResponse";
    private SSStatus ssStatus;
    private ArrayList<BasicServiceCode> basicServiceGroupList;
    private ArrayList<ForwardingFeature> forwardingFeatureList;
    private GenericServiceInfo genericServiceInfo;

    public InterrogateSSResponseImpl() {
    }

    public InterrogateSSResponseImpl(SSStatus ssStatus) {
        this.ssStatus = ssStatus;
    }

    public InterrogateSSResponseImpl(ArrayList<BasicServiceCode> basicServiceGroupList, boolean doommyPar) {
        this.basicServiceGroupList = basicServiceGroupList;
    }

    public InterrogateSSResponseImpl(ArrayList<ForwardingFeature> forwardingFeatureList) {
        this.forwardingFeatureList = forwardingFeatureList;
    }

    public InterrogateSSResponseImpl(GenericServiceInfo genericServiceInfo) {
        this.genericServiceInfo = genericServiceInfo;
    }

    @Override
    public MAPMessageType getMessageType() {
        return MAPMessageType.interrogateSS_Response;
    }

    @Override
    public int getOperationCode() {
        return 14;
    }

    @Override
    public SSStatus getSsStatus() {
        return this.ssStatus;
    }

    @Override
    public ArrayList<BasicServiceCode> getBasicServiceGroupList() {
        return this.basicServiceGroupList;
    }

    @Override
    public ArrayList<ForwardingFeature> getForwardingFeatureList() {
        return this.forwardingFeatureList;
    }

    @Override
    public GenericServiceInfo getGenericServiceInfo() {
        return this.genericServiceInfo;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.ssStatus != null) {
            return 0;
        }
        if (this.basicServiceGroupList != null) {
            return 2;
        }
        if (this.forwardingFeatureList != null) {
            return 3;
        }
        if (this.genericServiceInfo != null) {
            return 4;
        }
        throw new MAPException("No of choices are supplied");
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.ssStatus != null;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding InterrogateSSResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding InterrogateSSResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding InterrogateSSResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding InterrogateSSResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssStatus = null;
        this.basicServiceGroupList = null;
        this.forwardingFeatureList = null;
        this.genericServiceInfo = null;
        if (ais.getTagClass() != 2) {
            throw new MAPParsingComponentException("Error while decoding InterrogateSSResponse: bad tag class: TagClass=" + ais.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ais.getTag()) {
            case 0: {
                this.ssStatus = new SSStatusImpl();
                ((SSStatusImpl)this.ssStatus).decodeData(ais, length);
                break;
            }
            case 2: {
                if (ais.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error while decoding InterrogateSSResponse.basicServiceGroupList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                AsnInputStream ais2 = ais.readSequenceStreamData(length);
                this.basicServiceGroupList = new ArrayList();
                while (ais2.available() != 0) {
                    ais2.readTag();
                    BasicServiceCodeImpl basicServiceCode = new BasicServiceCodeImpl();
                    basicServiceCode.decodeAll(ais2);
                    this.basicServiceGroupList.add(basicServiceCode);
                }
                if (this.basicServiceGroupList.size() >= 1 && this.basicServiceGroupList.size() <= 13) break;
                throw new MAPParsingComponentException("Error while decoding InterrogateSSResponse: Parameter basicServiceGroupList size must be from 1 to 13, found: " + this.basicServiceGroupList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            case 3: {
                if (ais.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error while decoding InterrogateSSResponse.forwardingFeatureList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                AsnInputStream ais2 = ais.readSequenceStreamData(length);
                this.forwardingFeatureList = new ArrayList();
                while (ais2.available() != 0) {
                    ais2.readTag();
                    ForwardingFeatureImpl forwardingFeature = new ForwardingFeatureImpl();
                    forwardingFeature.decodeAll(ais2);
                    this.forwardingFeatureList.add(forwardingFeature);
                }
                if (this.forwardingFeatureList.size() >= 1 && this.forwardingFeatureList.size() <= 13) break;
                throw new MAPParsingComponentException("Error while decoding InterrogateSSResponse: Parameter forwardingFeatureList size must be from 1 to 13, found: " + this.forwardingFeatureList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            case 4: {
                this.genericServiceInfo = new GenericServiceInfoImpl();
                ((GenericServiceInfoImpl)this.genericServiceInfo).decodeData(ais, length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while InterrogateSSResponse: bad tag: " + ais.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding InterrogateSSResponse: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        int cnt = 0;
        if (this.ssStatus != null) {
            ++cnt;
        }
        if (this.basicServiceGroupList != null) {
            ++cnt;
        }
        if (this.forwardingFeatureList != null) {
            ++cnt;
        }
        if (this.genericServiceInfo != null) {
            ++cnt;
        }
        if (cnt == 0) {
            throw new MAPException("Error while encoding InterrogateSSResponse: no option is set.");
        }
        if (cnt > 1) {
            throw new MAPException("Error while encoding InterrogateSSResponse: more than 1 option is set.");
        }
        if (this.ssStatus != null) {
            ((SSStatusImpl)this.ssStatus).encodeData(asnOs);
        }
        if (this.basicServiceGroupList != null) {
            for (BasicServiceCode basicServiceCode : this.basicServiceGroupList) {
                ((BasicServiceCodeImpl)basicServiceCode).encodeAll(asnOs);
            }
        }
        if (this.forwardingFeatureList != null) {
            for (ForwardingFeature forwardingFeature : this.forwardingFeatureList) {
                ((ForwardingFeatureImpl)forwardingFeature).encodeAll(asnOs);
            }
        }
        if (this.genericServiceInfo != null) {
            ((GenericServiceInfoImpl)this.genericServiceInfo).encodeData(asnOs);
        }
    }

    @Override
    public String toString() {
        boolean firstItem;
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.ssStatus != null) {
            sb.append("ssStatus=");
            sb.append(this.ssStatus);
            sb.append(", ");
        }
        if (this.basicServiceGroupList != null) {
            sb.append("basicServiceGroupList=[");
            firstItem = true;
            for (BasicServiceCode basicServiceCode : this.basicServiceGroupList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(basicServiceCode.toString());
            }
            sb.append("], ");
        }
        if (this.forwardingFeatureList != null) {
            sb.append("forwardingFeatureList=[");
            firstItem = true;
            for (ForwardingFeature forwardingFeature : this.forwardingFeatureList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(forwardingFeature.toString());
            }
            sb.append("], ");
        }
        if (this.genericServiceInfo != null) {
            sb.append("genericServiceInfo=");
            sb.append(this.genericServiceInfo);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

