/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.supplementary.ForwardingOptions;
import org.restcomm.protocols.ss7.map.api.service.supplementary.ForwardingReason;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class ForwardingOptionsImpl
implements ForwardingOptions,
MAPAsnPrimitive {
    private ForwardingReason forwardingReason;
    private int code = 0;
    private static final int MASK_notificationForwarding = 128;
    private static final int MASK_redirectingPresentation = 64;
    private static final int MASK_notificationCalling = 32;
    private static final int MASK_forwardingReason = 12;
    private static final int MASK_forwardingOptions = 236;
    private static final String _PrimitiveName = "ForwardingOptions";

    public ForwardingOptionsImpl() {
    }

    public ForwardingOptionsImpl(boolean notificationToForwardingParty, boolean redirectingPresentation, boolean notificationToCallingParty, ForwardingReason forwardingReason) {
        this.forwardingReason = forwardingReason;
        int forwardingReasonCode = 3;
        if (forwardingReason != null) {
            forwardingReasonCode = forwardingReason.getCode();
        }
        this.code &= 0xEC;
        this.code = notificationToForwardingParty ? this.code | 0x80 : this.code & 0xFFFFFF7F;
        this.code = redirectingPresentation ? this.code | 0x40 : this.code & 0xFFFFFFBF;
        this.code = notificationToCallingParty ? this.code | 0x20 : this.code & 0xFFFFFFDF;
        this.code |= forwardingReasonCode << 2 & 0xC;
    }

    @Override
    public boolean isNotificationToCallingParty() {
        return (this.code & 0x20) >> 5 == 1;
    }

    @Override
    public boolean isNotificationToForwardingParty() {
        return (this.code & 0x80) >> 7 == 1;
    }

    @Override
    public boolean isRedirectingPresentation() {
        return (this.code & 0x40) >> 6 == 1;
    }

    @Override
    public ForwardingReason getForwardingReason() {
        return this.forwardingReason;
    }

    @Override
    public int getData() {
        return this.code;
    }

    @Override
    public int getTag() throws MAPException {
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ForwardingOptions: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ForwardingOptions: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ForwardingOptions: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ForwardingOptions: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (length != 1) {
            throw new MAPParsingComponentException("Error decoding ForwardingOptions: the ForwardingOptions field must contain 1 octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.code = ais.readOctetStringData(length)[0];
        this.forwardingReason = ForwardingReason.getForwardingReason((this.code & 0xC) >> 2);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ForwardingOptions: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        asnOs.writeOctetStringData(new byte[]{(byte)this.code});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        sb.append("NotificationToCallingParty: ");
        sb.append(this.isNotificationToCallingParty());
        sb.append(',');
        sb.append("NotificationToForwardingParty: ");
        sb.append(this.isNotificationToForwardingParty());
        sb.append(',');
        sb.append("RedirectingPresentation: ");
        sb.append(this.isRedirectingPresentation());
        sb.append(',');
        sb.append("forwardingReason: ");
        sb.append((Object)this.forwardingReason);
        sb.append("]");
        return sb.toString();
    }
}

