/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.GMLCRestriction;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.NotificationToMSUser;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.ServiceType;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;

public class ServiceTypeImpl
extends SequenceBase
implements ServiceType {
    private static final int _TAG_gmlcRestriction = 0;
    private static final int _TAG_notificationToMSUser = 1;
    private static final int _TAG_extensionContainer = 2;
    private int serviceTypeIdentity;
    private GMLCRestriction gmlcRestriction;
    private NotificationToMSUser notificationToMSUser;
    private MAPExtensionContainer extensionContainer;

    public ServiceTypeImpl() {
        super("ServiceType");
    }

    public ServiceTypeImpl(int serviceTypeIdentity, GMLCRestriction gmlcRestriction, NotificationToMSUser notificationToMSUser, MAPExtensionContainer extensionContainer) {
        super("ServiceType");
        this.serviceTypeIdentity = serviceTypeIdentity;
        this.gmlcRestriction = gmlcRestriction;
        this.notificationToMSUser = notificationToMSUser;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public int getServiceTypeIdentity() {
        return this.serviceTypeIdentity;
    }

    @Override
    public GMLCRestriction getGMLCRestriction() {
        return this.gmlcRestriction;
    }

    @Override
    public NotificationToMSUser getNotificationToMSUser() {
        return this.notificationToMSUser;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.serviceTypeIdentity = -1;
        this.gmlcRestriction = null;
        this.notificationToMSUser = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 2 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".serviceTypeIdentity: bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.serviceTypeIdentity = (int)ais.readInteger();
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 0: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".gmlcRestriction: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    int i1 = (int)ais.readInteger();
                                    this.gmlcRestriction = GMLCRestriction.getInstance(i1);
                                    break block0;
                                }
                                case 1: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".notificationToMSUser: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    int i2 = (int)ais.readInteger();
                                    this.notificationToMSUser = NotificationToMSUser.getInstance(i2);
                                    break block0;
                                }
                                case 2: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (this.serviceTypeIdentity == -1) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament serviceTypeIdentity is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            asnOs.writeInteger(this.serviceTypeIdentity);
            if (this.gmlcRestriction != null) {
                asnOs.writeInteger(2, 0, this.gmlcRestriction.getCode());
            }
            if (this.notificationToMSUser != null) {
                asnOs.writeInteger(2, 1, this.notificationToMSUser.getCode());
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        sb.append("serviceTypeIdentity=");
        sb.append(this.serviceTypeIdentity);
        sb.append(", ");
        if (this.gmlcRestriction != null) {
            sb.append("gmlcRestriction=");
            sb.append(this.gmlcRestriction.toString());
            sb.append(", ");
        }
        if (this.notificationToMSUser != null) {
            sb.append("notificationToMSUser=");
            sb.append(this.notificationToMSUser.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

