/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.primitives;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.IMSI;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.SubscriberIdentity;
import org.restcomm.protocols.ss7.map.primitives.IMSIImpl;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class SubscriberIdentityImpl
implements SubscriberIdentity,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "SubscriberIdentity";
    private static final int _TAG_IMSI = 0;
    private static final int _TAG_MSISDN = 1;
    private IMSI imsi = null;
    private ISDNAddressString msisdn = null;

    public SubscriberIdentityImpl() {
    }

    public SubscriberIdentityImpl(IMSI imsi) {
        this.imsi = imsi;
        this.msisdn = null;
    }

    public SubscriberIdentityImpl(ISDNAddressString msisdn) {
        this.msisdn = msisdn;
        this.imsi = null;
    }

    @Override
    public IMSI getIMSI() {
        return this.imsi;
    }

    @Override
    public ISDNAddressString getMSISDN() {
        return this.msisdn;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.imsi != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SubscriberIdentity: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SubscriberIdentity: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SubscriberIdentity: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SubscriberIdentity: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (asnIS.getTagClass() != 2 || !asnIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding SubscriberIdentity: bad tag class or is not primitive: TagClass=" + asnIS.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (asnIS.getTag()) {
            case 0: {
                this.imsi = new IMSIImpl();
                ((IMSIImpl)this.imsi).decodeData(asnIS, length);
                break;
            }
            case 1: {
                this.msisdn = new ISDNAddressStringImpl();
                ((ISDNAddressStringImpl)this.msisdn).decodeData(asnIS, length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while decoding SubscriberIdentity: Expexted imsi [0] IMSI or msisdn [1] ISDN-AddressString, but found " + asnIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SubscriberIdentity: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.imsi == null && this.msisdn == null) {
            throw new MAPException("Error while encoding SubscriberIdentity: all choices must not be null");
        }
        if (this.imsi != null && this.msisdn != null) {
            throw new MAPException("Error while encoding SubscriberIdentity: all choices must not be not null");
        }
        if (this.imsi != null) {
            ((IMSIImpl)this.imsi).encodeData(asnOs);
        } else {
            ((ISDNAddressStringImpl)this.msisdn).encodeData(asnOs);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.imsi == null ? 0 : this.imsi.hashCode());
        result = 31 * result + (this.msisdn == null ? 0 : this.msisdn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriberIdentityImpl other = (SubscriberIdentityImpl)obj;
        if (this.imsi == null ? other.imsi != null : !this.imsi.equals(other.imsi)) {
            return false;
        }
        return !(this.msisdn == null ? other.msisdn != null : !this.msisdn.equals(other.msisdn));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append(" imsi=");
            sb.append(this.imsi);
        }
        if (this.msisdn != null) {
            sb.append(" msisdn=");
            sb.append(this.msisdn);
        }
        sb.append("]");
        return sb.toString();
    }
}

