/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl.parameter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javolution.text.TextBuilder;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.LocalRKIdentifierImpl;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.ParameterImpl;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.RegistrationStatusImpl;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.RoutingContextImpl;
import org.restcomm.protocols.ss7.m3ua.parameter.LocalRKIdentifier;
import org.restcomm.protocols.ss7.m3ua.parameter.RegistrationResult;
import org.restcomm.protocols.ss7.m3ua.parameter.RegistrationStatus;
import org.restcomm.protocols.ss7.m3ua.parameter.RoutingContext;

public class RegistrationResultImpl
extends ParameterImpl
implements RegistrationResult {
    private LocalRKIdentifier localRKId;
    private RegistrationStatus status;
    private RoutingContext rc;
    private ByteBuf buf = Unpooled.buffer(24);
    private byte[] value;

    public RegistrationResultImpl(byte[] data) {
        this.tag = (short)520;
        block5: for (int pos = 0; pos < data.length; pos += pos % 4) {
            short tag = (short)((data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF);
            short len = (short)((data[pos + 2] & 0xFF) << 8 | data[pos + 3] & 0xFF);
            byte[] value = new byte[len - 4];
            System.arraycopy(data, pos + 4, value, 0, value.length);
            pos += len;
            switch (tag) {
                case 522: {
                    this.localRKId = new LocalRKIdentifierImpl(value);
                    continue block5;
                }
                case 6: {
                    this.rc = new RoutingContextImpl(value);
                    continue block5;
                }
                case 530: {
                    this.status = new RegistrationStatusImpl(value);
                }
            }
        }
    }

    public RegistrationResultImpl(LocalRKIdentifier localRKId, RegistrationStatus status, RoutingContext rc) {
        this.tag = (short)520;
        this.localRKId = localRKId;
        this.status = status;
        this.rc = rc;
        this.encode();
    }

    private void encode() {
        ((LocalRKIdentifierImpl)this.localRKId).write(this.buf);
        ((RoutingContextImpl)this.rc).write(this.buf);
        ((RegistrationStatusImpl)this.status).write(this.buf);
        int length = this.buf.readableBytes();
        this.value = new byte[length];
        this.buf.getBytes(this.buf.readerIndex(), this.value);
    }

    @Override
    protected byte[] getValue() {
        return this.value;
    }

    @Override
    public LocalRKIdentifier getLocalRKIdentifier() {
        return this.localRKId;
    }

    @Override
    public RegistrationStatus getRegistrationStatus() {
        return this.status;
    }

    @Override
    public RoutingContext getRoutingContext() {
        return this.rc;
    }

    public String toString() {
        TextBuilder tb = TextBuilder.newInstance();
        tb.append("RegistrationResult(");
        if (this.localRKId != null) {
            tb.append(this.localRKId.toString());
        }
        if (this.status != null) {
            tb.append(this.status.toString());
        }
        if (this.rc != null) {
            tb.append(this.rc.toString());
        }
        tb.append(")");
        return tb.toString();
    }
}

