/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl.oam;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.AssociationType;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.Management;
import org.mobicents.protocols.api.Server;
import org.restcomm.ss7.management.console.ShellExecutor;

public class SCTPShellExecutor
implements ShellExecutor {
    private static final Logger logger = Logger.getLogger(SCTPShellExecutor.class);
    private FastMap<String, Management> sctpManagements = new FastMap();
    private Management sctpManagement = null;

    public Map<String, Management> getSctpManagements() {
        return this.sctpManagements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSctpManagements(Map<String, Management> sctpManagementsTemp) {
        if (sctpManagementsTemp != null) {
            SCTPShellExecutor sCTPShellExecutor = this;
            synchronized (sCTPShellExecutor) {
                FastMap<String, Management> newsctpManagements = new FastMap<String, Management>();
                newsctpManagements.putAll(sctpManagementsTemp);
                this.sctpManagements = newsctpManagements;
            }
        }
    }

    private void setDefaultValue() {
        if (this.sctpManagement == null) {
            Map.Entry<String, Management> sctpManagementsTmp = this.sctpManagements.entrySet().iterator().next();
            this.sctpManagement = sctpManagementsTmp.getValue();
        }
    }

    private String showServers(String[] args) {
        String sctpStackName = null;
        if (args.length > 3) {
            if (!args[3].equals("stackname")) {
                return "Invalid Command";
            }
            sctpStackName = args[4];
            Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
            if (sctpManagementtmp == null) {
                return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
            }
            this.sctpManagement = sctpManagementtmp;
        } else {
            this.setDefaultValue();
        }
        List<Server> servers = this.sctpManagement.getServers();
        if (servers.size() == 0) {
            return String.format("No Server defined yet for stack=%s", this.sctpManagement.getName());
        }
        StringBuffer sb = new StringBuffer();
        for (Server server : servers) {
            sb.append("\n");
            sb.append("SERVER ").append(server.getIpChannelType().getType()).append(" name=").append(server.getName()).append(" started=").append(server.isStarted()).append(" hostIp=").append(server.getHostAddress()).append(" hostPort=").append(server.getHostport());
            String[] secondaryHostAdd = server.getExtraHostAddresses();
            if (secondaryHostAdd != null && secondaryHostAdd.length > 0) {
                sb.append(" secondaryHost=");
                for (int i = 0; i < secondaryHostAdd.length; ++i) {
                    sb.append(secondaryHostAdd[i]).append(" ");
                }
            }
            List<String> associations = server.getAssociations();
            sb.append("\n");
            sb.append("Associations:");
            for (String s : associations) {
                sb.append("        ");
                sb.append(s).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String showAssociations(String[] args) {
        String sctpStackName = null;
        if (args.length > 3) {
            if (!args[3].equals("stackname")) {
                return "Invalid Command";
            }
            sctpStackName = args[4];
            Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
            if (sctpManagementtmp == null) {
                return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
            }
            this.sctpManagement = sctpManagementtmp;
        } else {
            this.setDefaultValue();
        }
        Map<String, Association> associations = this.sctpManagement.getAssociations();
        if (associations.size() == 0) {
            return "No Association defined yet for stack=%s";
        }
        StringBuffer sb = new StringBuffer();
        for (String s : associations.keySet()) {
            Association asso = associations.get(s);
            sb.append("\n");
            sb.append("ASSOCIATION ").append(asso.getIpChannelType().getType()).append(" name=").append(asso.getName()).append(" started=").append(asso.isStarted()).append(" peerIp=").append(asso.getPeerAddress()).append(" peerPort=").append(asso.getPeerPort());
            if (asso.getAssociationType() == AssociationType.CLIENT) {
                sb.append(" hostIp=").append(asso.getHostAddress()).append(" hostPort=").append(asso.getHostPort());
            } else {
                sb.append(" server=").append(asso.getServerName());
            }
            sb.append(" type=").append((Object)asso.getAssociationType());
            String[] secondaryHostAdd = asso.getExtraHostAddresses();
            if (secondaryHostAdd != null && secondaryHostAdd.length > 0) {
                sb.append(" secondaryHost=");
                for (int i = 0; i < secondaryHostAdd.length; ++i) {
                    sb.append(secondaryHostAdd[i]).append(" ");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String execute(String[] args) {
        try {
            if (this.sctpManagements.size() == 0) {
                return "No SCTP management bean defined";
            }
            if (args.length < 2 || args.length > 13) {
                return "Invalid Command";
            }
            if (args[1] == null) {
                return "Invalid Command";
            }
            if (args[1].equals("server")) {
                if (args.length < 3) {
                    return "Invalid Command";
                }
                String command = args[2];
                if (command == null) {
                    return "Invalid Command";
                }
                if (command.equals("create")) {
                    if (args.length < 6 || args.length > 10) {
                        return "Invalid Command";
                    }
                    String serverName = args[3];
                    if (serverName == null) {
                        return "Invalid Command";
                    }
                    String hostAddress = args[4];
                    if (hostAddress == null) {
                        return "Invalid Command";
                    }
                    String[] hostAddresses = hostAddress.split(",");
                    String primaryAddress = hostAddresses[0];
                    String[] secondaryAddresses = null;
                    if (hostAddresses.length > 1) {
                        secondaryAddresses = new String[hostAddresses.length - 1];
                        for (int i = 0; i < secondaryAddresses.length; ++i) {
                            secondaryAddresses[i] = hostAddresses[i + 1];
                        }
                    }
                    int hostPort = Integer.parseInt(args[5]);
                    IpChannelType ipChnnelType = null;
                    String sctpStackName = null;
                    if (args.length > 6) {
                        for (int i = 6; i < args.length; i += 2) {
                            if (args[i].equals("stackname")) {
                                sctpStackName = args[i + 1];
                                Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
                                if (sctpManagementtmp == null) {
                                    return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
                                }
                                this.sctpManagement = sctpManagementtmp;
                                continue;
                            }
                            if (!args[i].equals("sockettype")) continue;
                            ipChnnelType = IpChannelType.getInstance(args[i + 1]);
                        }
                    }
                    this.setDefaultValue();
                    if (ipChnnelType == null) {
                        ipChnnelType = IpChannelType.SCTP;
                    }
                    this.sctpManagement.addServer(serverName, primaryAddress, hostPort, ipChnnelType, secondaryAddresses);
                    return String.format("Successfully added Server=%s to stack=%s", serverName, this.sctpManagement.getName());
                }
                if (command.equals("modify")) {
                    String serverName = args[3];
                    if (serverName == null) {
                        return "Invalid Command";
                    }
                    String sctpStackName = args[4];
                    if (sctpStackName == null) {
                        Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
                        if (sctpManagementtmp == null) {
                            return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
                        }
                        this.sctpManagement = sctpManagementtmp;
                    }
                    String hostAddress = null;
                    Integer port = null;
                    IpChannelType ipChannelType = null;
                    Boolean acceptAnonymousConnections = null;
                    Integer maxConcurrentConnectionsCount = null;
                    String[] extraHostAddresses = null;
                    if (args.length > 5) {
                        block49: for (int i = 5; i < args.length; i += 2) {
                            String currProp;
                            switch (currProp = args[i]) {
                                case "host": {
                                    hostAddress = args[i + 1];
                                    continue block49;
                                }
                                case "port": {
                                    port = Integer.valueOf(args[i + 1]);
                                    continue block49;
                                }
                                case "sockettype": {
                                    ipChannelType = IpChannelType.getInstance(args[i + 1]);
                                    continue block49;
                                }
                                case "anonymconnect": {
                                    acceptAnonymousConnections = Boolean.valueOf(args[i + 1]);
                                    continue block49;
                                }
                                case "concurrentconnect": {
                                    maxConcurrentConnectionsCount = Integer.valueOf(args[i + 1]);
                                    continue block49;
                                }
                                case "extraaddresses": {
                                    extraHostAddresses = args[i + 1].split(",");
                                    continue block49;
                                }
                                default: {
                                    return "Invalid Command";
                                }
                            }
                        }
                    }
                    this.sctpManagement.modifyServer(serverName, hostAddress, port, ipChannelType, acceptAnonymousConnections, maxConcurrentConnectionsCount, extraHostAddresses);
                    return String.format("Successfully modified Server=%s on stack=%s", serverName, this.sctpManagement.getName());
                }
                if (command.equals("destroy")) {
                    if (args.length < 4) {
                        return "Invalid Command";
                    }
                    String serverName = args[3];
                    if (serverName == null) {
                        return "Invalid Command";
                    }
                    String sctpStackName = null;
                    if (args.length > 4) {
                        if (!args[4].equals("stackname")) {
                            return "Invalid Command";
                        }
                        sctpStackName = args[5];
                        Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
                        if (sctpManagementtmp == null) {
                            return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
                        }
                        this.sctpManagement = sctpManagementtmp;
                    } else {
                        this.setDefaultValue();
                    }
                    this.sctpManagement.removeServer(serverName);
                    return String.format("Successfully removed Server=%s from stack=%s", serverName, this.sctpManagement.getName());
                }
                if (command.equals("start")) {
                    if (args.length < 4) {
                        return "Invalid Command";
                    }
                    String serverName = args[3];
                    if (serverName == null) {
                        return "Invalid Command";
                    }
                    String sctpStackName = null;
                    if (args.length > 4) {
                        if (!args[4].equals("stackname")) {
                            return "Invalid Command";
                        }
                        sctpStackName = args[5];
                        Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
                        if (sctpManagementtmp == null) {
                            return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
                        }
                        this.sctpManagement = sctpManagementtmp;
                    } else {
                        this.setDefaultValue();
                    }
                    this.sctpManagement.startServer(serverName);
                    return String.format("Successfully started Server=%s on stack=%s", serverName, this.sctpManagement.getName());
                }
                if (command.equals("stop")) {
                    if (args.length < 4) {
                        return "Invalid Command";
                    }
                    String serverName = args[3];
                    if (serverName == null) {
                        return "Invalid Command";
                    }
                    String sctpStackName = null;
                    if (args.length > 4) {
                        if (!args[4].equals("stackname")) {
                            return "Invalid Command";
                        }
                        sctpStackName = args[5];
                        Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
                        if (sctpManagementtmp == null) {
                            return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
                        }
                        this.sctpManagement = sctpManagementtmp;
                    } else {
                        this.setDefaultValue();
                    }
                    this.sctpManagement.stopServer(serverName);
                    return String.format("Successfully stopped Server=%s on stack=%s", serverName, this.sctpManagement.getName());
                }
                if (command.equals("show")) {
                    return this.showServers(args);
                }
                return "Invalid Command";
            }
            if (args[1].equals("association")) {
                if (args.length < 3) {
                    return "Invalid Command";
                }
                String command = args[2];
                if (command == null) {
                    return "Invalid Command";
                }
                if (command.equals("create")) {
                    if (args.length < 8 || args.length > 13) {
                        return "Invalid Command";
                    }
                    String assocName = args[3];
                    if (assocName == null) {
                        return "Invalid Command";
                    }
                    String type = args[4];
                    if (type == null) {
                        return "Invalid Command";
                    }
                    if (type.equals("CLIENT")) {
                        if (args.length < 9) {
                            return "Invalid Command";
                        }
                        String peerIp = args[5];
                        int peerPort = Integer.parseInt(args[6]);
                        String hostIp = args[7];
                        String[] hostAddresses = hostIp.split(",");
                        String primaryAddress = hostAddresses[0];
                        String[] secondaryAddresses = null;
                        if (hostAddresses.length > 1) {
                            secondaryAddresses = new String[hostAddresses.length - 1];
                            for (int i = 0; i < secondaryAddresses.length; ++i) {
                                secondaryAddresses[i] = hostAddresses[i + 1];
                            }
                        }
                        int hostPort = Integer.parseInt(args[8]);
                        IpChannelType ipChnnelType = null;
                        String sctpStackName = null;
                        if (args.length > 9) {
                            for (int i = 9; i < args.length; i += 2) {
                                if (args[i].equals("stackname")) {
                                    sctpStackName = args[i + 1];
                                    Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
                                    if (sctpManagementtmp == null) {
                                        return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
                                    }
                                    this.sctpManagement = sctpManagementtmp;
                                    continue;
                                }
                                if (!args[i].equals("sockettype")) continue;
                                ipChnnelType = IpChannelType.getInstance(args[i + 1]);
                            }
                        }
                        this.setDefaultValue();
                        if (ipChnnelType == null) {
                            ipChnnelType = IpChannelType.SCTP;
                        }
                        this.sctpManagement.addAssociation(primaryAddress, hostPort, peerIp, peerPort, assocName, ipChnnelType, secondaryAddresses);
                        return String.format("Successfully added client Association=%s on stack=%s", assocName, this.sctpManagement.getName());
                    }
                    if (type.equals("SERVER")) {
                        String serverName = args[5];
                        String peerIp = args[6];
                        int peerPort = Integer.parseInt(args[7]);
                        IpChannelType ipChnnelType = null;
                        String sctpStackName = null;
                        if (args.length > 8) {
                            for (int i = 8; i < args.length; i += 2) {
                                if (args[i].equals("stackname")) {
                                    sctpStackName = args[i + 1];
                                    Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
                                    if (sctpManagementtmp == null) {
                                        return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
                                    }
                                    this.sctpManagement = sctpManagementtmp;
                                    continue;
                                }
                                if (!args[i].equals("sockettype")) continue;
                                ipChnnelType = IpChannelType.getInstance(args[i + 1]);
                            }
                        }
                        if (this.sctpManagement == null) {
                            this.setDefaultValue();
                        }
                        if (ipChnnelType == null) {
                            ipChnnelType = IpChannelType.SCTP;
                        }
                        this.sctpManagement.addServerAssociation(peerIp, peerPort, serverName, assocName, ipChnnelType);
                        return String.format("Successfully added server Association=%s on stack=%s", assocName, this.sctpManagement.getName());
                    }
                    return "Invalid Command";
                }
                if (command.equals("modify")) {
                    String type;
                    String assocName = args[3];
                    if (assocName == null) {
                        return "Invalid Command";
                    }
                    String sctpStackName = args[4];
                    if (sctpStackName == null) {
                        Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
                        if (sctpManagementtmp == null) {
                            return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
                        }
                        this.sctpManagement = sctpManagementtmp;
                    }
                    if ((type = args[5]) == null) {
                        return "Invalid Command";
                    }
                    if (type.equals("CLIENT")) {
                        String hostAddress = null;
                        Integer hostPort = null;
                        String peerAddress = null;
                        Integer peerPort = null;
                        IpChannelType ipChannelType = null;
                        String[] extraHostAddresses = null;
                        if (args.length > 6) {
                            block53: for (int i = 6; i < args.length; i += 2) {
                                String currProp;
                                switch (currProp = args[i]) {
                                    case "peerhost": {
                                        peerAddress = args[i + 1];
                                        continue block53;
                                    }
                                    case "peerport": {
                                        peerPort = Integer.valueOf(args[i + 1]);
                                        continue block53;
                                    }
                                    case "sockettype": {
                                        ipChannelType = IpChannelType.getInstance(args[i + 1]);
                                        continue block53;
                                    }
                                    case "host": {
                                        hostAddress = args[i + 1];
                                        continue block53;
                                    }
                                    case "port": {
                                        hostPort = Integer.valueOf(args[i + 1]);
                                        continue block53;
                                    }
                                    case "extraaddresses": {
                                        extraHostAddresses = args[i + 1].split(",");
                                        continue block53;
                                    }
                                    default: {
                                        return "Invalid Command";
                                    }
                                }
                            }
                        }
                        this.sctpManagement.modifyAssociation(hostAddress, hostPort, peerAddress, peerPort, assocName, ipChannelType, extraHostAddresses);
                        return String.format("Successfully modified client Association=%s on stack=%s", assocName, this.sctpManagement.getName());
                    }
                    if (type.equals("SERVER")) {
                        String peerAddress = null;
                        Integer peerPort = null;
                        String serverName = null;
                        IpChannelType ipChannelType = null;
                        if (args.length > 6) {
                            block54: for (int i = 6; i < args.length; i += 2) {
                                String currProp;
                                switch (currProp = args[i]) {
                                    case "peerhost": {
                                        peerAddress = args[i + 1];
                                        continue block54;
                                    }
                                    case "peerport": {
                                        peerPort = Integer.valueOf(args[i + 1]);
                                        continue block54;
                                    }
                                    case "sockettype": {
                                        ipChannelType = IpChannelType.getInstance(args[i + 1]);
                                        continue block54;
                                    }
                                    case "servername": {
                                        serverName = args[i + 1];
                                        continue block54;
                                    }
                                    default: {
                                        return "Invalid Command";
                                    }
                                }
                            }
                        }
                        this.sctpManagement.modifyServerAssociation(assocName, peerAddress, peerPort, serverName, ipChannelType);
                        return String.format("Successfully modified server Association=%s on stack=%s", assocName, this.sctpManagement.getName());
                    }
                } else {
                    if (command.equals("destroy")) {
                        if (args.length < 4) {
                            return "Invalid Command";
                        }
                        String assocName = args[3];
                        if (assocName == null) {
                            return "Invalid Command";
                        }
                        String sctpStackName = null;
                        if (args.length > 4) {
                            if (!args[4].equals("stackname")) {
                                return "Invalid Command";
                            }
                            sctpStackName = args[5];
                            Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
                            if (sctpManagementtmp == null) {
                                return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
                            }
                            this.sctpManagement = sctpManagementtmp;
                        } else {
                            this.setDefaultValue();
                        }
                        this.sctpManagement.removeAssociation(assocName);
                        return String.format("Successfully removed Association=%s from stack=%s", assocName, this.sctpManagement.getName());
                    }
                    if (command.equals("show")) {
                        return this.showAssociations(args);
                    }
                }
                return "Invalid Command";
            }
            if (args[1].equals("set")) {
                return this.manageSet(args);
            }
            if (args[1].equals("get")) {
                return this.manageGet(args);
            }
            return "Invalid Command";
        }
        catch (Exception e) {
            logger.error(String.format("Error while executing comand %s", Arrays.toString(args)), e);
            return e.toString();
        }
        catch (Throwable t) {
            logger.error(String.format("Error while executing comand %s", Arrays.toString(args)), t);
            return t.toString();
        }
    }

    private String manageSet(String[] options) throws Exception {
        if (options.length < 4 || options.length > 6) {
            return "Invalid Command";
        }
        String sctpStackName = null;
        if (options.length > 4) {
            if (!options[4].equals("stackname")) {
                return "Invalid Command";
            }
            sctpStackName = options[5];
            Management sctpManagementtmp = this.sctpManagements.get(sctpStackName);
            if (sctpManagementtmp == null) {
                return String.format("No SCTP management bean found for passed name=%s", sctpStackName);
            }
            this.sctpManagement = sctpManagementtmp;
        } else {
            this.setDefaultValue();
        }
        String parName = options[2].toLowerCase();
        if (parName.equals("connectdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sctpManagement.setConnectDelay(val);
        } else if (parName.equals("cc_delaythreshold_1")) {
            double val = Double.parseDouble(options[3]);
            this.sctpManagement.setCongControl_DelayThreshold_1(val);
        } else if (parName.equals("cc_delaythreshold_2")) {
            double val = Double.parseDouble(options[3]);
            this.sctpManagement.setCongControl_DelayThreshold_2(val);
        } else if (parName.equals("cc_delaythreshold_3")) {
            double val = Double.parseDouble(options[3]);
            this.sctpManagement.setCongControl_DelayThreshold_3(val);
        } else if (parName.equals("cc_backtonormal_delaythreshold_1")) {
            double val = Double.parseDouble(options[3]);
            this.sctpManagement.setCongControl_BackToNormalDelayThreshold_1(val);
        } else if (parName.equals("cc_backtonormal_delaythreshold_2")) {
            double val = Double.parseDouble(options[3]);
            this.sctpManagement.setCongControl_BackToNormalDelayThreshold_2(val);
        } else if (parName.equals("cc_backtonormal_delaythreshold_3")) {
            double val = Double.parseDouble(options[3]);
            this.sctpManagement.setCongControl_BackToNormalDelayThreshold_3(val);
        } else {
            return "Invalid Command";
        }
        return String.format("Parameter has been successfully set on stack=%s", this.sctpManagement.getName());
    }

    private String manageGet(String[] options) throws Exception {
        if (options.length < 2 || options.length > 3) {
            return "Invalid Command";
        }
        if (options.length == 3) {
            this.setDefaultValue();
            String parName = options[2].toLowerCase();
            StringBuilder sb = new StringBuilder();
            sb.append("stack=").append(this.sctpManagement.getName()).append(" ");
            sb.append(options[2]);
            sb.append(" = ");
            if (parName.equals("connectdelay")) {
                sb.append(this.sctpManagement.getConnectDelay());
            } else if (parName.equals("cc_delaythreshold_1")) {
                sb.append(this.sctpManagement.getCongControl_DelayThreshold_1());
            } else if (parName.equals("cc_delaythreshold_2")) {
                sb.append(this.sctpManagement.getCongControl_DelayThreshold_2());
            } else if (parName.equals("cc_delaythreshold_3")) {
                sb.append(this.sctpManagement.getCongControl_DelayThreshold_3());
            } else if (parName.equals("cc_backtonormal_delaythreshold_1")) {
                sb.append(this.sctpManagement.getCongControl_BackToNormalDelayThreshold_1());
            } else if (parName.equals("cc_backtonormal_delaythreshold_2")) {
                sb.append(this.sctpManagement.getCongControl_BackToNormalDelayThreshold_2());
            } else if (parName.equals("cc_backtonormal_delaythreshold_3")) {
                sb.append(this.sctpManagement.getCongControl_BackToNormalDelayThreshold_3());
            } else {
                return "Invalid Command";
            }
            return sb.toString();
        }
        this.setDefaultValue();
        StringBuilder sb = new StringBuilder();
        FastCollection.Record e = this.sctpManagements.head();
        FastMap.Entry<String, Management> end = this.sctpManagements.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Management managementImplTmp = (Management)((FastMap.Entry)e).getValue();
            String stackname = (String)((FastMap.Entry)e).getKey();
            sb.append("Properties for ");
            sb.append(stackname);
            sb.append("\n");
            sb.append("*******************");
            sb.append("\n");
            sb.append("connectdelay = ");
            sb.append(managementImplTmp.getConnectDelay());
            sb.append("\n");
            sb.append("cc_delaythreshold_1 = ");
            sb.append(this.sctpManagement.getCongControl_DelayThreshold_1());
            sb.append("\n");
            sb.append("cc_delaythreshold_2 = ");
            sb.append(this.sctpManagement.getCongControl_DelayThreshold_2());
            sb.append("\n");
            sb.append("cc_delaythreshold_3 = ");
            sb.append(this.sctpManagement.getCongControl_DelayThreshold_3());
            sb.append("\n");
            sb.append("cc_backtonormal_delaythreshold_1 = ");
            sb.append(this.sctpManagement.getCongControl_BackToNormalDelayThreshold_1());
            sb.append("\n");
            sb.append("cc_backtonormal_delaythreshold_2 = ");
            sb.append(this.sctpManagement.getCongControl_BackToNormalDelayThreshold_2());
            sb.append("\n");
            sb.append("cc_backtonormal_delaythreshold_3 = ");
            sb.append(this.sctpManagement.getCongControl_BackToNormalDelayThreshold_3());
            sb.append("\n");
            sb.append("*******************");
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean handles(String command) {
        return command.startsWith("sctp");
    }
}

