/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.EMLPPPriority;
import org.mobicents.protocols.ss7.map.api.service.supplementary.CCBSFeature;
import org.mobicents.protocols.ss7.map.api.service.supplementary.CliRestrictionOption;
import org.mobicents.protocols.ss7.map.api.service.supplementary.GenericServiceInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSStatus;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.supplementary.CCBSFeatureImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSStatusImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericServiceInfoImpl
extends SequenceBase
implements GenericServiceInfo {
    public static final int _ID_maximumEntitledPriority = 0;
    public static final int _ID_defaultPriority = 1;
    public static final int _ID_ccbsFeatureList = 2;
    public static final int _ID_nbrSB = 3;
    public static final int _ID_nbrUser = 4;
    public static final int _ID_nbrSN = 5;
    private SSStatus ssStatus;
    private CliRestrictionOption cliRestrictionOption;
    private EMLPPPriority maximumEntitledPriority;
    private EMLPPPriority defaultPriority;
    private ArrayList<CCBSFeature> ccbsFeatureList;
    private Integer nbrSB;
    private Integer nbrUser;
    private Integer nbrSN;

    public GenericServiceInfoImpl() {
        super("GenericServiceInfo");
    }

    public GenericServiceInfoImpl(SSStatus ssStatus, CliRestrictionOption cliRestrictionOption, EMLPPPriority maximumEntitledPriority, EMLPPPriority defaultPriority, ArrayList<CCBSFeature> ccbsFeatureList, Integer nbrSB, Integer nbrUser, Integer nbrSN) {
        super("GenericServiceInfo");
        this.ssStatus = ssStatus;
        this.cliRestrictionOption = cliRestrictionOption;
        this.maximumEntitledPriority = maximumEntitledPriority;
        this.defaultPriority = defaultPriority;
        this.ccbsFeatureList = ccbsFeatureList;
        this.nbrSB = nbrSB;
        this.nbrUser = nbrUser;
        this.nbrSN = nbrSN;
    }

    @Override
    public SSStatus getSsStatus() {
        return this.ssStatus;
    }

    @Override
    public CliRestrictionOption getCliRestrictionOption() {
        return this.cliRestrictionOption;
    }

    @Override
    public EMLPPPriority getMaximumEntitledPriority() {
        return this.maximumEntitledPriority;
    }

    @Override
    public EMLPPPriority getDefaultPriority() {
        return this.defaultPriority;
    }

    @Override
    public ArrayList<CCBSFeature> getCcbsFeatureList() {
        return this.ccbsFeatureList;
    }

    @Override
    public Integer getNbrSB() {
        return this.nbrSB;
    }

    @Override
    public Integer getNbrUser() {
        return this.nbrUser;
    }

    @Override
    public Integer getNbrSN() {
        return this.nbrSN;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssStatus = null;
        this.cliRestrictionOption = null;
        this.maximumEntitledPriority = null;
        this.defaultPriority = null;
        this.ccbsFeatureList = null;
        this.nbrSB = null;
        this.nbrUser = null;
        this.nbrSN = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ssStatus: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ssStatus = new SSStatusImpl();
                    ((SSStatusImpl)this.ssStatus).decodeAll(ais);
                    break;
                }
                default: {
                    int i1;
                    if (ais.getTagClass() == 0) {
                        switch (tag) {
                            case 10: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".cliRestrictionOption: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                i1 = (int)ais.readInteger();
                                this.cliRestrictionOption = CliRestrictionOption.getInstance(i1);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 0: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".maximumEntitledPriority: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                i1 = (int)ais.readInteger();
                                this.maximumEntitledPriority = EMLPPPriority.getEMLPPPriority(i1);
                                break;
                            }
                            case 1: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".defaultPriority: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                i1 = (int)ais.readInteger();
                                this.defaultPriority = EMLPPPriority.getEMLPPPriority(i1);
                                break;
                            }
                            case 2: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ccbsFeatureList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                AsnInputStream ais2 = ais.readSequenceStream();
                                this.ccbsFeatureList = new ArrayList();
                                while (ais2.available() != 0) {
                                    ais2.readTag();
                                    CCBSFeatureImpl ccBSFeature = new CCBSFeatureImpl();
                                    ccBSFeature.decodeAll(ais2);
                                    this.ccbsFeatureList.add(ccBSFeature);
                                }
                                if (this.ccbsFeatureList.size() >= 1 && this.ccbsFeatureList.size() <= 5) break block0;
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter ccbsFeatureList size must be from 1 to 5, found: " + this.ccbsFeatureList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            case 3: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".nbrSB: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.nbrSB = (int)ais.readInteger();
                                break;
                            }
                            case 4: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".nbrUser: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.nbrUser = (int)ais.readInteger();
                                break;
                            }
                            case 5: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".nbrSN: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.nbrSN = (int)ais.readInteger();
                                break;
                            }
                            default: {
                                ais.advanceElement();
                                break;
                            }
                        }
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 1) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Needs at least 1 mandatory parameter, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.ssStatus == null) {
                throw new MAPException("ssStatus parameter must not be null");
            }
            ((SSStatusImpl)this.ssStatus).encodeAll(asnOs);
            if (this.cliRestrictionOption != null) {
                asnOs.writeInteger(0, 10, this.cliRestrictionOption.getCode());
            }
            if (this.maximumEntitledPriority != null) {
                asnOs.writeInteger(2, 0, this.maximumEntitledPriority.getCode());
            }
            if (this.defaultPriority != null) {
                asnOs.writeInteger(2, 1, this.defaultPriority.getCode());
            }
            if (this.ccbsFeatureList != null) {
                try {
                    asnOs.writeTag(2, false, 2);
                    int pos = asnOs.StartContentDefiniteLength();
                    for (CCBSFeature item : this.ccbsFeatureList) {
                        ((CCBSFeatureImpl)item).encodeAll(asnOs);
                    }
                    asnOs.FinalizeContent(pos);
                }
                catch (AsnException e) {
                    throw new MAPException("AsnException when encoding " + this._PrimitiveName + ".ccbsFeatureList: " + e.getMessage(), e);
                }
            }
            if (this.nbrSB != null) {
                asnOs.writeInteger(2, 3, this.nbrSB.intValue());
            }
            if (this.nbrUser != null) {
                asnOs.writeInteger(2, 4, this.nbrUser.intValue());
            }
            if (this.nbrSN != null) {
                asnOs.writeInteger(2, 5, this.nbrSN.intValue());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.ssStatus != null) {
            sb.append("ssStatus=");
            sb.append(this.ssStatus);
            sb.append(", ");
        }
        if (this.cliRestrictionOption != null) {
            sb.append("cliRestrictionOption=");
            sb.append((Object)this.cliRestrictionOption);
            sb.append(", ");
        }
        if (this.maximumEntitledPriority != null) {
            sb.append("maximumEntitledPriority=");
            sb.append((Object)this.maximumEntitledPriority);
            sb.append(", ");
        }
        if (this.defaultPriority != null) {
            sb.append("defaultPriority=");
            sb.append((Object)this.defaultPriority);
            sb.append(", ");
        }
        if (this.ccbsFeatureList != null) {
            sb.append("ccbsFeatureList=[");
            boolean firstItem = true;
            for (CCBSFeature be : this.ccbsFeatureList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        if (this.nbrSB != null) {
            sb.append("nbrSB=");
            sb.append(this.nbrSB);
            sb.append(", ");
        }
        if (this.nbrUser != null) {
            sb.append("nbrUser=");
            sb.append(this.nbrUser);
            sb.append(", ");
        }
        if (this.nbrSN != null) {
            sb.append("nbrSN=");
            sb.append(this.nbrSN);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

