/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.asn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.BitSetStrictLength;

public class AsnOutputStream
extends OutputStream {
    private static final String _REAL_BASE10_CHARSET = "US-ASCII";
    private static final byte _BOOLEAN_POSITIVE = -1;
    private static final byte _BOOLEAN_NEGATIVE = 0;
    private byte[] buffer = new byte[this.length];
    private int pos;
    private int length = 256;

    public byte[] toByteArray() {
        if (this.pos == this.length) {
            return this.buffer;
        }
        byte[] res = new byte[this.pos];
        System.arraycopy(this.buffer, 0, res, 0, this.pos);
        return res;
    }

    public int size() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
    }

    private void checkIncreaseArray(int addCount) {
        if (this.pos + addCount > this.length) {
            int newLength = this.length * 2;
            if (newLength < this.pos + addCount) {
                newLength = this.pos + addCount + this.length;
            }
            byte[] newBuf = new byte[newLength];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            this.buffer = newBuf;
            this.length = newLength;
        }
    }

    public void write(int b) {
        this.checkIncreaseArray(1);
        this.buffer[this.pos++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) {
        this.checkIncreaseArray(len);
        System.arraycopy(b, off, this.buffer, this.pos, len);
        this.pos += len;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void writeTag(int tagClass, boolean primitive, int tag) throws AsnException {
        if (tag < 0) {
            throw new AsnException("Tag must not be negative");
        }
        if (tag <= 30) {
            int toEncode = (tagClass & 3) << 6;
            toEncode |= (primitive ? 0 : 1) << 5;
            this.write(toEncode |= tag & 0x1F);
        } else {
            int dd;
            int toEncode = (tagClass & 3) << 6;
            toEncode |= (primitive ? 0 : 1) << 5;
            this.write(toEncode |= 0x1F);
            int byteArr = 8;
            byte[] buf = new byte[byteArr];
            int pos = byteArr;
            while (true) {
                if (tag <= 127) {
                    dd = tag;
                    if (pos != byteArr) {
                        dd |= 0x80;
                    }
                    break;
                }
                dd = tag & 0x7F;
                tag >>= 7;
                if (pos != byteArr) {
                    dd |= 0x80;
                }
                buf[--pos] = (byte)dd;
            }
            buf[--pos] = (byte)dd;
            this.write(buf, pos, byteArr - pos);
        }
    }

    public void writeLength(int v) throws IOException {
        if (v == -1) {
            this.write(128);
            return;
        }
        if (v > 127) {
            int count;
            byte[] buf = new byte[4];
            if ((v & 0xFF000000) > 0) {
                buf[0] = (byte)(v >> 24 & 0xFF);
                buf[1] = (byte)(v >> 16 & 0xFF);
                buf[2] = (byte)(v >> 8 & 0xFF);
                buf[3] = (byte)(v & 0xFF);
                count = 4;
            } else if ((v & 0xFF0000) > 0) {
                buf[0] = (byte)(v >> 16 & 0xFF);
                buf[1] = (byte)(v >> 8 & 0xFF);
                buf[2] = (byte)(v & 0xFF);
                count = 3;
            } else if ((v & 0xFF00) > 0) {
                buf[0] = (byte)(v >> 8 & 0xFF);
                buf[1] = (byte)(v & 0xFF);
                count = 2;
            } else {
                buf[0] = (byte)(v & 0xFF);
                count = 1;
            }
            this.buffer[this.pos] = (byte)(0x80 | count);
            for (int i1 = 0; i1 < count; ++i1) {
                this.buffer[this.pos + i1 + 1] = buf[i1];
            }
            this.pos += count + 1;
        } else {
            this.write(v);
        }
    }

    public int StartContentDefiniteLength() {
        int lenPos = this.pos;
        this.write(0);
        return lenPos;
    }

    public int StartContentIndefiniteLength() {
        this.write(128);
        return -1;
    }

    public void FinalizeContent(int lenPos) {
        if (lenPos == -1) {
            this.write(0);
            this.write(0);
        } else {
            int length = this.pos - lenPos - 1;
            if (length <= 127) {
                this.buffer[lenPos] = (byte)length;
            } else {
                int count;
                byte[] buf = new byte[4];
                if ((length & 0xFF000000) > 0) {
                    buf[0] = (byte)(length >> 24 & 0xFF);
                    buf[1] = (byte)(length >> 16 & 0xFF);
                    buf[2] = (byte)(length >> 8 & 0xFF);
                    buf[3] = (byte)(length & 0xFF);
                    count = 4;
                } else if ((length & 0xFF0000) > 0) {
                    buf[0] = (byte)(length >> 16 & 0xFF);
                    buf[1] = (byte)(length >> 8 & 0xFF);
                    buf[2] = (byte)(length & 0xFF);
                    count = 3;
                } else if ((length & 0xFF00) > 0) {
                    buf[0] = (byte)(length >> 8 & 0xFF);
                    buf[1] = (byte)(length & 0xFF);
                    count = 2;
                } else {
                    buf[0] = (byte)(length & 0xFF);
                    count = 1;
                }
                this.checkIncreaseArray(count);
                System.arraycopy(this.buffer, lenPos + 1, this.buffer, lenPos + 1 + count, length);
                this.pos += count;
                this.buffer[lenPos] = (byte)(0x80 | count);
                for (int i1 = 0; i1 < count; ++i1) {
                    this.buffer[lenPos + i1 + 1] = buf[i1];
                }
            }
        }
    }

    public void writeSequence(byte[] data) throws IOException, AsnException {
        this.writeSequence(0, 16, data);
    }

    public void writeSequence(int tagClass, int tag, byte[] data) throws IOException, AsnException {
        this.writeTag(tagClass, false, tag);
        this.writeLength(data.length);
        this.write(data);
    }

    public int writeSequenceData(byte[] data) throws IOException, AsnException {
        this.write(data);
        return data.length;
    }

    public void writeBoolean(boolean value) throws IOException, AsnException {
        this.writeBoolean(0, 1, value);
    }

    public void writeBoolean(int tagClass, int tag, boolean value) throws IOException, AsnException {
        this.writeTag(tagClass, true, tag);
        this.writeLength(1);
        this.writeBooleanData(value);
    }

    public int writeBooleanData(boolean value) throws IOException {
        int v = value ? -1 : 0;
        this.write(v);
        return 1;
    }

    public void writeInteger(long value) throws IOException, AsnException {
        this.writeInteger(0, 2, value);
    }

    public void writeInteger(int tagClass, int tag, long v) throws IOException, AsnException {
        this.writeTag(tagClass, true, tag);
        int lenPos = this.StartContentDefiniteLength();
        this.writeIntegerData(v);
        this.FinalizeContent(lenPos);
    }

    public int writeIntegerData(long v) throws IOException {
        boolean wasPositive = v > 0L;
        long v1 = v;
        if (!wasPositive) {
            v1 = -v;
        }
        int count = 0;
        count = (v1 & 0xFF00000000000000L) != 0L ? 8 : ((v1 & 0xFF000000000000L) != 0L ? 7 : ((v1 & 0xFF0000000000L) != 0L ? 6 : ((v1 & 0xFF00000000L) != 0L ? 5 : ((v1 & 0xFF000000L) != 0L ? 4 : ((v1 & 0xFF0000L) != 0L ? 3 : ((v1 & 0xFF00L) != 0L ? 2 : 1))))));
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(v);
        byte[] dataToWrite = new byte[8];
        bb.flip();
        bb.get(dataToWrite, 0, 8);
        int extraCount = 0;
        if (wasPositive && (dataToWrite[8 - count] & 0x80) != 0) {
            this.write(0);
            extraCount = 1;
        }
        this.write(dataToWrite, 8 - count, count);
        return count + extraCount;
    }

    public void writeReal(String d, int NR) throws IOException, AsnException {
        this.writeReal(0, 9, d, NR);
    }

    public void writeReal(double d) throws IOException, AsnException {
        this.writeReal(0, 9, d);
    }

    public void writeReal(int tagClass, int tag, String d, int NR) throws IOException, AsnException {
        this.writeTag(tagClass, true, tag);
        int lenPos = this.pos;
        this.write(0);
        int length = this.writeRealData(d, NR);
        this.buffer[lenPos] = (byte)length;
    }

    public void writeReal(int tagClass, int tag, double d) throws IOException, AsnException {
        this.writeTag(tagClass, true, tag);
        int lenPos = this.StartContentDefiniteLength();
        this.writeRealData(d);
        this.FinalizeContent(lenPos);
    }

    public int writeRealData(String d, int NR) throws AsnException, NumberFormatException, IOException {
        Double.parseDouble(d);
        byte[] encoded = null;
        try {
            encoded = d.getBytes(_REAL_BASE10_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new AsnException(e);
        }
        if (encoded.length + 1 > 127) {
            throw new AsnException("Not supported yet, is it even in specs?");
        }
        if (NR > 3 || NR < 1) {
            throw new AsnException("NR is out of range: <0,3>");
        }
        this.write(NR);
        this.write(encoded);
        return encoded.length + 1;
    }

    public int writeRealData(double d) throws AsnException, IOException {
        if (d == 0.0) {
            return 0;
        }
        if (d == Double.POSITIVE_INFINITY) {
            this.write(64);
            return 1;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            this.write(65);
            return 1;
        }
        long bits = Double.doubleToLongBits(d);
        int info = (int)(bits >> 57) & 0x40;
        this.write(info |= 0x81);
        byte[] exp = new byte[2];
        byte[] mantisa = new byte[7];
        exp[0] = (byte)((int)(bits >> 60) & 7);
        exp[1] = (byte)(bits >> 52);
        for (int index = 0; index < 7; ++index) {
            mantisa[6 - index] = (byte)(bits >> index * 8);
        }
        mantisa[0] = (byte)(mantisa[0] & 0xF);
        this.write(exp);
        this.write(mantisa);
        return 10;
    }

    public void writeBitString(BitSetStrictLength bitString) throws AsnException, IOException {
        this.writeBitString(0, 3, bitString);
    }

    public void writeBitString(int tagClass, int tag, BitSetStrictLength bitString) throws AsnException, IOException {
        this.writeTag(tagClass, true, tag);
        int lenPos = this.StartContentDefiniteLength();
        this.writeBitStringData(bitString);
        this.FinalizeContent(lenPos);
    }

    public int writeBitStringData(BitSetStrictLength bitString) throws AsnException, IOException {
        int bitNumber = bitString.getStrictLength();
        int octetCount = bitNumber / 8;
        int rest = bitNumber % 8;
        if (rest != 0) {
            ++octetCount;
        }
        if (rest == 0) {
            this.write(0);
        } else {
            this.write(8 - rest);
        }
        for (int i = 0; i < octetCount; ++i) {
            byte byteRead = AsnOutputStream._getByte(i * 8, bitString);
            this.write(byteRead);
        }
        return octetCount;
    }

    private static byte _getByte(int startIndex, BitSetStrictLength set) throws AsnException {
        byte data = 0;
        for (int count = 8; count > 0 && set.length() - 1 >= startIndex; ++startIndex, --count) {
            boolean lit = set.get(startIndex);
            if (!lit) continue;
            data = (byte)(data | 1 << count - 1);
        }
        return data;
    }

    public void writeOctetString(byte[] value) throws IOException, AsnException {
        this.writeOctetString(0, 4, value);
    }

    public void writeOctetString(int tagClass, int tag, byte[] value) throws IOException, AsnException {
        this.writeTag(tagClass, true, tag);
        int lenPos = this.StartContentDefiniteLength();
        this.writeOctetStringData(value);
        this.FinalizeContent(lenPos);
    }

    public int writeOctetStringData(byte[] value) {
        this.write(value);
        return value.length;
    }

    @Deprecated
    public void writeStringOctet(int tagClass, int tag, InputStream io) throws AsnException, IOException {
        this.writeTag(tagClass, true, tag);
        this.writeLength(io.available());
        byte[] data = new byte[io.available()];
        io.read(data);
        this.write(data);
    }

    @Deprecated
    public void writeStringOctet(InputStream io) throws AsnException, IOException {
        this.writeStringOctet(0, 4, io);
    }

    @Deprecated
    public void writeStringOctetData(InputStream io) throws AsnException, IOException {
        if (io.available() > 127) {
            throw new AsnException("writeStringOctetData does not support octet strings more than 126 bytes length");
        }
        byte[] data = new byte[io.available()];
        io.read(data);
        this.write(data);
    }

    public void writeNull() throws IOException, AsnException {
        this.writeNull(0, 5);
    }

    public void writeNull(int tagClass, int tag) throws IOException, AsnException {
        this.writeTag(tagClass, true, tag);
        this.writeLength(0);
    }

    @Deprecated
    public void writeNULLData() throws IOException {
    }

    public int writeNullData() {
        return 0;
    }

    public void writeObjectIdentifier(long[] oid) throws IOException, AsnException {
        this.writeObjectIdentifier(0, 6, oid);
    }

    public void writeObjectIdentifier(int tagClass, int tag, long[] oid) throws IOException, AsnException {
        this.writeTag(tagClass, true, tag);
        int lenPos = this.StartContentDefiniteLength();
        this.writeObjectIdentifierData(oid);
        this.FinalizeContent(lenPos);
    }

    public int writeObjectIdentifierData(long[] oidLeafs) throws IOException {
        int i;
        if (oidLeafs.length < 2) {
            return 0;
        }
        int len = 1;
        for (i = 2; i < oidLeafs.length; ++i) {
            len += this.getOIDLeafLength(oidLeafs[i]);
        }
        i = (int)(oidLeafs[0] * 40L + oidLeafs[1]);
        this.write(0xFF & i);
        for (i = 2; i < oidLeafs.length; ++i) {
            long v = oidLeafs[i];
            len = this.getOIDLeafLength(v);
            for (int j = len - 1; j > 0; --j) {
                long m = 0x80L | 0x7FL & v >> j * 7;
                this.write((int)m);
            }
            this.write((int)(0x7FL & v));
        }
        return len;
    }

    private int getOIDLeafLength(long leaf) {
        int i;
        if (leaf < 0L) {
            return 10;
        }
        long l = 1L;
        for (i = 1; i < 9 && leaf >= (l <<= 7); ++i) {
        }
        return i;
    }

    public void writeStringUTF8(String data) throws AsnException, IOException {
        this.writeStringUTF8(0, 12, data);
    }

    public void writeStringUTF8(int tagClass, int tag, String data) throws IOException, AsnException {
        this.writeTag(tagClass, true, tag);
        int lenPos = this.StartContentDefiniteLength();
        this.writeStringUTF8Data(data);
        this.FinalizeContent(lenPos);
    }

    public void writeStringUTF8Data(String data) throws IOException, AsnException {
        byte[] dataEncoded = null;
        try {
            dataEncoded = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AsnException(e);
        }
        this.write(dataEncoded);
    }

    public void writeStringIA5(String data) throws AsnException, IOException {
        this.writeStringIA5(0, 22, data);
    }

    public void writeStringIA5(int tagClass, int tag, String data) throws IOException, AsnException {
        this.writeTag(tagClass, true, tag);
        int lenPos = this.StartContentDefiniteLength();
        this.writeStringIA5Data(data);
        this.FinalizeContent(lenPos);
    }

    public void writeStringIA5Data(String data) throws IOException, AsnException {
        byte[] dataEncoded = null;
        try {
            dataEncoded = data.getBytes(_REAL_BASE10_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new AsnException(e);
        }
        this.write(dataEncoded);
    }

    public void writeStringGraphic(String data) throws AsnException, IOException {
        this.writeStringIA5(0, 25, data);
    }

    public void writeStringGraphic(int tagClass, int tag, String data) throws IOException, AsnException {
        this.writeTag(tagClass, true, tag);
        int lenPos = this.StartContentDefiniteLength();
        this.writeStringIA5Data(data);
        this.FinalizeContent(lenPos);
    }

    public void writeStringGraphicData(String data) throws IOException, AsnException {
        byte[] dataEncoded = null;
        try {
            dataEncoded = data.getBytes(_REAL_BASE10_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new AsnException(e);
        }
        this.write(dataEncoded);
    }

    @Deprecated
    public void writeStringBinary(BitSet bitString) throws AsnException, IOException {
        int length = bitString.length();
        BitSetStrictLength bs = new BitSetStrictLength(length);
        for (int i1 = 0; i1 < length; ++i1) {
            bs.set(i1, bitString.get(i1));
        }
        this.writeBitString(bs);
    }

    @Deprecated
    public void writeStringBinary(int tagClass, int tag, BitSet bitString) throws AsnException, IOException {
        int length = bitString.length();
        BitSetStrictLength bs = new BitSetStrictLength(length);
        for (int i1 = 0; i1 < length; ++i1) {
            bs.set(i1, bitString.get(i1));
        }
        this.writeBitString(tagClass, tag, bs);
    }

    @Deprecated
    public void writeNULL() throws IOException, AsnException {
        this.writeNull();
    }

    @Deprecated
    public void writeStringBinaryData(BitSet bitString) throws AsnException, IOException {
        int length = bitString.length();
        BitSetStrictLength bs = new BitSetStrictLength(length);
        for (int i1 = 0; i1 < length; ++i1) {
            bs.set(i1, bitString.get(i1));
        }
        this.writeBitStringData(bs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Size=");
        sb.append(this.pos);
        sb.append("\n");
        byte[] bf = this.toByteArray();
        sb.append(AsnOutputStream.arrayToString(bf));
        return sb.toString();
    }

    protected static String arrayToString(byte[] bf) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean i1 = false;
        for (byte b : bf) {
            int ib = b & 0xFF;
            if (!i1) {
                i1 = true;
            } else {
                sb.append(", ");
            }
            sb.append(ib);
        }
        sb.append("]");
        return sb.toString();
    }
}

