/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.router;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.protocols.ss7.sccp.LongMessageRule;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;

public class LongMessageRuleImpl
implements LongMessageRule,
XMLSerializable {
    private static final String FIRST_SPC = "firstSpc";
    private static final String LAST_SPC = "lastSpc";
    private static final String RULE_TYPE = "ruleType";
    private int firstSpc;
    private int lastSpc;
    private LongMessageRuleType ruleType;
    protected static final XMLFormat<LongMessageRuleImpl> XML = new XMLFormat<LongMessageRuleImpl>(LongMessageRuleImpl.class){

        @Override
        public void write(LongMessageRuleImpl ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(LongMessageRuleImpl.FIRST_SPC, ai.firstSpc);
            xml.setAttribute(LongMessageRuleImpl.LAST_SPC, ai.lastSpc);
            xml.setAttribute(LongMessageRuleImpl.RULE_TYPE, ai.ruleType.toString());
        }

        @Override
        public void read(XMLFormat.InputElement xml, LongMessageRuleImpl ai) throws XMLStreamException {
            ai.firstSpc = xml.getAttribute(LongMessageRuleImpl.FIRST_SPC).toInt();
            ai.lastSpc = xml.getAttribute(LongMessageRuleImpl.LAST_SPC).toInt();
            String ruleT = xml.getAttribute(LongMessageRuleImpl.RULE_TYPE).toString();
            ai.ruleType = LongMessageRuleType.valueOf(ruleT);
        }
    };

    public LongMessageRuleImpl() {
    }

    public LongMessageRuleImpl(int firstSpc, int lastSpc, LongMessageRuleType ruleType) {
        this.firstSpc = firstSpc;
        this.lastSpc = lastSpc;
        this.ruleType = ruleType;
    }

    @Override
    public LongMessageRuleType getLongMessageRuleType() {
        return this.ruleType;
    }

    @Override
    public int getFirstSpc() {
        return this.firstSpc;
    }

    @Override
    public int getLastSpc() {
        return this.lastSpc;
    }

    @Override
    public boolean matches(int dpc) {
        return dpc >= this.firstSpc && dpc <= this.lastSpc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("firstSpc=").append(this.firstSpc).append(", lastSpc=").append(this.lastSpc).append(", ruleType=").append((Object)this.ruleType);
        return sb.toString();
    }
}

