/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.mtp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mobicents.protocols.stream.api.SelectorKey;
import org.mobicents.protocols.stream.api.SelectorProvider;
import org.mobicents.protocols.stream.api.StreamSelector;
import org.restcomm.protocols.ss7.mtp.Linkset;
import org.restcomm.protocols.ss7.mtp.Mtp1;
import org.restcomm.protocols.ss7.mtp.Mtp2;
import org.restcomm.protocols.ss7.mtp.Mtp2Buffer;
import org.restcomm.protocols.ss7.mtp.Mtp3Listener;
import org.restcomm.protocols.ss7.mtp.Utils;
import org.restcomm.protocols.ss7.scheduler.Scheduler;
import org.restcomm.protocols.ss7.scheduler.Task;

public class Mtp3
implements Runnable {
    public static final int TIMEOUT_T1_SLTM = 120;
    public static final int TIMEOUT_T2_SLTM = 900;
    private static final int LINK_MANAGEMENT = 0;
    private static final int LINK_TESTING = 1;
    public static final int _SI_SERVICE_SCCP = 3;
    public static final int _SI_SERVICE_ISUP = 5;
    private Mtp3Listener mtp3Listener;
    private boolean l4IsUp = false;
    protected volatile boolean started = false;
    public static final int DEFAULT_NI = 2;
    private int dpc;
    private int opc;
    private int ni = 8;
    private byte[] localFrame = new byte[279];
    private List<Mtp2> links = new ArrayList<Mtp2>();
    private Linkset linkset = new Linkset();
    private static final byte[] SLTM_PATTERN = new byte[]{1, 2, 3, 4, 5, 6, 15};
    protected String name;
    private StreamSelector selector;
    private Scheduler scheduler;
    private static final Logger logger = Logger.getLogger(Mtp3.class);
    private static final int PATTERN_OFFSET = 10;
    private static final int PATTERN_LEN_OFFSET = 12;

    public Mtp3(String name, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.name = name;
        try {
            this.selector = SelectorProvider.getSelector("org.restcomm.ss7.hardware.dahdi.Selector");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setScheduler(Scheduler scheduler) {
        if (scheduler != null) {
            this.scheduler = scheduler;
        }
    }

    public void setOpc(int opc) {
        this.opc = opc;
    }

    public void setDpc(int dpc) {
        this.dpc = dpc;
    }

    public int getDpc() {
        return this.dpc;
    }

    public int getOpc() {
        return this.opc;
    }

    public void setNetworkIndicator(int ni) {
        this.ni = (3 & ni) << 2;
    }

    public int getNetworkIndicator() {
        return this.ni >> 2;
    }

    public void addMtp3Listener(Mtp3Listener lst) {
        if (this.mtp3Listener != null) {
            throw new IllegalStateException("Listener already present.");
        }
        this.mtp3Listener = lst;
    }

    public void removeMtp3Listener(Mtp3Listener lst) {
        if (lst != this.mtp3Listener) {
            throw new IllegalArgumentException("Wrong listener passed. Its not registered in this object!");
        }
        this.mtp3Listener = null;
    }

    public void setLinks(List<Mtp2> channels) {
        for (Mtp2 link : channels) {
            if (link == null) continue;
            link.mtp3 = this;
            this.links.add(link);
        }
    }

    public void addLink(Mtp2 mtp2) {
        mtp2.mtp3 = this;
        this.links.add(mtp2);
    }

    public void clearLinks() {
        this.links.clear();
    }

    public void start() throws IOException {
        for (Mtp2 link : this.links) {
            link.start();
        }
    }

    public void stop() throws IOException {
        this.started = false;
        for (Mtp2 link : this.links) {
            link.stop();
        }
    }

    @Override
    public void run() {
        try {
            FastList<SelectorKey> selected = this.selector.selectNow(1, 20);
            FastCollection.Record n = selected.head();
            FastCollection.Record end = selected.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                ((Mtp2)((Mtp1)((SelectorKey)((FastList.Node)n).getValue()).getStream()).getLink()).doRead();
            }
            selected = this.selector.selectNow(2, 20);
            n = selected.head();
            end = selected.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                ((Mtp2)((Mtp1)((SelectorKey)((FastList.Node)n).getValue()).getStream()).getLink()).doWrite();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onMessage(Mtp2Buffer rxFrame, Mtp2 mtp2) {
        int sio = rxFrame.frame[3] & 0xFF;
        int subserviceIndicator = sio >> 4 & 0xF;
        int serviceIndicator = sio & 0xF;
        int ni = subserviceIndicator & 0xC;
        int dpc = Mtp3.dpc(rxFrame.frame, 4);
        int opc = Mtp3.opc(rxFrame.frame, 4);
        int sls = Mtp3.sls(rxFrame.frame, 4);
        if (this.ni != ni) {
            if (logger.isEnabledFor(Level.ERROR)) {
                logger.error(String.format("(%s) Received MSSU with bad SSI, discarding! ni:" + ni + " thisni:" + this.ni + " [si=" + serviceIndicator + ",ssi=" + subserviceIndicator + ", dpc=" + dpc + ", opc=" + opc + ", sls=" + sls + "] data: ", mtp2.getName()) + Arrays.toString(rxFrame.frame));
            }
            return;
        }
        switch (serviceIndicator) {
            case 0: {
                int h0 = rxFrame.frame[8] & 0xF;
                int h1 = (rxFrame.frame[8] & 0xF0) >>> 4;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("(%s) Signalling network management", mtp2.getName()));
                }
                if (h0 == 0) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(String.format("(%s) Changeover management", mtp2.getName()));
                    break;
                }
                if (h0 != 7 || h1 != 1 || !logger.isDebugEnabled()) break;
                logger.debug(String.format("(%s) TRA received", mtp2.getName()));
                break;
            }
            case 1: {
                int h0 = rxFrame.frame[8] & 0xF;
                int h1 = (rxFrame.frame[8] & 0xF0) >>> 4;
                int len = (rxFrame.frame[9] & 0xF0) >>> 4;
                if (h0 == 1 && h1 == 1) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("(%s) Received SLTM", mtp2.getName()));
                    }
                    Mtp3.writeRoutingLabel(this.localFrame, sio, this.ni, sls, opc, dpc);
                    this.localFrame[5] = 33;
                    System.arraycopy(rxFrame.frame, 9, this.localFrame, 6, len + 1);
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("(%s) Responding with SLTA", mtp2.getName()));
                    }
                    mtp2.send(this.localFrame, len + 9);
                    break;
                }
                if (h0 == 1 && h1 == 2) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("(%s) Received SLTA", mtp2.getName()));
                    }
                    if (this.checkPattern(rxFrame, len, SLTM_PATTERN)) {
                        mtp2.sltmTest.ack();
                        if (this.l4IsUp) break;
                        this.l4IsUp = true;
                        this.linkUp(mtp2);
                        break;
                    }
                    if (!logger.isEnabledFor(Level.WARN)) break;
                    logger.warn("SLTA pattern does not match: \n" + Arrays.toString(rxFrame.frame) + "\n" + Arrays.toString(SLTM_PATTERN));
                    break;
                }
                if (!logger.isEnabledFor(Level.WARN)) break;
                logger.warn(String.format("(%s) Unexpected message type", mtp2.getName()));
                break;
            }
            case 3: {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received SCCP MSU");
                }
                if (this.mtp3Listener == null) break;
                byte[] messageBuffer = new byte[rxFrame.len - 5];
                System.arraycopy(rxFrame.frame, 3, messageBuffer, 0, rxFrame.len - 5);
                try {
                    this.mtp3Listener.receive(messageBuffer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 5: {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received ISUP MSU");
                }
                if (this.mtp3Listener == null) break;
                byte[] messageBuffer = new byte[rxFrame.len - 5];
                System.arraycopy(rxFrame.frame, 3, messageBuffer, 0, rxFrame.len - 5);
                try {
                    this.mtp3Listener.receive(messageBuffer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                if (!logger.isEnabledFor(Level.WARN)) break;
                logger.warn("Received MSU for UNKNOWN SERVICE!!!!!!!!!!!: " + Utils.dump(rxFrame.frame, rxFrame.len, false));
            }
        }
    }

    private Mtp2 selectLink(byte sls) {
        return this.linkset.select(sls);
    }

    public boolean send(byte[] msg, int len) {
        byte sls = (byte)Mtp3.sls(msg, 1);
        Mtp2 link = this.selectLink(sls);
        if (link == null) {
            return false;
        }
        return link.send(msg, len);
    }

    public void linkInService(Mtp2 link) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("(%s) Sending TRA(Traffic Restart Allowed) message", link.getName()));
        }
        if (link.mtp2Listener != null) {
            link.mtp2Listener.linkInService();
        }
        this.restartTraffic(link);
        if (link.sltmTest == null) {
            SLTMTest tester;
            link.sltmTest = tester = new SLTMTest(link, this.scheduler);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("(%s) Starting link test procedure(SLTM/SLTA)", link.getName()));
            }
            tester.start();
        } else {
            link.sltmTest.start();
        }
    }

    private void linkUp(Mtp2 link) {
        if (link.mtp2Listener != null) {
            link.mtp2Listener.linkUp();
        }
        this.linkset.add(link);
        if (this.linkset.isActive() && this.mtp3Listener != null) {
            try {
                this.mtp3Listener.linkUp();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("(%s) Link now IN_SERVICE", link.getName()));
        }
    }

    public void linkFailed(Mtp2 link) {
        if (link.mtp2Listener != null) {
            link.mtp2Listener.linkFailed();
        }
        this.linkset.remove(link);
        link.fail();
        if (!this.linkset.isActive()) {
            this.l4IsUp = false;
            if (this.mtp3Listener != null) {
                try {
                    this.mtp3Listener.linkDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void registerLink(Mtp2 mtp2) {
        try {
            mtp2.getLayer1().register(this.selector);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void unregisterLink(Mtp2 mtp2) {
    }

    private void restartTraffic(Mtp2 link) {
        Mtp3.writeRoutingLabel(this.localFrame, 0, this.ni, 0, this.dpc, this.opc);
        this.localFrame[5] = 23;
        link.send(this.localFrame, 6);
    }

    private boolean checkPattern(Mtp2Buffer frame, int sltmLen, byte[] pattern) {
        if (sltmLen != pattern.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (frame.frame[i + 10] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    public static final int dpc(byte[] sif, int shift) {
        int dpc = sif[0 + shift] & 0xFF | (sif[1 + shift] & 0x3F) << 8;
        return dpc;
    }

    public static final int opc(byte[] sif, int shift) {
        int opc = (sif[1 + shift] & 0xC0) >> 6 | (sif[2 + shift] & 0xFF) << 2 | (sif[3 + shift] & 0xF) << 10;
        return opc;
    }

    public static final int sls(byte[] sif, int shift) {
        int sls = (sif[3 + shift] & 0xF0) >>> 4;
        return sls;
    }

    public static final int si(byte[] data) {
        int serviceIndicator = data[0] & 0xF;
        return serviceIndicator;
    }

    public static final int ssi(byte[] data) {
        int subserviceIndicator = data[0] >> 4 & 0xF;
        return subserviceIndicator;
    }

    public static void writeRoutingLabel(byte[] data, int si, int ssi, int sls, int dpc, int opc) {
        Mtp3.writeRoutingLabel(0, data, si, ssi, sls, dpc, opc);
    }

    public static void writeRoutingLabel(int shift, byte[] data, int si, int ssi, int sls, int dpc, int opc) {
        data[0 + shift] = (byte)((ssi & 0xF) << 4 | si & 0xF);
        data[1 + shift] = (byte)dpc;
        data[2 + shift] = (byte)(dpc >> 8 & 0x3F | (opc & 3) << 6);
        data[3 + shift] = (byte)(opc >> 2);
        data[4 + shift] = (byte)(opc >> 10 & 0xF | (sls & 0xF) << 4);
    }

    protected class SLTMTest
    extends Task {
        private Mtp2 link;
        private int tryCount;
        private byte[] sltm;
        private int ttl;
        private boolean started;

        private SLTMTest(Mtp2 link, Scheduler scheduler) {
            super(scheduler);
            this.sltm = new byte[7 + SLTM_PATTERN.length];
            this.ttl = 0;
            this.started = false;
            this.link = link;
        }

        public void start() {
            this.started = true;
            this.tryCount = 0;
            this.activate(true);
            this.ttl = 120;
            this.ping();
            this.scheduler.submitHeatbeat((Task)this);
        }

        public void stop() {
            this.started = false;
            this.cancel();
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void ack() {
            this.cancel();
            this.tryCount = -1;
            this.ttl = 900;
            this.scheduler.submitHeatbeat((Task)this);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("(%s) SLTM acknowledged, Link test passed", this.link.getName()));
            }
        }

        public void ping() {
            Mtp3.writeRoutingLabel(this.sltm, 1, Mtp3.this.ni, this.link.getSls(), Mtp3.this.dpc, Mtp3.this.opc);
            this.sltm[5] = 17;
            this.sltm[6] = (byte)(SLTM_PATTERN.length << 4);
            System.arraycopy(SLTM_PATTERN, 0, this.sltm, 7, SLTM_PATTERN.length);
            this.link.send(this.sltm, this.sltm.length);
            ++this.tryCount;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("(%s) SLTM sent, try number = %d", this.link.getName(), this.tryCount));
            }
        }

        public long perform() {
            if (this.started) {
                return 0L;
            }
            if (this.ttl > 0) {
                --this.ttl;
                return 0L;
            }
            switch (this.tryCount) {
                case -1: {
                    this.ttl = 120;
                    this.ping();
                    this.scheduler.submitHeatbeat((Task)this);
                    break;
                }
                case 0: {
                    this.ttl = 120;
                    this.ping();
                    this.scheduler.submitHeatbeat((Task)this);
                    break;
                }
                case 1: {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("(%s) SLTM message was not acknowledged, Link failed", this.link.getName()));
                    }
                    Mtp3.this.linkFailed(this.link);
                    this.started = false;
                }
            }
            return 0L;
        }
    }
}

