/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.smstpdu;

import java.nio.charset.Charset;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.smstpdu.SmsTpdu;
import org.restcomm.protocols.ss7.map.api.smstpdu.SmsTpduType;
import org.restcomm.protocols.ss7.map.smstpdu.SmsCommandTpduImpl;
import org.restcomm.protocols.ss7.map.smstpdu.SmsDeliverReportTpduImpl;
import org.restcomm.protocols.ss7.map.smstpdu.SmsDeliverTpduImpl;
import org.restcomm.protocols.ss7.map.smstpdu.SmsStatusReportTpduImpl;
import org.restcomm.protocols.ss7.map.smstpdu.SmsSubmitReportTpduImpl;
import org.restcomm.protocols.ss7.map.smstpdu.SmsSubmitTpduImpl;

public abstract class SmsTpduImpl
implements SmsTpdu {
    protected static int _MASK_TP_MTI = 3;
    protected static int _MASK_TP_MMS = 4;
    protected static int _MASK_TP_RD = 4;
    protected static int _MASK_TP_LP = 8;
    protected static int _MASK_TP_SRI = 32;
    protected static int _MASK_TP_SRR = 32;
    protected static int _MASK_TP_SRQ = 32;
    protected static int _MASK_TP_UDHI = 64;
    protected static int _MASK_TP_RP = 128;
    protected static int _MASK_TP_VPF = 24;
    protected static int _UserDataLimit = 140;
    protected static int _UserDataStatusReportLimit = 131;
    protected static int _UserDataSubmitReportLimit = 152;
    protected static int _UserDataDeliverReportLimit = 159;
    protected static int _CommandDataLimit = 146;
    protected boolean mobileOriginatedMessage;
    protected SmsTpduType tpduType;

    protected SmsTpduImpl() {
    }

    public static SmsTpduImpl createInstance(byte[] data, boolean mobileOriginatedMessage, Charset gsm8Charset) throws MAPException {
        if (data == null) {
            throw new MAPException("Error creating a new SmsTpduImpl instance: data is empty");
        }
        if (data.length < 1) {
            throw new MAPException("Error creating a new SmsTpduImpl instance: data length is equal zero");
        }
        int tpMti = data[0] & _MASK_TP_MTI;
        if (mobileOriginatedMessage) {
            SmsTpduType type = SmsTpduType.getMobileOriginatedInstance(tpMti);
            switch (type) {
                case SMS_DELIVER_REPORT: {
                    return new SmsDeliverReportTpduImpl(data, gsm8Charset);
                }
                case SMS_SUBMIT: {
                    return new SmsSubmitTpduImpl(data, gsm8Charset);
                }
                case SMS_COMMAND: {
                    return new SmsCommandTpduImpl(data);
                }
            }
        } else {
            SmsTpduType type = SmsTpduType.getMobileTerminatedInstance(tpMti);
            switch (type) {
                case SMS_DELIVER: {
                    return new SmsDeliverTpduImpl(data, gsm8Charset);
                }
                case SMS_SUBMIT_REPORT: {
                    return new SmsSubmitReportTpduImpl(data, gsm8Charset);
                }
                case SMS_STATUS_REPORT: {
                    return new SmsStatusReportTpduImpl(data, gsm8Charset);
                }
            }
        }
        throw new MAPException("Error creating a new SmsTpduImpl instance: unsupported Sms Tpdu type");
    }

    @Override
    public SmsTpduType getSmsTpduType() {
        return this.tpduType;
    }
}

