/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.BasicServiceCode;
import org.restcomm.protocols.ss7.map.api.service.supplementary.CallBarringFeature;
import org.restcomm.protocols.ss7.map.api.service.supplementary.SSStatus;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.BasicServiceCodeImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.SSStatusImpl;

public class CallBarringFeatureImpl
extends SequenceBase
implements CallBarringFeature {
    public static final int _ID_ssStatus = 4;
    private BasicServiceCode basicService;
    private SSStatus ssStatus;

    public CallBarringFeatureImpl() {
        super("CallBarringFeature");
    }

    public CallBarringFeatureImpl(BasicServiceCode basicService, SSStatus ssStatus) {
        super("CallBarringFeature");
        this.basicService = basicService;
        this.ssStatus = ssStatus;
    }

    @Override
    public BasicServiceCode getBasicService() {
        return this.basicService;
    }

    @Override
    public SSStatus getSsStatus() {
        return this.ssStatus;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.basicService = null;
        this.ssStatus = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 2: 
                    case 3: {
                        this.basicService = new BasicServiceCodeImpl();
                        ((BasicServiceCodeImpl)this.basicService).decodeAll(ais);
                        continue block4;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " ssStatus: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ssStatus = new SSStatusImpl();
                        ((SSStatusImpl)this.ssStatus).decodeAll(ais);
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.basicService != null) {
            ((BasicServiceCodeImpl)this.basicService).encodeAll(asnOs);
        }
        if (this.ssStatus != null) {
            ((SSStatusImpl)this.ssStatus).encodeAll(asnOs, 2, 4);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.basicService != null) {
            sb.append("basicService=");
            sb.append(this.basicService);
        }
        if (this.ssStatus != null) {
            sb.append(", ssStatus=");
            sb.append(this.ssStatus);
        }
        sb.append("]");
        return sb.toString();
    }
}

