/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.BasicServiceCode;
import org.restcomm.protocols.ss7.map.api.service.supplementary.CCBSFeature;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.BasicServiceCodeImpl;

public class CCBSFeatureImpl
extends SequenceBase
implements CCBSFeature {
    public static final int _TAG_ccbsIndex = 0;
    public static final int _TAG_bSubscriberNumber = 1;
    public static final int _TAG_bSubscriberSubaddress = 2;
    public static final int _TAG_basicServiceGroup = 3;
    private Integer ccbsIndex;
    private ISDNAddressString bSubscriberNumber;
    private ISDNAddressString bSubscriberSubaddress;
    private BasicServiceCode basicServiceCode;

    public CCBSFeatureImpl() {
        super("CCBSFeature");
    }

    public CCBSFeatureImpl(Integer ccbsIndex, ISDNAddressString bSubscriberNumber, ISDNAddressString bSubscriberSubaddress, BasicServiceCode basicServiceCode) {
        super("CCBSFeature");
        this.ccbsIndex = ccbsIndex;
        this.bSubscriberNumber = bSubscriberNumber;
        this.bSubscriberSubaddress = bSubscriberSubaddress;
        this.basicServiceCode = basicServiceCode;
    }

    @Override
    public Integer getCcbsIndex() {
        return this.ccbsIndex;
    }

    @Override
    public ISDNAddressString getBSubscriberNumber() {
        return this.bSubscriberNumber;
    }

    @Override
    public ISDNAddressString getBSubscriberSubaddress() {
        return this.bSubscriberSubaddress;
    }

    @Override
    public BasicServiceCode getBasicServiceCode() {
        return this.basicServiceCode;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ccbsIndex = null;
        this.bSubscriberNumber = null;
        this.bSubscriberSubaddress = null;
        this.basicServiceCode = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block6: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " ccbsIndex: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ccbsIndex = (int)ais.readInteger();
                        continue block6;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " bSubscriberNumber: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.bSubscriberNumber = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.bSubscriberNumber).decodeAll(ais);
                        continue block6;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " bSubscriberSubaddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.bSubscriberSubaddress = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.bSubscriberSubaddress).decodeAll(ais);
                        continue block6;
                    }
                    case 3: {
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.basicServiceCode = new BasicServiceCodeImpl();
                        ((BasicServiceCodeImpl)this.basicServiceCode).decodeAll(ais2);
                        continue block6;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.ccbsIndex != null) {
                asnOs.writeInteger(2, 0, this.ccbsIndex.intValue());
            }
            if (this.bSubscriberNumber != null) {
                ((ISDNAddressStringImpl)this.bSubscriberNumber).encodeAll(asnOs, 2, 1);
            }
            if (this.bSubscriberSubaddress != null) {
                ((ISDNAddressStringImpl)this.bSubscriberSubaddress).encodeAll(asnOs, 2, 2);
            }
            if (this.basicServiceCode != null) {
                asnOs.writeTag(2, false, 3);
                int pos = asnOs.StartContentDefiniteLength();
                ((BasicServiceCodeImpl)this.basicServiceCode).encodeAll(asnOs);
                asnOs.FinalizeContent(pos);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.ccbsIndex != null) {
            sb.append("ccbsIndex=");
            sb.append(this.ccbsIndex);
            sb.append(", ");
        }
        if (this.bSubscriberNumber != null) {
            sb.append("bSubscriberNumber=");
            sb.append(this.bSubscriberNumber);
            sb.append(", ");
        }
        if (this.bSubscriberSubaddress != null) {
            sb.append("bSubscriberSubaddress=");
            sb.append(this.bSubscriberSubaddress);
            sb.append(", ");
        }
        if (this.basicServiceCode != null) {
            sb.append("basicServiceCode=");
            sb.append(this.basicServiceCode);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

