/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement;

import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtQoSSubscribed_BitRateExtended;

public class ExtQoSSubscribed_BitRateExtendedImpl
implements ExtQoSSubscribed_BitRateExtended {
    private int data;

    public ExtQoSSubscribed_BitRateExtendedImpl(int data, boolean isSourceData) {
        if (isSourceData) {
            this.data = data;
        } else {
            this.setData(data);
        }
    }

    protected void setData(int val) {
        this.data = val < 8700 ? 0 : (val >= 8700 && val <= 16000 ? (val - 8600) / 100 : (val >= 17000 && val <= 128000 ? (val - 16000) / 1000 + 74 : (val >= 130000 && val <= 256000 ? (val - 128000) / 2000 + 186 : 0)));
    }

    @Override
    public int getSourceData() {
        return this.data;
    }

    @Override
    public boolean isUseNonextendedValue() {
        return this.data == 0;
    }

    @Override
    public int getBitRate() {
        if (this.data > 0 && this.data < 75) {
            return 8600 + this.data * 100;
        }
        if (this.data >= 75 && this.data < 187) {
            return 16000 + (this.data - 74) * 1000;
        }
        if (this.data >= 187 && this.data < 251) {
            return 128000 + (this.data - 186) * 2000;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BitRate(kbit/s)=");
        int v = this.getBitRate();
        if (this.data == 255) {
            sb.append("reserved");
        } else if (v == 0) {
            sb.append("Subscribed maximum bit rate for uplink / reserved");
        } else {
            sb.append(v);
        }
        return sb.toString();
    }
}

