/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.CallBarringData;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtCallBarringFeature;
import org.restcomm.protocols.ss7.map.api.service.supplementary.Password;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.ExtCallBarringFeatureImpl;
import org.restcomm.protocols.ss7.map.service.supplementary.PasswordImpl;

public class CallBarringDataImpl
extends SequenceBase
implements CallBarringData {
    public static final String _PrimitiveName = "CallBarringData";
    private ArrayList<ExtCallBarringFeature> callBarringFeatureList;
    private Password password;
    private Integer wrongPasswordAttemptsCounter;
    private boolean notificationToCSE;
    private MAPExtensionContainer extensionContainer;

    public CallBarringDataImpl() {
        super(_PrimitiveName);
    }

    public CallBarringDataImpl(ArrayList<ExtCallBarringFeature> callBarringFeatureList, Password password, Integer wrongPasswordAttemptsCounter, boolean notificationToCSE, MAPExtensionContainer extensionContainer) {
        super(_PrimitiveName);
        this.callBarringFeatureList = callBarringFeatureList;
        this.password = password;
        this.wrongPasswordAttemptsCounter = wrongPasswordAttemptsCounter;
        this.notificationToCSE = notificationToCSE;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public ArrayList<ExtCallBarringFeature> getCallBarringFeatureList() {
        return this.callBarringFeatureList;
    }

    @Override
    public Password getPassword() {
        return this.password;
    }

    @Override
    public Integer getWrongPasswordAttemptsCounter() {
        return this.wrongPasswordAttemptsCounter;
    }

    @Override
    public boolean getNotificationToCSE() {
        return this.notificationToCSE;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.callBarringFeatureList = null;
        this.password = null;
        this.wrongPasswordAttemptsCounter = null;
        this.notificationToCSE = false;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (tag != 16 || ais.getTagClass() != 0 || ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding CallBarringData: Parameter callBarringFeatureList has bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        AsnInputStream ais2 = ais.readSequenceStream();
        this.callBarringFeatureList = new ArrayList();
        while (ais2.available() != 0) {
            tag = ais2.readTag();
            if (tag != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding CallBarringData.extCallBarringFeature: Parameter extCallBarringFeature is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
            }
            ExtCallBarringFeatureImpl extCallBarringFeature = new ExtCallBarringFeatureImpl();
            extCallBarringFeature.decodeAll(ais2);
            this.callBarringFeatureList.add(extCallBarringFeature);
        }
        if (this.callBarringFeatureList.size() < 1 || this.callBarringFeatureList.size() > 32) {
            throw new MAPParsingComponentException("Error while decoding CallBarringData: Parameter callBarringFeatureList size must be from 1 to 32, found: " + this.callBarringFeatureList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        block7: while (ais.available() != 0) {
            tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding CallBarringData.extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block7;
                    }
                    case 18: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding CallBarringData.password: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.password = new PasswordImpl();
                        ((PasswordImpl)this.password).decodeAll(ais);
                        continue block7;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding CallBarringData.password: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.wrongPasswordAttemptsCounter = (int)ais.readInteger();
                        if (this.wrongPasswordAttemptsCounter >= 0 && this.wrongPasswordAttemptsCounter <= 4) continue block7;
                        throw new MAPParsingComponentException("Error while encoding CallBarringData parameter wrongPasswordAttemptsCounter is out of range (0..4). Actual value: " + this.wrongPasswordAttemptsCounter, MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding CallBarringData.notificationToCSE: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.notificationToCSE = Boolean.TRUE;
                        continue block7;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.callBarringFeatureList == null) {
            throw new MAPException("Error while encoding CallBarringData the mandatory parameter callBarringFeatureList is not defined");
        }
        if (this.callBarringFeatureList.size() < 1 || this.callBarringFeatureList.size() > 32) {
            throw new MAPException("Error while encoding CallBarringData parameter callBarringFeatureList is out of range (0..32). Actual size: " + this.callBarringFeatureList.size());
        }
        try {
            asnOs.writeTag(0, false, 16);
            int pos = asnOs.StartContentDefiniteLength();
            for (ExtCallBarringFeature extCallBarringFeature : this.callBarringFeatureList) {
                ((ExtCallBarringFeatureImpl)extCallBarringFeature).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
            if (this.password != null) {
                ((PasswordImpl)this.password).encodeAll(asnOs);
            }
            if (this.wrongPasswordAttemptsCounter != null) {
                if (this.wrongPasswordAttemptsCounter < 0 || this.wrongPasswordAttemptsCounter > 4) {
                    throw new MAPException("Error while encoding CallBarringData parameter wrongPasswordAttemptsCounter is out of range (0..4). Actual value: " + this.wrongPasswordAttemptsCounter);
                }
                asnOs.writeInteger(this.wrongPasswordAttemptsCounter.intValue());
            }
            if (this.notificationToCSE) {
                asnOs.writeNull();
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding CallBarringData: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding CallBarringData: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.callBarringFeatureList != null) {
            sb.append("callBarringFeatureList=[");
            boolean firstItem = true;
            for (ExtCallBarringFeature extCallBarringFeature : this.callBarringFeatureList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(extCallBarringFeature);
            }
            sb.append("]");
        }
        if (this.password != null) {
            sb.append(", password=");
            sb.append(this.password);
        }
        if (this.wrongPasswordAttemptsCounter != null) {
            sb.append(", wrongPasswordAttemptsCounter=");
            sb.append(this.wrongPasswordAttemptsCounter);
        }
        if (this.notificationToCSE) {
            sb.append(", notificationToCSE");
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        sb.append("]");
        return sb.toString();
    }
}

