/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPMessageType;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.IMSI;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.PurgeMSRequest;
import org.restcomm.protocols.ss7.map.primitives.IMSIImpl;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.service.mobility.MobilityMessageImpl;

public class PurgeMSRequestImpl
extends MobilityMessageImpl
implements PurgeMSRequest {
    protected static final int _TAG_vlrNumber = 0;
    protected static final int _TAG_sgsnNumber = 1;
    public static final int _TAG_PurgeMSRequest = 3;
    public static final String _PrimitiveName = "PurgeMSRequest";
    private IMSI imsi;
    private ISDNAddressString vlrNumber;
    private ISDNAddressString sgsnNumber;
    private MAPExtensionContainer extensionContainer;
    private long mapProtocolVersion;

    public PurgeMSRequestImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public PurgeMSRequestImpl(IMSI imsi, ISDNAddressString vlrNumber, ISDNAddressString sgsnNumber, MAPExtensionContainer extensionContainer, long mapProtocolVersion) {
        this.imsi = imsi;
        this.vlrNumber = vlrNumber;
        this.sgsnNumber = sgsnNumber;
        this.extensionContainer = extensionContainer;
        this.mapProtocolVersion = mapProtocolVersion;
    }

    @Override
    public MAPMessageType getMessageType() {
        return MAPMessageType.purgeMS_Request;
    }

    @Override
    public int getOperationCode() {
        return 67;
    }

    @Override
    public IMSI getImsi() {
        return this.imsi;
    }

    @Override
    public ISDNAddressString getVlrNumber() {
        return this.vlrNumber;
    }

    @Override
    public ISDNAddressString getSgsnNumber() {
        return this.sgsnNumber;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.mapProtocolVersion >= 3L) {
            return 3;
        }
        return 16;
    }

    @Override
    public int getTagClass() {
        if (this.mapProtocolVersion >= 3L) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PurgeMSRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PurgeMSRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PurgeMSRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PurgeMSRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.vlrNumber = null;
        this.sgsnNumber = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (num == 0) {
                if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error while decoding PurgeMSRequest.imsi: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.imsi = new IMSIImpl();
                ((IMSIImpl)this.imsi).decodeAll(ais);
            } else if (num == 1 && this.mapProtocolVersion < 3L) {
                if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error while decoding PurgeMSRequest.imsi: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.vlrNumber = new ISDNAddressStringImpl();
                ((ISDNAddressStringImpl)this.vlrNumber).decodeAll(ais);
            } else if (this.mapProtocolVersion >= 3L) {
                block0 : switch (ais.getTagClass()) {
                    case 0: {
                        switch (tag) {
                            case 16: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding PurgeMSRequest.extensionContainer: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    case 2: {
                        switch (tag) {
                            case 0: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding PurgeMSRequest.vlrNumber: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.vlrNumber = new ISDNAddressStringImpl();
                                ((ISDNAddressStringImpl)this.vlrNumber).decodeAll(ais);
                                break block0;
                            }
                            case 1: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding PurgeMSRequest.sgsnNumber: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.sgsnNumber = new ISDNAddressStringImpl();
                                ((ISDNAddressStringImpl)this.sgsnNumber).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    default: {
                        ais.advanceElement();
                    }
                }
            }
            ++num;
        }
        if (this.mapProtocolVersion < 3L && this.vlrNumber == null) {
            throw new MAPParsingComponentException("Error while decoding PurgeMSRequest: vlrNumber is mandatory for MAP V2 but not found ", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding PurgeMSRequest: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.imsi == null) {
            throw new MAPException("Error while encoding PurgeMSRequest the mandatory parameter imsi is not defined");
        }
        if (this.mapProtocolVersion >= 3L) {
            ((IMSIImpl)this.imsi).encodeAll(asnOs);
            if (this.vlrNumber != null) {
                ((ISDNAddressStringImpl)this.vlrNumber).encodeAll(asnOs, 2, 0);
            }
            if (this.sgsnNumber != null) {
                ((ISDNAddressStringImpl)this.sgsnNumber).encodeAll(asnOs, 2, 1);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
        } else {
            if (this.vlrNumber == null) {
                throw new MAPException("Error while encoding PurgeMSRequest the mandatory parameter vlrNumber is not defined");
            }
            ((IMSIImpl)this.imsi).encodeAll(asnOs);
            ((ISDNAddressStringImpl)this.vlrNumber).encodeAll(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi.toString());
            sb.append(", ");
        }
        if (this.vlrNumber != null) {
            sb.append("vlrNumber=");
            sb.append(this.vlrNumber.toString());
            sb.append(", ");
        }
        if (this.sgsnNumber != null) {
            sb.append("sgsnNumber=");
            sb.append(this.sgsnNumber.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

