/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.LocationArea;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.PagingArea;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.restcomm.protocols.ss7.map.service.mobility.locationManagement.LocationAreaImpl;

public class PagingAreaImpl
implements PagingArea,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "PagingArea";
    private ArrayList<LocationArea> locationAreas;

    public PagingAreaImpl() {
    }

    public PagingAreaImpl(ArrayList<LocationArea> locationAreas) {
        this.locationAreas = locationAreas;
    }

    @Override
    public ArrayList<LocationArea> getLocationAreas() {
        return this.locationAreas;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PagingArea: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PagingArea: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PagingArea: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PagingArea: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.locationAreas = new ArrayList();
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding PagingArea: Parameter locationAreas has bad tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
            }
            LocationAreaImpl at = new LocationAreaImpl();
            at.decodeAll(ais);
            this.locationAreas.add(at);
        }
        if (this.locationAreas.size() < 1 || this.locationAreas.size() > 5) {
            throw new MAPParsingComponentException("Error while decoding PagingArea: locationAreas must be from 1 to 5, found:" + this.locationAreas.size(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding PagingArea: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.locationAreas == null || this.locationAreas.size() < 1 || this.locationAreas.size() > 5) {
            throw new MAPException("LocationAreas list must contains from 1 to 5 elemets");
        }
        for (LocationArea at : this.locationAreas) {
            ((LocationAreaImpl)at).encodeAll(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.locationAreas != null) {
            for (LocationArea at : this.locationAreas) {
                if (at == null) continue;
                sb.append(at.toString());
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

