/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.lsm.ResponseTime;
import org.restcomm.protocols.ss7.map.api.service.lsm.ResponseTimeCategory;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class ResponseTimeImpl
implements ResponseTime,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "ResponseTime";
    private ResponseTimeCategory responseTimeCategory = null;

    public ResponseTimeImpl() {
    }

    public ResponseTimeImpl(ResponseTimeCategory responseTimeCategory) {
        this.responseTimeCategory = responseTimeCategory;
    }

    @Override
    public ResponseTimeCategory getResponseTimeCategory() {
        return this.responseTimeCategory;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ResponseTime: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ResponseTime: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ResponseTime: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ResponseTime: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.responseTimeCategory = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 10) {
            throw new MAPParsingComponentException("Error while decoding ResponseTime: Parameter 0[ResponseTimeCategory ::= ENUMERATED] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int category = (int)ais.readInteger();
        this.responseTimeCategory = ResponseTimeCategory.getResponseTimeCategory(category);
        while (ais.available() != 0) {
            switch (ais.readTag()) {
                default: 
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ResponseTime: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.responseTimeCategory == null) {
            throw new MAPException("Error while encoding ResponseTime the mandatory parameter responseTimeCategory is not defined");
        }
        try {
            asnOs.writeInteger(0, 10, this.responseTimeCategory.getCategory());
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding responseTimeCategory: ", e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding responseTimeCategory: ", e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.responseTimeCategory == null ? 0 : this.responseTimeCategory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResponseTimeImpl other = (ResponseTimeImpl)obj;
        return this.responseTimeCategory == other.responseTimeCategory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.responseTimeCategory != null) {
            sb.append("responseTimeCategory=");
            sb.append((Object)this.responseTimeCategory);
        }
        sb.append("]");
        return sb.toString();
    }
}

