/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.primitives;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;

public abstract class BitStringBase
implements MAPAsnPrimitive {
    private static final String DATA = "data";
    private static final String DEFAULT_VALUE = null;
    protected BitSetStrictLength bitString;
    protected int minLength;
    protected int maxLength;
    protected int curLength;
    protected String _PrimitiveName;
    protected static final XMLFormat<BitStringBase> BIT_STRING_BASE_XML = new XMLFormat<BitStringBase>(BitStringBase.class){

        @Override
        public void read(XMLFormat.InputElement xml, BitStringBase bitStringBase) throws XMLStreamException {
            String s = xml.getAttribute(BitStringBase.DATA, DEFAULT_VALUE);
            if (s != null) {
                int i1 = 0;
                bitStringBase.bitString = new BitSetStrictLength(bitStringBase.curLength);
                for (char ch : s.toCharArray()) {
                    if (ch == '1') {
                        bitStringBase.bitString.set(i1);
                    }
                    ++i1;
                }
            }
        }

        @Override
        public void write(BitStringBase bitStringBase, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (bitStringBase.bitString != null) {
                StringBuilder sb = new StringBuilder();
                for (int i1 = 0; i1 < bitStringBase.bitString.getStrictLength(); ++i1) {
                    if (bitStringBase.bitString.get(i1)) {
                        sb.append("1");
                        continue;
                    }
                    sb.append("0");
                }
                xml.setAttribute(BitStringBase.DATA, sb.toString());
            }
        }
    };

    public BitStringBase(int minLength, int maxLength, int curLength, String _PrimitiveName) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.curLength = curLength;
        this._PrimitiveName = _PrimitiveName;
        this.bitString = new BitSetStrictLength(curLength);
    }

    public BitStringBase(int minLength, int maxLength, int curLength, String _PrimitiveName, BitSetStrictLength data) {
        this(minLength, maxLength, curLength, _PrimitiveName);
        this.bitString = data;
    }

    @Override
    public int getTag() throws MAPException {
        return 3;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (!ansIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": field must be primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int minLen = (this.minLength - 1) / 8 + 2;
        int maxLen = (this.maxLength - 1) / 8 + 2;
        if (length < minLen || length > maxLen) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": the field must contain from " + minLen + " to " + maxLen + " octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.bitString = ansIS.readBitStringData(length);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.bitString == null) {
            throw new MAPException("Error while encoding the " + this._PrimitiveName + ": data is not defined");
        }
        try {
            asnOs.writeBitStringData(this.bitString);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bitString == null ? 0 : this.bitString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitStringBase other = (BitStringBase)obj;
        return !(this.bitString == null ? other.bitString != null : !this.bitString.equals(other.bitString));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [Data=");
        if (this.bitString != null) {
            for (int i = 0; i < this.bitString.getStrictLength(); ++i) {
                if (i % 8 == 0) {
                    sb.append(" ");
                }
                if (this.bitString.get(i)) {
                    sb.append("1");
                    continue;
                }
                sb.append("0");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

