/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl.router;

import javolution.util.FastCollection;
import javolution.util.FastList;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.router.SINode;

public class OPCNode {
    protected int dpc;
    protected int opc;
    protected FastList<SINode> siList = new FastList();
    private SINode wildCardSINode;

    protected OPCNode(int dpc, int opc) {
        this.dpc = dpc;
        this.opc = opc;
    }

    protected void addSi(int si, AsImpl asImpl) throws Exception {
        FastCollection.Record n = this.siList.head();
        FastCollection.Record end = this.siList.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            SINode siNode = (SINode)((FastList.Node)n).getValue();
            if (siNode.si != si) continue;
            throw new Exception(String.format("Service indicator %d already exist for OPC %d and DPC %d", si, this.opc, this.dpc));
        }
        SINode siNode = new SINode(si, asImpl);
        this.siList.add(siNode);
        if (si == -1) {
            this.wildCardSINode = siNode;
        }
    }

    protected AsImpl getAs(short si) {
        FastCollection.Record n = this.siList.head();
        FastCollection.Record end = this.siList.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            SINode siNode = (SINode)((FastList.Node)n).getValue();
            if (siNode.si != si) continue;
            return siNode.asImpl;
        }
        if (this.wildCardSINode != null) {
            return this.wildCardSINode.asImpl;
        }
        return null;
    }
}

