/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl;

import javolution.util.FastCollection;
import javolution.util.FastSet;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AsStateListener;
import org.restcomm.protocols.ss7.m3ua.impl.M3UAManagementImpl;
import org.restcomm.protocols.ss7.mtp.Mtp3PausePrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3ResumePrimitive;

public class RouteRow
implements AsStateListener {
    private static final Logger logger = Logger.getLogger(RouteRow.class);
    private int mtp3Status = 3;
    private FastSet<AsImpl> servedByAsSet = null;
    private int dpc;
    private final M3UAManagementImpl m3uaManagement;

    RouteRow(int dpc, M3UAManagementImpl m3uaManagement) {
        this.dpc = dpc;
        this.m3uaManagement = m3uaManagement;
        this.servedByAsSet = new FastSet();
    }

    public int getDpc() {
        return this.dpc;
    }

    public void setDpc(int dpc) {
        this.dpc = dpc;
    }

    protected void addServedByAs(AsImpl asImpl) {
        this.servedByAsSet.add(asImpl);
        asImpl.addAsStateListener(this);
    }

    protected int servedByAsSize() {
        return this.servedByAsSet.size();
    }

    protected void removeServedByAs(AsImpl asImpl) {
        boolean flag = this.servedByAsSet.remove(asImpl);
        asImpl.removeAsStateListener(this);
        if (!flag) {
            logger.error(String.format("Removing route As=%s from DPC=%d failed!", asImpl, this.dpc));
        } else if (logger.isDebugEnabled()) {
            logger.debug(String.format("Removed route As=%s from DPC=%d successfully!", asImpl, this.dpc));
        }
    }

    @Override
    public void onAsActive(AsImpl asImpl) {
        if (this.mtp3Status != 4) {
            this.mtp3Status = 4;
            Mtp3ResumePrimitive mtp3ResumePrimitive = new Mtp3ResumePrimitive(this.dpc);
            this.m3uaManagement.sendResumeMessageToLocalUser(mtp3ResumePrimitive);
        }
    }

    @Override
    public void onAsInActive(AsImpl asImpl) {
        if (this.mtp3Status != 3) {
            FastCollection.Record r = this.servedByAsSet.head();
            FastCollection.Record end = this.servedByAsSet.tail();
            while ((r = r.getNext()) != end) {
                AsImpl asImplTmp = this.servedByAsSet.valueOf(r);
                if (!asImplTmp.getState().getName().equals("ACTIVE") && !asImplTmp.getState().getName().equals("PENDING")) continue;
                return;
            }
            this.mtp3Status = 3;
            Mtp3PausePrimitive mtp3PausePrimitive = new Mtp3PausePrimitive(this.dpc);
            this.m3uaManagement.sendPauseMessageToLocalUser(mtp3PausePrimitive);
        }
    }

    public String toString() {
        return "RouteRow [dpc=" + this.dpc + ", mtp3Status=" + this.mtp3Status + ", asSet=" + this.servedByAsSet + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dpc;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RouteRow other = (RouteRow)obj;
        return this.dpc == other.dpc;
    }
}

