/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl;

import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.m3ua.ExchangeType;
import org.restcomm.protocols.ss7.m3ua.Functionality;
import org.restcomm.protocols.ss7.m3ua.IPSPType;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspFactoryImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspState;
import org.restcomm.protocols.ss7.m3ua.impl.MessageHandler;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSM;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.UnknownTransitionException;
import org.restcomm.protocols.ss7.m3ua.message.asptm.ASPActive;
import org.restcomm.protocols.ss7.m3ua.message.asptm.ASPActiveAck;
import org.restcomm.protocols.ss7.m3ua.message.asptm.ASPInactive;
import org.restcomm.protocols.ss7.m3ua.message.asptm.ASPInactiveAck;
import org.restcomm.protocols.ss7.m3ua.parameter.ErrorCode;
import org.restcomm.protocols.ss7.m3ua.parameter.RoutingContext;
import org.restcomm.protocols.ss7.m3ua.parameter.TrafficModeType;

public class AspTrafficMaintenanceHandler
extends MessageHandler {
    private static final Logger logger = Logger.getLogger(AspTrafficMaintenanceHandler.class);

    public AspTrafficMaintenanceHandler(AspFactoryImpl aspFactoryImpl) {
        super(aspFactoryImpl);
    }

    private void handleAspInactive(AspImpl aspImpl, ASPInactive aspInactive) {
        AsImpl appServer = (AsImpl)aspImpl.getAs();
        FSM aspPeerFSM = aspImpl.getPeerFSM();
        if (aspPeerFSM == null) {
            logger.error(String.format("Received ASPINACTIVE=%s for ASP=%s. But peer FSM for ASP is null.", aspInactive, this.aspFactoryImpl.getName()));
            return;
        }
        FSM asLocalFSM = appServer.getLocalFSM();
        if (asLocalFSM == null) {
            logger.error(String.format("Received ASPINACTIVE=%s for ASP=%s. But local FSM for AS is null.", aspInactive, this.aspFactoryImpl.getName()));
            return;
        }
        ASPInactiveAck aspInactAck = (ASPInactiveAck)this.aspFactoryImpl.messageFactory.createMessage(4, 4);
        aspInactAck.setRoutingContext(appServer.getRoutingContext());
        this.aspFactoryImpl.write(aspInactAck);
        try {
            aspPeerFSM.setAttribute("message", aspInactive);
            aspPeerFSM.signal("aspinactive");
            asLocalFSM.setAttribute("asp", aspImpl);
            asLocalFSM.signal("aspinactive");
        }
        catch (UnknownTransitionException e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void handleAspActive(AspImpl aspImpl, ASPActive aspActive) {
        FSM aspPeerFSM;
        AsImpl appServer = (AsImpl)aspImpl.getAs();
        TrafficModeType trfModType = aspActive.getTrafficModeType();
        if (appServer.getTrafficModeType() != null) {
            if (trfModType != null && appServer.getTrafficModeType().getMode() != trfModType.getMode()) {
                ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(5);
                this.sendError(appServer.getRoutingContext(), errorCodeObj);
                return;
            }
        } else if (trfModType == null) {
            appServer.setDefaultTrafficModeType();
        } else {
            appServer.setTrafficModeType(trfModType);
        }
        if ((aspPeerFSM = aspImpl.getPeerFSM()) == null) {
            logger.error(String.format("Received ASPACTIVE=%s for ASP=%s. But peer FSM for ASP is null.", aspActive, this.aspFactoryImpl.getName()));
            return;
        }
        FSM asLocalFSM = appServer.getLocalFSM();
        if (asLocalFSM == null) {
            logger.error(String.format("Received ASPACTIVE=%s for ASP=%s. But local FSM for AS is null.", aspActive, this.aspFactoryImpl.getName()));
            return;
        }
        ASPActiveAck aspActAck = (ASPActiveAck)this.aspFactoryImpl.messageFactory.createMessage(4, 3);
        aspActAck.setTrafficModeType(appServer.getTrafficModeType());
        aspActAck.setRoutingContext(appServer.getRoutingContext());
        this.aspFactoryImpl.write(aspActAck);
        try {
            aspPeerFSM.setAttribute("message", aspActive);
            aspPeerFSM.signal("aspactive");
            asLocalFSM.setAttribute("asp", aspImpl);
            asLocalFSM.signal("aspactive");
        }
        catch (UnknownTransitionException e) {
            logger.error(e.getMessage(), e);
        }
    }

    protected void handleAspActive(ASPActive aspActive) {
        RoutingContext rc = aspActive.getRoutingContext();
        if (this.aspFactoryImpl.getFunctionality() == Functionality.SGW || this.aspFactoryImpl.getFunctionality() == Functionality.AS && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.SE && this.aspFactoryImpl.getIpspType() == IPSPType.SERVER) {
            if (rc == null) {
                AspImpl aspImpl = this.getAspForNullRc();
                if (aspImpl == null) {
                    logger.error(String.format("Rx : ASP ACTIVE=%s with null RC for Aspfactory=%s. But no ASP configured for null RC. Sent back Error", aspActive, this.aspFactoryImpl.getName()));
                    return;
                }
                this.handleAspActive(aspImpl, aspActive);
            } else {
                long[] rcs = rc.getRoutingContexts();
                for (int count = 0; count < rcs.length; ++count) {
                    AspImpl aspImpl = this.aspFactoryImpl.getAsp(rcs[count]);
                    if (aspImpl == null) {
                        RoutingContext rcObj = this.aspFactoryImpl.parameterFactory.createRoutingContext(new long[]{rcs[count]});
                        ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                        this.sendError(rcObj, errorCodeObj);
                        logger.error(String.format("Rx : ASPACTIVE=%s with RC=%d for Aspfactory=%s. But no ASP configured for this RC. Sending back Error", aspActive, rcs[count], this.aspFactoryImpl.getName()));
                        continue;
                    }
                    this.handleAspActive(aspImpl, aspActive);
                }
            }
        } else {
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(null, errorCodeObj);
        }
    }

    private void handleAspActiveAck(AspImpl aspImpl, ASPActiveAck aspActiveAck, TrafficModeType trMode) {
        AsImpl asImpl = (AsImpl)aspImpl.getAs();
        if (trMode == null) {
            trMode = aspImpl.getAs().getDefaultTrafficModeType();
        }
        asImpl.setTrafficModeType(trMode);
        FSM aspLocalFSM = aspImpl.getLocalFSM();
        if (aspLocalFSM == null) {
            logger.error(String.format("Received ASPACTIVE_ACK=%s for ASP=%s. But local FSM is null.", aspActiveAck, this.aspFactoryImpl.getName()));
            return;
        }
        try {
            aspLocalFSM.signal("aspactiveack");
            if (this.aspFactoryImpl.getFunctionality() == Functionality.IPSP) {
                FSM asPeerFSM = asImpl.getPeerFSM();
                if (asPeerFSM == null) {
                    logger.error(String.format("Received ASPACTIVE_ACK=%s for ASP=%s. But Peer FSM of AS=%s is null.", aspActiveAck, this.aspFactoryImpl.getName(), asImpl));
                    return;
                }
                asPeerFSM.setAttribute("asp", aspImpl);
                asPeerFSM.signal("ntfyasactive");
            }
        }
        catch (UnknownTransitionException e) {
            logger.error(e.getMessage(), e);
        }
    }

    protected void handleAspActiveAck(ASPActiveAck aspActiveAck) {
        if (!this.aspFactoryImpl.started) {
            return;
        }
        RoutingContext rc = aspActiveAck.getRoutingContext();
        if (this.aspFactoryImpl.getFunctionality() == Functionality.AS || this.aspFactoryImpl.getFunctionality() == Functionality.SGW && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.SE && this.aspFactoryImpl.getIpspType() == IPSPType.CLIENT) {
            TrafficModeType trMode = aspActiveAck.getTrafficModeType();
            if (rc == null) {
                AspImpl aspImpl = this.getAspForNullRc();
                if (aspImpl == null) {
                    logger.error(String.format("Rx : ASP ACTIVE_ACK=%s with null RC for Aspfactory=%s. But no ASP configured for null RC. Sent back Error", aspActiveAck, this.aspFactoryImpl.getName()));
                    return;
                }
                this.handleAspActiveAck(aspImpl, aspActiveAck, trMode);
            } else {
                long[] rcs = rc.getRoutingContexts();
                for (int count = 0; count < rcs.length; ++count) {
                    AspImpl aspImpl = this.aspFactoryImpl.getAsp(rcs[count]);
                    this.handleAspActiveAck(aspImpl, aspActiveAck, trMode);
                }
            }
        } else {
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(rc, errorCodeObj);
        }
    }

    protected void handleAspInactive(ASPInactive aspInactive) {
        RoutingContext rc = aspInactive.getRoutingContext();
        if (this.aspFactoryImpl.getFunctionality() == Functionality.SGW || this.aspFactoryImpl.getFunctionality() == Functionality.AS && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.SE && this.aspFactoryImpl.getIpspType() == IPSPType.SERVER) {
            if (rc == null) {
                AspImpl aspImpl = this.getAspForNullRc();
                if (aspImpl == null) {
                    logger.error(String.format("Rx : ASPINACTIVE=%s with null RC for Aspfactory=%s. But no ASP configured for null RC. Sent back Error", aspInactive, this.aspFactoryImpl.getName()));
                    return;
                }
                this.handleAspInactive(aspImpl, aspInactive);
            } else {
                long[] rcs = rc.getRoutingContexts();
                for (int count = 0; count < rcs.length; ++count) {
                    AspImpl aspImpl = this.aspFactoryImpl.getAsp(rcs[count]);
                    if (aspImpl == null) {
                        RoutingContext rcObj = this.aspFactoryImpl.parameterFactory.createRoutingContext(new long[]{rcs[count]});
                        ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                        this.sendError(rcObj, errorCodeObj);
                        logger.error(String.format("Rx : ASPINACTIVE=%s with RC=%d for Aspfactory=%s. But no ASP configured for this RC. Sending back Error", aspInactive, rcs[count], this.aspFactoryImpl.getName()));
                        continue;
                    }
                    this.handleAspInactive(aspImpl, aspInactive);
                }
            }
        } else {
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(null, errorCodeObj);
        }
    }

    protected void handleAspInactiveAck(ASPInactiveAck aspInactiveAck) {
        if (!this.aspFactoryImpl.started) {
            return;
        }
        RoutingContext rc = aspInactiveAck.getRoutingContext();
        if (this.aspFactoryImpl.getFunctionality() == Functionality.AS || this.aspFactoryImpl.getFunctionality() == Functionality.SGW && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.SE && this.aspFactoryImpl.getIpspType() == IPSPType.CLIENT) {
            if (rc == null) {
                AspImpl aspImpl = this.getAspForNullRc();
                if (aspImpl == null) {
                    logger.error(String.format("Rx : ASPINACTIVE_ACK=%s with null RC for Aspfactory=%s. But no ASP configured for null RC. Sent back Error", aspInactiveAck, this.aspFactoryImpl.getName()));
                    return;
                }
                this.handleAspInactiveAck(aspImpl, aspInactiveAck);
            } else {
                long[] rcs = aspInactiveAck.getRoutingContext().getRoutingContexts();
                for (int count = 0; count < rcs.length; ++count) {
                    AspImpl aspImpl = this.aspFactoryImpl.getAsp(rcs[count]);
                    if (aspImpl == null) {
                        RoutingContext rcObj = this.aspFactoryImpl.parameterFactory.createRoutingContext(new long[]{rcs[count]});
                        ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(25);
                        this.sendError(rcObj, errorCodeObj);
                        logger.error(String.format("Rx : ASPINACTIVE_ACK=%s with RC=%d for Aspfactory=%s. But no ASP configured for this RC. Sending back Error", aspInactiveAck, rcs[count], this.aspFactoryImpl.getName()));
                        continue;
                    }
                    this.handleAspInactiveAck(aspImpl, aspInactiveAck);
                }
            }
        } else {
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(rc, errorCodeObj);
        }
    }

    private void handleAspInactiveAck(AspImpl aspImpl, ASPInactiveAck aspInactiveAck) {
        FSM aspLocalFSM = aspImpl.getLocalFSM();
        if (aspLocalFSM == null) {
            logger.error(String.format("Received ASPINACTIVE_ACK=%s for ASP=%s. But local FSM is null.", aspInactiveAck, this.aspFactoryImpl.getName()));
            return;
        }
        AsImpl asImpl = (AsImpl)aspImpl.getAs();
        try {
            aspLocalFSM.signal("aspinactiveack");
            if (this.aspFactoryImpl.getFunctionality() == Functionality.IPSP) {
                FSM asPeerFSM = asImpl.getPeerFSM();
                if (asPeerFSM == null) {
                    logger.error(String.format("Received ASPINACTIVE_ACK=%s for ASP=%s. But Peer FSM of AS=%s is null.", aspInactiveAck, this.aspFactoryImpl.getName(), asImpl));
                    return;
                }
                if (asImpl.getTrafficModeType().getMode() == 2) {
                    FastCollection.Record n = asImpl.appServerProcs.head();
                    FastCollection.Record end = asImpl.appServerProcs.tail();
                    while ((n = ((FastList.Node)n).getNext()) != end) {
                        AspImpl remAspImpl = (AspImpl)((FastList.Node)n).getValue();
                        FSM aspPeerFSM = remAspImpl.getPeerFSM();
                        AspState aspState = AspState.getState(aspPeerFSM.getState().getName());
                        if (aspState != AspState.ACTIVE) continue;
                        return;
                    }
                }
                asPeerFSM.setAttribute("asp", aspImpl);
                asPeerFSM.signal("ntfyaspending");
            }
        }
        catch (UnknownTransitionException e) {
            logger.error(e.getMessage(), e);
        }
    }
}

