/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp.netty;

import com.sun.nio.sctp.AssociationChangeNotification;
import com.sun.nio.sctp.Notification;
import com.sun.nio.sctp.PeerAddressChangeNotification;
import com.sun.nio.sctp.SendFailedNotification;
import com.sun.nio.sctp.ShutdownNotification;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.sctp.SctpMessage;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.PayloadData;
import org.mobicents.protocols.sctp.netty.NettyAssociationImpl;

public class NettySctpChannelInboundHandlerAdapter
extends ChannelInboundHandlerAdapter {
    Logger logger = Logger.getLogger(NettySctpChannelInboundHandlerAdapter.class);
    private volatile int maxInboundStreams = 1;
    private volatile int maxOutboundStreams = 1;
    protected NettyAssociationImpl association = null;
    protected Channel channel = null;
    protected ChannelHandlerContext ctx = null;
    protected long lastCongestionMonitorSecondPart;

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("channelInactive event: association=%s", this.association));
        }
        if (this.association != null) {
            this.association.markAssociationDown();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        Notification notification;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("userEventTriggered event: association=%s \nevent=%s", this.association, evt));
        }
        if (evt instanceof AssociationChangeNotification) {
            AssociationChangeNotification not = (AssociationChangeNotification)evt;
            switch (not.event()) {
                case COMM_UP: {
                    if (not.association() != null) {
                        this.maxOutboundStreams = not.association().maxOutboundStreams();
                        this.maxInboundStreams = not.association().maxInboundStreams();
                    }
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(String.format("New association setup for Association=%s with %d outbound streams, and %d inbound streams.\n", this.association.getName(), this.maxOutboundStreams, this.maxInboundStreams));
                    }
                    this.association.markAssociationUp(this.maxInboundStreams, this.maxOutboundStreams);
                    break;
                }
                case CANT_START: {
                    this.logger.error(String.format("Can't start for Association=%s", this.association.getName()));
                    break;
                }
                case COMM_LOST: {
                    this.logger.warn(String.format("Communication lost for Association=%s", this.association.getName()));
                    this.association.getAssociationListener().onCommunicationLost(this.association);
                    ctx.close();
                    break;
                }
                case RESTART: {
                    this.logger.warn(String.format("Restart for Association=%s", this.association.getName()));
                    try {
                        this.association.getAssociationListener().onCommunicationRestart(this.association);
                    }
                    catch (Exception e) {
                        this.logger.error(String.format("Exception while calling onCommunicationRestart on AssociationListener for Association=%s", this.association.getName()), e);
                    }
                    break;
                }
                case SHUTDOWN: {
                    if (!this.logger.isInfoEnabled()) break;
                    this.logger.info(String.format("Shutdown for Association=%s", this.association.getName()));
                    break;
                }
                default: {
                    this.logger.warn(String.format("Received unkown Event=%s for Association=%s", new Object[]{not.event(), this.association.getName()}));
                }
            }
        }
        if (evt instanceof PeerAddressChangeNotification) {
            notification = (PeerAddressChangeNotification)evt;
            if (this.logger.isEnabledFor(Priority.WARN)) {
                this.logger.warn(String.format("Peer Address changed to=%s for Association=%s", ((PeerAddressChangeNotification)notification).address(), this.association.getName()));
            }
        } else if (evt instanceof SendFailedNotification) {
            notification = (SendFailedNotification)evt;
            this.logger.error(String.format("Association=" + this.association.getName() + " SendFailedNotification, errorCode=" + ((SendFailedNotification)notification).errorCode(), new Object[0]));
        } else if (evt instanceof ShutdownNotification) {
            notification = (ShutdownNotification)evt;
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("Association=%s SHUTDOWN", this.association.getName()));
            }
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        PayloadData payload;
        if (this.association.getIpChannelType() == IpChannelType.SCTP) {
            SctpMessage sctpMessage = (SctpMessage)msg;
            ByteBuf byteBuf = sctpMessage.content();
            payload = new PayloadData(byteBuf.readableBytes(), byteBuf, sctpMessage.isComplete(), sctpMessage.isUnordered(), sctpMessage.protocolIdentifier(), sctpMessage.streamIdentifier());
        } else {
            ByteBuf byteBuf = (ByteBuf)msg;
            payload = new PayloadData(byteBuf.readableBytes(), byteBuf, true, false, 0, 0);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Rx : Ass=%s %s", this.association.getName(), payload));
        }
        this.association.read(payload);
    }

    protected void writeAndFlush(Object message) {
        Channel ch = this.channel;
        if (ch != null) {
            ChannelFuture future = ch.writeAndFlush(message);
            long curMillisec = System.currentTimeMillis();
            long secPart = curMillisec / 500L;
            if (this.lastCongestionMonitorSecondPart < secPart) {
                this.lastCongestionMonitorSecondPart = secPart;
                CongestionMonitor congestionMonitor = new CongestionMonitor();
                future.addListener(congestionMonitor);
            }
        }
    }

    private void onCongestionMonitor(double delaySec) {
        int i1;
        int newAlarmLevel = this.association.getCongestionLevel();
        for (i1 = this.association.getCongestionLevel() - 1; i1 >= 0; --i1) {
            if (!(delaySec <= this.association.getManagement().congControl_BackToNormalDelayThreshold[i1])) continue;
            newAlarmLevel = i1;
        }
        for (i1 = this.association.getCongestionLevel(); i1 < 3; ++i1) {
            if (!(delaySec >= this.association.getManagement().congControl_DelayThreshold[i1])) continue;
            newAlarmLevel = i1 + 1;
        }
        this.association.setCongestionLevel(newAlarmLevel);
    }

    protected void closeChannel() {
        Channel ch = this.channel;
        if (ch != null) {
            try {
                ch.close().sync();
            }
            catch (InterruptedException e) {
                this.logger.error(String.format("Error while trying to close Channel for Associtaion %s", this.association.getName(), e));
            }
        }
    }

    private class CongestionMonitor
    implements ChannelFutureListener {
        long startTime = System.currentTimeMillis();

        private CongestionMonitor() {
        }

        @Override
        public void operationComplete(ChannelFuture arg0) throws Exception {
            long delay = System.currentTimeMillis() - this.startTime;
            double delaySec = (double)delay / 1000.0;
            NettySctpChannelInboundHandlerAdapter.this.onCongestionMonitor(delaySec);
        }
    }
}

