/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.management.console;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastSet;
import org.apache.log4j.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.plugins.JaasSecurityManager;
import org.mobicents.protocols.ss7.scheduler.Scheduler;
import org.mobicents.protocols.ss7.scheduler.Task;
import org.mobicents.ss7.management.console.ShellExecutor;
import org.mobicents.ss7.management.console.SimplePrincipal;
import org.mobicents.ss7.management.console.Version;
import org.mobicents.ss7.management.transceiver.ChannelProvider;
import org.mobicents.ss7.management.transceiver.ChannelSelectionKey;
import org.mobicents.ss7.management.transceiver.ChannelSelector;
import org.mobicents.ss7.management.transceiver.Message;
import org.mobicents.ss7.management.transceiver.MessageFactory;
import org.mobicents.ss7.management.transceiver.ShellChannel;
import org.mobicents.ss7.management.transceiver.ShellServerChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellServer
extends Task {
    Logger logger = Logger.getLogger(ShellServer.class);
    public static final String CONNECTED_MESSAGE = "Connected to %s %s %s";
    public static final String CONNECTED_AUTHENTICATING_MESSAGE = "Authenticating against configured security realm";
    public static final String CONNECTED_AUTHENTICATION_FAILED = "Authentication failed";
    public static final String AUDIT_MESSAGE = "message";
    public static final String AUDIT_COMMAND = "command";
    public static final String AUDIT_COMMAND_RESPONSE = "response";
    Version version = Version.instance;
    private ChannelProvider provider;
    private ShellServerChannel serverChannel;
    private ShellChannel channel;
    private ChannelSelector selector;
    private ChannelSelectionKey skey;
    private MessageFactory messageFactory = null;
    private String rxMessage = "";
    private String txMessage = "";
    private volatile boolean started = false;
    private String address;
    private int port;
    private JaasSecurityManager jaasSecurityManager = null;
    private String securityDomain = null;
    private String userName = null;
    private String password = null;
    private SecurityContext securityContext = null;
    private SimplePrincipal principal = null;
    private final FastList<ShellExecutor> shellExecutors = new FastList();

    public ShellServer(Scheduler scheduler, List<ShellExecutor> shellExecutors) throws IOException {
        super(scheduler);
        this.shellExecutors.addAll(shellExecutors);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public void start() throws IOException, NamingException {
        this.logger.info("Starting SS7 management shell environment");
        this.provider = ChannelProvider.provider();
        this.serverChannel = this.provider.openServerChannel();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.address, this.port);
        this.serverChannel.bind(inetSocketAddress);
        this.selector = this.provider.openSelector();
        this.skey = this.serverChannel.register(this.selector, 16);
        this.messageFactory = ChannelProvider.provider().getMessageFactory();
        this.logger.info(String.format("ShellExecutor listening at %s", inetSocketAddress));
        this.started = true;
        this.activate(false);
        this.scheduler.submit(this, Scheduler.MANAGEMENT_QUEUE);
        if (this.securityDomain != null) {
            InitialContext initialContext = new InitialContext();
            this.jaasSecurityManager = (JaasSecurityManager)initialContext.lookup(this.securityDomain);
        }
    }

    public void stop() {
        this.started = false;
        this.resetSecurity();
        try {
            this.skey.cancel();
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            this.serverChannel.close();
            this.selector.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.info("Stopped ShellExecutor service");
    }

    @Override
    public int getQueueNumber() {
        return Scheduler.MANAGEMENT_QUEUE;
    }

    @Override
    public long perform() {
        if (!this.started) {
            return 0L;
        }
        try {
            FastSet<ChannelSelectionKey> keys = this.selector.selectNow();
            FastCollection.Record record = keys.head();
            FastCollection.Record end = keys.tail();
            while ((record = record.getNext()) != end) {
                ChannelSelectionKey key = keys.valueOf(record);
                if (key.isAcceptable()) {
                    this.accept();
                    continue;
                }
                if (key.isReadable()) {
                    ShellChannel chan = (ShellChannel)key.channel();
                    Message msg = chan.receive();
                    if (msg != null) {
                        this.rxMessage = msg.toString();
                        this.logger.info("received command : " + this.rxMessage);
                        if (this.rxMessage.compareTo("disconnect") == 0) {
                            this.txMessage = "Bye";
                            if (this.securityDomain != null) {
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                map.put(AUDIT_MESSAGE, "logout success");
                                map.put("principal", this.jaasSecurityManager.getPrincipal((Principal)this.principal));
                                this.securityContext.getAuditManager().audit(new AuditEvent("Success", map));
                            }
                            chan.send(this.messageFactory.createMessage(this.txMessage));
                        } else if (this.securityDomain != null && this.userName == null) {
                            this.userName = this.rxMessage;
                            this.txMessage = " ";
                            chan.send(this.messageFactory.createMessage(this.txMessage));
                        } else if (this.securityDomain != null && this.password == null) {
                            this.password = this.rxMessage;
                            this.txMessage = "";
                            this.principal = new SimplePrincipal(this.userName);
                            boolean isValid = this.jaasSecurityManager.isValid((Principal)this.principal, (Object)this.password);
                            if (!isValid) {
                                chan.send(this.messageFactory.createMessage(CONNECTED_AUTHENTICATION_FAILED));
                                this.logger.warn(String.format("Authentication to CLI fialed for username=%s", this.userName));
                                this.txMessage = "Bye";
                            } else {
                                this.securityContext = SecurityContextFactory.createSecurityContext((String)this.jaasSecurityManager.getSecurityDomain());
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                map.put(AUDIT_MESSAGE, "login success");
                                map.put("principal", this.jaasSecurityManager.getPrincipal((Principal)this.principal));
                                this.securityContext.getAuditManager().audit(new AuditEvent("Success", map));
                                this.txMessage = " ";
                                chan.send(this.messageFactory.createMessage(this.txMessage));
                            }
                        } else {
                            HashMap<String, Object> map;
                            String[] options = this.rxMessage.split(" ");
                            ShellExecutor shellExecutor = null;
                            FastCollection.Record n = this.shellExecutors.head();
                            FastCollection.Record end1 = this.shellExecutors.tail();
                            while ((n = ((FastList.Node)n).getNext()) != end1) {
                                ShellExecutor value = (ShellExecutor)((FastList.Node)n).getValue();
                                if (!value.handles(options[0])) continue;
                                shellExecutor = value;
                                break;
                            }
                            if (shellExecutor == null) {
                                this.logger.warn(String.format("Received command=\"%s\" for which no ShellExecutor is configured ", this.rxMessage));
                                if (this.securityDomain != null) {
                                    map = new HashMap();
                                    map.put(AUDIT_COMMAND, this.rxMessage);
                                    map.put(AUDIT_COMMAND_RESPONSE, "Invalid command");
                                    map.put("principal", this.jaasSecurityManager.getPrincipal((Principal)this.principal));
                                    this.securityContext.getAuditManager().audit(new AuditEvent("Info", map));
                                }
                                chan.send(this.messageFactory.createMessage("Invalid command"));
                            } else {
                                this.txMessage = shellExecutor.execute(options);
                                if (this.securityDomain != null) {
                                    map = new HashMap<String, Object>();
                                    map.put(AUDIT_COMMAND, this.rxMessage);
                                    map.put(AUDIT_COMMAND_RESPONSE, this.txMessage);
                                    map.put("principal", this.jaasSecurityManager.getPrincipal((Principal)this.principal));
                                    this.securityContext.getAuditManager().audit(new AuditEvent("Info", map));
                                }
                                chan.send(this.messageFactory.createMessage(this.txMessage));
                            }
                        }
                    }
                    this.rxMessage = "";
                    continue;
                }
                if (!key.isWritable() || this.txMessage.length() <= 0) continue;
                if (this.txMessage.compareTo("Bye") == 0) {
                    this.closeChannel();
                }
                this.txMessage = "";
            }
        }
        catch (IOException e) {
            this.logger.error("IO Exception while operating on ChannelSelectionKey. Client CLI connection will be closed now", e);
            try {
                this.closeChannel();
            }
            catch (IOException e1) {
                this.logger.error("IO Exception while closing Channel", e);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while operating on ChannelSelectionKey. Client CLI connection will be closed now", e);
            try {
                this.closeChannel();
            }
            catch (IOException e1) {
                this.logger.error("IO Exception while closing Channel", e);
            }
        }
        if (this.started) {
            this.scheduler.submit(this, Scheduler.MANAGEMENT_QUEUE);
        }
        return 0L;
    }

    private void accept() throws IOException {
        ShellChannel channelTmp = this.serverChannel.accept();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Accepting client connection. Remote Address= " + channelTmp.getRemoteAddress());
        }
        if (this.channel != null) {
            String exitmessage = "Already client from " + this.channel.getRemoteAddress() + " is connected. Closing this connection";
            this.logger.warn(exitmessage);
            channelTmp.sendImmediate(this.messageFactory.createMessage(exitmessage));
            channelTmp.close();
            return;
        }
        this.channel = channelTmp;
        this.skey = this.channel.register(this.selector, 5);
        if (this.securityDomain == null) {
            this.channel.send(this.messageFactory.createMessage(String.format(CONNECTED_MESSAGE, this.version.getProperty("name"), this.version.getProperty("version"), this.version.getProperty("vendor"))));
        } else {
            String tmp = String.format(CONNECTED_MESSAGE, this.version.getProperty("name"), this.version.getProperty("version"), this.version.getProperty("vendor"));
            tmp = tmp + " " + CONNECTED_AUTHENTICATING_MESSAGE;
            this.channel.send(this.messageFactory.createMessage(tmp));
        }
    }

    private void closeChannel() throws IOException {
        this.resetSecurity();
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                this.logger.error("Error closing channel", e);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closed client connection. Remote Address= " + this.channel.getRemoteAddress());
            }
            this.channel = null;
        }
    }

    private void resetSecurity() {
        this.userName = null;
        this.password = null;
        this.principal = null;
    }
}

