/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.scheduler;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLinkedList<E>
implements BlockingQueue<E> {
    private Node<E> head = new Node<Object>(null);
    private Node<E> tail = new Node<Object>(null);
    private Node<E> cacheHead = new Node<Object>(null);
    private Node<E> cacheTail = new Node<Object>(null);
    private Node<E> tempNode;
    private Object searchNode;
    private Integer size = 0;
    private Integer cacheSize = 0;
    private Notifier notifierHead = new Notifier();
    private Notifier notifierTail = new Notifier();
    private Notifier notifierCacheHead = new Notifier();
    private Notifier notifierCacheTail = new Notifier();
    private Integer notifierSize = 0;
    private Integer cacheNotifierSize = 0;
    private ListIterator iterator = new ListIterator();
    private Lock lock = new Lock();

    public ConcurrentLinkedList() {
        this.head.next = this.tail;
        this.tail.previous = this.head;
        this.cacheHead.next = this.cacheTail;
        this.cacheTail.previous = this.cacheHead;
        this.notifierHead.next = this.notifierTail;
        this.notifierTail.previous = this.notifierHead;
        this.notifierCacheHead.next = this.notifierCacheTail;
        this.notifierCacheTail.previous = this.notifierCacheHead;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        this.aquireAccess();
        this.tempNode = this.head.next;
        while (this.tempNode.element != null && !o.equals(this.tempNode.element)) {
            this.tempNode = this.tempNode.next;
        }
        if (this.tempNode.element == null) {
            this.releaseAccess();
            return true;
        }
        this.releaseAccess();
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.aquireAccess();
        for (Object this.searchNode : c) {
            if (this.searchNode == null) {
                this.releaseAccess();
                return false;
            }
            this.tempNode = this.head.next;
            while (this.tempNode.element != null && !this.searchNode.equals(this.tempNode.element)) {
                this.tempNode = this.tempNode.next;
            }
            if (this.tempNode.element != null) continue;
            this.releaseAccess();
            return false;
        }
        this.releaseAccess();
        return true;
    }

    @Override
    public boolean add(E value) {
        Integer n;
        Integer n2;
        if (value == null) {
            return false;
        }
        this.aquireAccess();
        this.tempNode = this.head.next;
        while (this.tempNode.element != null && !value.equals(this.tempNode.element)) {
            this.tempNode = this.tempNode.next;
        }
        if (this.tempNode.element != null) {
            this.releaseAccess();
            return false;
        }
        if (this.cacheSize == 0) {
            this.tempNode = new Node<E>(value);
        } else {
            this.tempNode = this.cacheHead.next;
            this.cacheHead.next = this.tempNode.next;
            this.cacheHead.next.previous = this.cacheHead;
            this.tempNode.element = value;
            n2 = this.cacheSize;
            n = this.cacheSize = Integer.valueOf(this.cacheSize - 1);
        }
        this.tail.previous.next = this.tempNode;
        this.tempNode.previous = this.tail.previous;
        this.tempNode.next = this.tail;
        this.tail.previous = this.tempNode;
        n2 = this.size;
        n = this.size = Integer.valueOf(this.size + 1);
        if (this.notifierSize > 0) {
            this.updateNotifier(value);
        }
        this.releaseAccess();
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Boolean result = false;
        for (E item : c) {
            result = result | this.add(item);
        }
        return result;
    }

    @Override
    public void put(E o) {
        this.offer(o);
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) {
        return this.offer(o);
    }

    @Override
    public boolean offer(E value) {
        Integer n;
        Integer n2;
        if (value == null) {
            return false;
        }
        this.aquireAccess();
        if (this.cacheSize == 0) {
            this.tempNode = new Node<E>(value);
        } else {
            this.tempNode = this.cacheHead.next;
            this.cacheHead.next = this.tempNode.next;
            this.cacheHead.next.previous = this.cacheHead;
            this.tempNode.element = value;
            n2 = this.cacheSize;
            n = this.cacheSize = Integer.valueOf(this.cacheSize - 1);
        }
        this.tail.previous.next = this.tempNode;
        this.tempNode.previous = this.tail.previous;
        this.tempNode.next = this.tail;
        this.tail.previous = this.tempNode;
        n2 = this.size;
        n = this.size = Integer.valueOf(this.size + 1);
        if (this.notifierSize > 0) {
            this.updateNotifier(value);
        }
        this.releaseAccess();
        return true;
    }

    @Override
    public E peek() {
        this.aquireAccess();
        Object currValue = this.head.next.element;
        this.releaseAccess();
        return currValue;
    }

    @Override
    public E element() throws NoSuchElementException {
        this.aquireAccess();
        if (this.size == 0) {
            this.releaseAccess();
            throw new NoSuchElementException();
        }
        Object currValue = this.head.next.element;
        this.releaseAccess();
        return currValue;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), (int)this.size);
        }
        this.aquireAccess();
        this.tempNode = this.head.next;
        int i = 0;
        Object[] result = a;
        while (this.tempNode.element != null && i < a.length) {
            result[i++] = this.tempNode.element;
            this.tempNode = this.tempNode.next;
        }
        this.releaseAccess();
        while (i < a.length) {
            result[i] = null;
        }
        return a;
    }

    @Override
    public Object[] toArray() {
        this.aquireAccess();
        Object[] result = new Object[this.size.intValue()];
        this.tempNode = this.head.next;
        int i = 0;
        while (i < this.size) {
            result[i++] = this.tempNode.element;
            this.tempNode = this.tempNode.next;
        }
        this.releaseAccess();
        return result;
    }

    @Override
    public E poll() {
        this.aquireAccess();
        if (this.size == 0) {
            this.releaseAccess();
            return null;
        }
        this.tempNode = this.head.next;
        this.head.next = this.tempNode.next;
        this.head.next.previous = this.head;
        this.tempNode.next = this.cacheHead.next;
        this.cacheHead.next = this.tempNode;
        this.tempNode.previous = this.cacheHead;
        this.tempNode.next.previous = this.tempNode;
        Object currValue = this.tempNode.element;
        Integer n = this.cacheSize;
        Integer n2 = this.cacheSize = Integer.valueOf(this.cacheSize + 1);
        n = this.size;
        n2 = this.size = Integer.valueOf(this.size - 1);
        this.releaseAccess();
        return currValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() {
        Integer n;
        Object object;
        this.aquireAccess();
        if (this.size == 0) {
            Notifier tempNotifier;
            if (this.cacheNotifierSize == 0) {
                tempNotifier = new Notifier();
            } else {
                tempNotifier = this.notifierCacheHead.next;
                this.notifierCacheHead.next = tempNotifier.next;
                this.notifierCacheHead.next.previous = this.notifierCacheHead;
                object = this.cacheNotifierSize;
                n = this.cacheNotifierSize = Integer.valueOf(this.cacheNotifierSize - 1);
            }
            this.notifierTail.previous.next = tempNotifier;
            tempNotifier.previous = this.notifierTail.previous;
            tempNotifier.next = this.notifierTail;
            this.notifierTail.previous = tempNotifier;
            object = this.notifierSize;
            n = this.notifierSize = Integer.valueOf(this.notifierSize + 1);
            while (this.size == 0) {
                this.releaseAccess();
                object = tempNotifier.lock;
                synchronized (object) {
                    try {
                        tempNotifier.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.aquireAccess();
                if (this.size == 0) continue;
                tempNotifier.previous.next = tempNotifier.next;
                tempNotifier.next.previous = tempNotifier.previous;
                tempNotifier.next = this.notifierCacheHead.next;
                this.notifierCacheHead.next.previous = tempNotifier;
                this.notifierCacheHead.next = tempNotifier;
                tempNotifier.previous = this.notifierCacheHead;
                object = this.cacheNotifierSize;
                n = this.cacheNotifierSize = Integer.valueOf(this.cacheNotifierSize + 1);
            }
        }
        this.tempNode = this.head.next;
        this.head.next = this.tempNode.next;
        this.head.next.previous = this.head;
        this.tempNode.next = this.cacheHead.next;
        this.cacheHead.next = this.tempNode;
        this.tempNode.previous = this.cacheHead;
        this.tempNode.next.previous = this.tempNode;
        Object currValue = this.tempNode.element;
        object = this.cacheSize;
        n = this.cacheSize = Integer.valueOf(this.cacheSize + 1);
        object = this.size;
        n = this.size = Integer.valueOf(this.size - 1);
        this.releaseAccess();
        return currValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Integer n;
        Object object;
        this.aquireAccess();
        if (this.size == 0) {
            Notifier tempNotifier;
            if (this.cacheNotifierSize == 0) {
                tempNotifier = new Notifier();
            } else {
                tempNotifier = this.notifierCacheHead.next;
                this.notifierCacheHead.next = tempNotifier.next;
                this.notifierCacheHead.next.previous = this.notifierCacheHead;
                object = this.cacheNotifierSize;
                n = this.cacheNotifierSize = Integer.valueOf(this.cacheNotifierSize - 1);
            }
            this.notifierTail.previous.next = tempNotifier;
            tempNotifier.previous = this.notifierTail.previous;
            tempNotifier.next = this.notifierTail;
            this.notifierTail.previous = tempNotifier;
            object = this.notifierSize;
            n = this.notifierSize = Integer.valueOf(this.notifierSize + 1);
            while (this.size == 0) {
                this.releaseAccess();
                object = tempNotifier.lock;
                synchronized (object) {
                    try {
                        switch (unit) {
                            case MICROSECONDS: {
                                tempNotifier.lock.wait(timeout / 1000L, (int)(timeout * 1000L % 1000000L));
                                break;
                            }
                            case MILLISECONDS: {
                                tempNotifier.lock.wait(timeout);
                                break;
                            }
                            case NANOSECONDS: {
                                tempNotifier.lock.wait(timeout / 1000000L, (int)(timeout % 1000000L));
                                break;
                            }
                            case SECONDS: {
                                tempNotifier.lock.wait(timeout * 1000L);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.aquireAccess();
                if (this.size != 0) continue;
                this.releaseAccess();
                throw new InterruptedException();
            }
            tempNotifier.previous.next = tempNotifier.next;
            tempNotifier.next.previous = tempNotifier.previous;
            tempNotifier.next = this.notifierCacheHead.next;
            this.notifierCacheHead.next.previous = tempNotifier;
            this.notifierCacheHead.next = tempNotifier;
            tempNotifier.previous = this.notifierCacheHead;
            object = this.cacheNotifierSize;
            n = this.cacheNotifierSize = Integer.valueOf(this.cacheNotifierSize + 1);
        }
        this.tempNode = this.head.next;
        this.head.next = this.tempNode.next;
        this.head.next.previous = this.head;
        this.tempNode.next = this.cacheHead.next;
        this.cacheHead.next = this.tempNode;
        this.tempNode.previous = this.cacheHead;
        this.tempNode.next.previous = this.tempNode;
        Object currValue = this.tempNode.element;
        object = this.cacheSize;
        n = this.cacheSize = Integer.valueOf(this.cacheSize + 1);
        object = this.size;
        n = this.size = Integer.valueOf(this.size - 1);
        this.releaseAccess();
        return currValue;
    }

    @Override
    public E remove() throws NoSuchElementException {
        this.aquireAccess();
        if (this.size == 0) {
            this.releaseAccess();
            throw new NoSuchElementException();
        }
        this.tempNode = this.head.next;
        this.head.next = this.tempNode.next;
        this.head.next.previous = this.head;
        this.tempNode.next = this.cacheHead.next;
        this.cacheHead.next = this.tempNode;
        this.tempNode.previous = this.cacheHead;
        this.tempNode.next.previous = this.tempNode;
        Object currValue = this.tempNode.element;
        Integer n = this.cacheSize;
        Integer n2 = this.cacheSize = Integer.valueOf(this.cacheSize + 1);
        n = this.size;
        n2 = this.size = Integer.valueOf(this.size - 1);
        this.releaseAccess();
        return currValue;
    }

    @Override
    public boolean remove(Object o) {
        this.aquireAccess();
        this.tempNode = this.head.next;
        while (this.tempNode.element != null && !o.equals(this.tempNode.element)) {
            this.tempNode = this.tempNode.next;
        }
        if (this.tempNode.element == null) {
            this.releaseAccess();
            return false;
        }
        this.tempNode.previous.next = this.tempNode.next;
        this.tempNode.next.previous = this.tempNode.previous;
        Integer n = this.size;
        Integer n2 = this.size = Integer.valueOf(this.size - 1);
        this.tempNode.next = this.cacheHead.next;
        this.cacheHead.next = this.tempNode;
        this.tempNode.previous = this.cacheHead;
        this.tempNode.next.previous = this.tempNode;
        this.releaseAccess();
        return true;
    }

    @Override
    public void clear() {
        this.aquireAccess();
        if (this.size > 0) {
            this.cacheSize = this.cacheSize + this.size;
            this.size = 0;
            this.tail.previous.next = this.cacheHead.next;
            this.cacheHead.next.previous = this.tail.previous;
            this.cacheHead.next = this.head.next;
            this.head.next.previous = this.cacheHead;
            this.head.next = this.tail;
            this.tail.previous = this.head;
        }
        this.releaseAccess();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        if (this.size == 0) {
            return 0;
        }
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.equals(this)) {
            throw new IllegalArgumentException();
        }
        this.aquireAccess();
        Node tempFirst = this.head.next;
        Node tempLast = this.tail.previous;
        int tempCount = this.size;
        this.head.next = this.tail;
        this.tail.previous = this.head;
        this.size = 0;
        this.releaseAccess();
        Node tempNode = tempFirst;
        for (int i = tempCount; i > 0; --i) {
            c.add(tempNode.element);
            tempNode = tempNode.next;
        }
        this.aquireAccess();
        if (tempCount > 0) {
            this.cacheSize = this.cacheSize + tempCount;
            tempLast.next = this.cacheHead.next;
            this.cacheHead.next.previous = tempLast;
            this.cacheHead.next = tempFirst;
            tempFirst.previous = this.cacheHead;
        }
        this.releaseAccess();
        return tempCount;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int count;
        if (this.size == 0) {
            return 0;
        }
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.equals(this)) {
            throw new IllegalArgumentException();
        }
        this.aquireAccess();
        this.tempNode = this.head.next;
        for (count = 0; this.tempNode.element != null && count < maxElements; ++count) {
            c.add(this.tempNode.element);
            this.tempNode = this.tempNode.next;
        }
        this.size = this.size - count;
        if (count > 0) {
            this.cacheSize = this.cacheSize + count;
            Node firstNode = this.head.next;
            this.head.next = this.tempNode.next;
            this.head.next.previous = this.head;
            this.tempNode.next = this.cacheHead.next;
            this.cacheHead.next.previous = this.tempNode;
            this.cacheHead.next = firstNode;
            firstNode.previous = this.cacheHead;
        }
        this.releaseAccess();
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        this.iterator.currNode = this.head;
        return this.iterator;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifier(E newElement) {
        if (this.notifierSize == 0) {
            return;
        }
        Integer n = this.notifierSize;
        this.notifierSize = this.notifierSize - 1;
        Object object = this.notifierSize;
        Notifier tempNotifier = this.notifierHead.next;
        object = tempNotifier.lock;
        synchronized (object) {
            tempNotifier.lock.notify();
        }
    }

    private void aquireAccess() {
        try {
            this.lock.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void releaseAccess() {
        this.lock.unlock();
    }

    private class Lock {
        protected boolean locked = false;

        public synchronized void lock() throws InterruptedException {
            while (this.locked) {
                this.wait();
            }
            this.locked = true;
        }

        public synchronized void unlock() {
            this.locked = false;
            this.notify();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIterator
    implements Iterator<E> {
        private Node<E> currNode;

        public ListIterator() {
            this.currNode = ConcurrentLinkedList.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.currNode.next.element != null;
        }

        @Override
        public E next() {
            ConcurrentLinkedList.this.aquireAccess();
            Object result = this.currNode.next.element;
            this.currNode = this.currNode.next;
            ConcurrentLinkedList.this.releaseAccess();
            return result;
        }

        @Override
        public void remove() {
            ConcurrentLinkedList.this.aquireAccess();
            ConcurrentLinkedList.this.tempNode = this.currNode;
            this.currNode = this.currNode.next;
            ((ConcurrentLinkedList)ConcurrentLinkedList.this).tempNode.previous.next = ((ConcurrentLinkedList)ConcurrentLinkedList.this).tempNode.next;
            ((ConcurrentLinkedList)ConcurrentLinkedList.this).tempNode.next.previous = ((ConcurrentLinkedList)ConcurrentLinkedList.this).tempNode.previous;
            Integer n = ConcurrentLinkedList.this.size;
            Integer n2 = ConcurrentLinkedList.this.size = ConcurrentLinkedList.this.size - 1;
            ((ConcurrentLinkedList)ConcurrentLinkedList.this).tempNode.next = ((ConcurrentLinkedList)ConcurrentLinkedList.this).cacheHead.next;
            ((ConcurrentLinkedList)ConcurrentLinkedList.this).cacheHead.next = ConcurrentLinkedList.this.tempNode;
            ((ConcurrentLinkedList)ConcurrentLinkedList.this).tempNode.previous = ConcurrentLinkedList.this.cacheHead;
            ((ConcurrentLinkedList)ConcurrentLinkedList.this).tempNode.next.previous = ConcurrentLinkedList.this.tempNode;
            ConcurrentLinkedList.this.releaseAccess();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node<E> {
        E element;
        Node<E> next;
        Node<E> previous;

        Node(E element) {
            this.element = element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Notifier<E> {
        private Object lock = new Object();
        Notifier next;
        Notifier previous;

        private Notifier() {
        }
    }
}

