/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.SM_RP_DA;
import org.mobicents.protocols.ss7.map.api.service.sms.SM_RP_OA;
import org.mobicents.protocols.ss7.map.api.service.sms.SmsSignalInfo;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.sms.SM_RP_DAImpl;
import org.mobicents.protocols.ss7.map.service.sms.SM_RP_OAImpl;
import org.mobicents.protocols.ss7.map.service.sms.SmsMessageImpl;
import org.mobicents.protocols.ss7.map.service.sms.SmsSignalInfoImpl;

public class MtForwardShortMessageRequestImpl
extends SmsMessageImpl
implements MtForwardShortMessageRequest {
    private SM_RP_DA sM_RP_DA;
    private SM_RP_OA sM_RP_OA;
    private SmsSignalInfoImpl sM_RP_UI;
    private boolean moreMessagesToSend;
    private MAPExtensionContainer extensionContainer;
    protected String _PrimitiveName = "MtForwardShortMessageRequest";

    public MtForwardShortMessageRequestImpl() {
    }

    public MtForwardShortMessageRequestImpl(SM_RP_DA sM_RP_DA, SM_RP_OA sM_RP_OA, SmsSignalInfo sM_RP_UI, boolean moreMessagesToSend, MAPExtensionContainer extensionContainer) {
        this.sM_RP_DA = sM_RP_DA;
        this.sM_RP_OA = sM_RP_OA;
        this.sM_RP_UI = (SmsSignalInfoImpl)sM_RP_UI;
        this.moreMessagesToSend = moreMessagesToSend;
        this.extensionContainer = extensionContainer;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.mtForwardSM_Request;
    }

    public int getOperationCode() {
        return 44;
    }

    public SM_RP_DA getSM_RP_DA() {
        return this.sM_RP_DA;
    }

    public SM_RP_OA getSM_RP_OA() {
        return this.sM_RP_OA;
    }

    public SmsSignalInfo getSM_RP_UI() {
        return this.sM_RP_UI;
    }

    public boolean getMoreMessagesToSend() {
        return this.moreMessagesToSend;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.sM_RP_DA = null;
        this.sM_RP_OA = null;
        this.sM_RP_UI = null;
        this.moreMessagesToSend = false;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (num) {
                case 0: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter 0 bad tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.sM_RP_DA = new SM_RP_DAImpl();
                    ((SM_RP_DAImpl)this.sM_RP_DA).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter 1 bad tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.sM_RP_OA = new SM_RP_OAImpl();
                    ((SM_RP_OAImpl)this.sM_RP_OA).decodeAll(ais);
                    break;
                }
                case 2: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter 2 bad tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    if (tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter 2 tag must be STRING_OCTET, found: " + tag, MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.sM_RP_UI = new SmsSignalInfoImpl();
                    this.sM_RP_UI.decodeAll(ais);
                    break;
                }
                default: {
                    if (tag == 16 && ais.getTagClass() == 0) {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        break;
                    }
                    if (tag == 5 && ais.getTagClass() == 0) {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter moreMessagesToSend is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.moreMessagesToSend = true;
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 3) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Needs at least 3 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.sM_RP_DA == null || this.sM_RP_OA == null || this.sM_RP_UI == null) {
            throw new MAPException("sm_RP_DA,sm_RP_OA and sm_RP_UI must not be null");
        }
        try {
            ((SM_RP_DAImpl)this.sM_RP_DA).encodeAll(asnOs);
            ((SM_RP_OAImpl)this.sM_RP_OA).encodeAll(asnOs);
            this.sM_RP_UI.encodeAll(asnOs);
            if (this.moreMessagesToSend) {
                asnOs.writeNull();
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.getMAPDialog() != null) {
            sb.append("DialogId=").append(this.getMAPDialog().getLocalDialogId());
        }
        if (this.sM_RP_DA != null) {
            sb.append(", sm_RP_DA=");
            sb.append(this.sM_RP_DA.toString());
        }
        if (this.sM_RP_OA != null) {
            sb.append(", sm_RP_OA=");
            sb.append(this.sM_RP_OA.toString());
        }
        if (this.sM_RP_UI != null) {
            sb.append(", sm_RP_UI=[");
            sb.append(this.sM_RP_UI.toString());
            sb.append("]");
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        if (this.moreMessagesToSend) {
            sb.append(", moreMessagesToSend");
        }
        sb.append("]");
        return sb.toString();
    }
}

