/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.scheduler;

import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.impl.scheduler.M3UATask;

public class M3UAScheduler
implements Runnable {
    private static final Logger logger = Logger.getLogger(M3UAScheduler.class);
    protected FastList<M3UATask> tasks = new FastList();
    private FastList<M3UATask> removed = new FastList();

    public void execute(M3UATask task) {
        if (task == null) {
            return;
        }
        this.tasks.add(task);
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        FastCollection.Record n = this.tasks.head();
        FastCollection.Record end = this.tasks.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            M3UATask task;
            block5: {
                task = (M3UATask)((FastList.Node)n).getValue();
                if (task.isCanceled()) {
                    this.removed.add(task);
                    continue;
                }
                try {
                    task.run(now);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("Failuer on task run.", e);
                }
            }
            if (!task.isCanceled()) continue;
            this.removed.add(task);
        }
        if (this.removed.size() > 0) {
            this.tasks.removeAll(this.removed);
            this.removed.clear();
        }
    }
}

