/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.UserServiceInformationBase;

public abstract class UserServiceInformationBaseImpl
extends AbstractISUPParameter
implements UserServiceInformationBase {
    private static final String CODING_STANDART = "codingStandart";
    private static final String INFORMATION_TRANSFER_CAPABILITY = "informationTransferCapability";
    private static final String TRANSFER_MODE = "transferMode";
    private static final String CUSTOM_INFORMATION_TRANSFERRATE = "customInformationTransferRate";
    private static final String INFORMATION_TRANSFER_RATE = "informationTransferRate";
    private static final String L1_USER_INFORMATION = "l1UserInformation";
    private static final String L2_USER_INFORMATION = "l2UserInformation";
    private static final String L3_USER_INFORMATION = "l3UserInformation";
    private static final String SYNC_MODE = "syncMode";
    private static final String NEGOTIATION = "negotiation";
    private static final String USER_RATE = "userRate";
    private static final String INTERMEDIATE_RATE = "intermediateRate";
    private static final String NIC_ON_TX = "nicOnTx";
    private static final String NIC_ON_RX = "nicOnRx";
    private static final String FC_ON_TX = "fcOnTx";
    private static final String FC_ON_RX = "fcOnRx";
    private static final String HDR = "hdr";
    private static final String MULTIFRAME = "multiframe";
    private static final String MODE = "mode";
    private static final String LLI = "lli";
    private static final String ASSIGNOR = "assignor";
    private static final String IN_BAND_NEGOTIATION = "inBandNegotiation";
    private static final String STOP_BITS = "stopBits";
    private static final String DATA_BITS = "dataBits";
    private static final String PARITY = "parity";
    private static final String DUPLEX_MODE = "duplexMode";
    private static final String MODEM_TYPE = "modemType";
    private static final String L3_PROTOCOL = "l3Protocol";
    private static final int DEFAULT_VALUES = 0;
    private int codingStandart = 0;
    private int informationTransferCapability = 0;
    private int transferMode = 0;
    private int customInformationTransferRate = 0;
    private int informationTransferRate = 0;
    private int l1UserInformation = 0;
    private int l2UserInformation = 0;
    private int l3UserInformation = 0;
    private int syncMode = 0;
    private int negotiation = 0;
    private int userRate = 0;
    private int intermediateRate = 0;
    private int nicOnTx = 0;
    private int nicOnRx = 0;
    private int fcOnTx = 0;
    private int fcOnRx = 0;
    private int hdr = 0;
    private int multiframe = 0;
    private int mode = 0;
    private int lli = 0;
    private int assignor = 0;
    private int inBandNegotiation = 0;
    private int stopBits = 0;
    private int dataBits = 0;
    private int parity = 0;
    private int duplexMode = 0;
    private int modemType = 0;
    private int l3Protocol = 0;
    protected static final XMLFormat<UserServiceInformationBaseImpl> ISUP_USER_SERVICE_INFORMATION_BASE_XML = new XMLFormat<UserServiceInformationBaseImpl>(UserServiceInformationBaseImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, UserServiceInformationBaseImpl userServiceInformation) throws XMLStreamException {
            userServiceInformation.codingStandart = xml.getAttribute(UserServiceInformationBaseImpl.CODING_STANDART, 0);
            userServiceInformation.informationTransferCapability = xml.getAttribute(UserServiceInformationBaseImpl.INFORMATION_TRANSFER_CAPABILITY, 0);
            userServiceInformation.transferMode = xml.getAttribute(UserServiceInformationBaseImpl.TRANSFER_MODE, 0);
            userServiceInformation.customInformationTransferRate = xml.getAttribute(UserServiceInformationBaseImpl.CUSTOM_INFORMATION_TRANSFERRATE, 0);
            userServiceInformation.informationTransferRate = xml.getAttribute(UserServiceInformationBaseImpl.INFORMATION_TRANSFER_RATE, 0);
            userServiceInformation.l1UserInformation = xml.getAttribute(UserServiceInformationBaseImpl.L1_USER_INFORMATION, 0);
            userServiceInformation.l2UserInformation = xml.getAttribute(UserServiceInformationBaseImpl.L2_USER_INFORMATION, 0);
            userServiceInformation.l3UserInformation = xml.getAttribute(UserServiceInformationBaseImpl.L3_USER_INFORMATION, 0);
            userServiceInformation.syncMode = xml.getAttribute(UserServiceInformationBaseImpl.SYNC_MODE, 0);
            userServiceInformation.negotiation = xml.getAttribute(UserServiceInformationBaseImpl.NEGOTIATION, 0);
            userServiceInformation.userRate = xml.getAttribute(UserServiceInformationBaseImpl.USER_RATE, 0);
            userServiceInformation.intermediateRate = xml.getAttribute(UserServiceInformationBaseImpl.INTERMEDIATE_RATE, 0);
            userServiceInformation.nicOnTx = xml.getAttribute(UserServiceInformationBaseImpl.NIC_ON_TX, 0);
            userServiceInformation.nicOnRx = xml.getAttribute(UserServiceInformationBaseImpl.NIC_ON_RX, 0);
            userServiceInformation.fcOnTx = xml.getAttribute(UserServiceInformationBaseImpl.FC_ON_TX, 0);
            userServiceInformation.fcOnRx = xml.getAttribute(UserServiceInformationBaseImpl.FC_ON_RX, 0);
            userServiceInformation.hdr = xml.getAttribute(UserServiceInformationBaseImpl.HDR, 0);
            userServiceInformation.multiframe = xml.getAttribute(UserServiceInformationBaseImpl.MULTIFRAME, 0);
            userServiceInformation.mode = xml.getAttribute(UserServiceInformationBaseImpl.MODE, 0);
            userServiceInformation.lli = xml.getAttribute(UserServiceInformationBaseImpl.LLI, 0);
            userServiceInformation.assignor = xml.getAttribute(UserServiceInformationBaseImpl.ASSIGNOR, 0);
            userServiceInformation.inBandNegotiation = xml.getAttribute(UserServiceInformationBaseImpl.IN_BAND_NEGOTIATION, 0);
            userServiceInformation.stopBits = xml.getAttribute(UserServiceInformationBaseImpl.STOP_BITS, 0);
            userServiceInformation.dataBits = xml.getAttribute(UserServiceInformationBaseImpl.DATA_BITS, 0);
            userServiceInformation.parity = xml.getAttribute(UserServiceInformationBaseImpl.PARITY, 0);
            userServiceInformation.duplexMode = xml.getAttribute(UserServiceInformationBaseImpl.DUPLEX_MODE, 0);
            userServiceInformation.modemType = xml.getAttribute(UserServiceInformationBaseImpl.MODEM_TYPE, 0);
            userServiceInformation.l3Protocol = xml.getAttribute(UserServiceInformationBaseImpl.L3_PROTOCOL, 0);
        }

        @Override
        public void write(UserServiceInformationBaseImpl userServiceInformation, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(UserServiceInformationBaseImpl.CODING_STANDART, userServiceInformation.codingStandart);
            xml.setAttribute(UserServiceInformationBaseImpl.INFORMATION_TRANSFER_CAPABILITY, userServiceInformation.informationTransferCapability);
            xml.setAttribute(UserServiceInformationBaseImpl.TRANSFER_MODE, userServiceInformation.transferMode);
            xml.setAttribute(UserServiceInformationBaseImpl.INFORMATION_TRANSFER_RATE, userServiceInformation.informationTransferRate);
            if (userServiceInformation.informationTransferRate == 24) {
                xml.setAttribute(UserServiceInformationBaseImpl.CUSTOM_INFORMATION_TRANSFERRATE, userServiceInformation.customInformationTransferRate);
            }
            if (userServiceInformation.l1UserInformation > 0) {
                xml.setAttribute(UserServiceInformationBaseImpl.L1_USER_INFORMATION, userServiceInformation.l1UserInformation);
                xml.setAttribute(UserServiceInformationBaseImpl.SYNC_MODE, userServiceInformation.syncMode);
                xml.setAttribute(UserServiceInformationBaseImpl.NEGOTIATION, userServiceInformation.negotiation);
                xml.setAttribute(UserServiceInformationBaseImpl.USER_RATE, userServiceInformation.userRate);
                xml.setAttribute(UserServiceInformationBaseImpl.INTERMEDIATE_RATE, userServiceInformation.intermediateRate);
                xml.setAttribute(UserServiceInformationBaseImpl.NIC_ON_TX, userServiceInformation.nicOnTx);
                xml.setAttribute(UserServiceInformationBaseImpl.NIC_ON_RX, userServiceInformation.nicOnRx);
                xml.setAttribute(UserServiceInformationBaseImpl.FC_ON_TX, userServiceInformation.fcOnTx);
                xml.setAttribute(UserServiceInformationBaseImpl.FC_ON_RX, userServiceInformation.fcOnRx);
                xml.setAttribute(UserServiceInformationBaseImpl.HDR, userServiceInformation.hdr);
                xml.setAttribute(UserServiceInformationBaseImpl.MULTIFRAME, userServiceInformation.multiframe);
                xml.setAttribute(UserServiceInformationBaseImpl.MODE, userServiceInformation.mode);
                xml.setAttribute(UserServiceInformationBaseImpl.LLI, userServiceInformation.lli);
                xml.setAttribute(UserServiceInformationBaseImpl.ASSIGNOR, userServiceInformation.assignor);
                xml.setAttribute(UserServiceInformationBaseImpl.IN_BAND_NEGOTIATION, userServiceInformation.inBandNegotiation);
                xml.setAttribute(UserServiceInformationBaseImpl.STOP_BITS, userServiceInformation.stopBits);
                xml.setAttribute(UserServiceInformationBaseImpl.DATA_BITS, userServiceInformation.dataBits);
                xml.setAttribute(UserServiceInformationBaseImpl.PARITY, userServiceInformation.parity);
                xml.setAttribute(UserServiceInformationBaseImpl.DUPLEX_MODE, userServiceInformation.duplexMode);
                xml.setAttribute(UserServiceInformationBaseImpl.MODEM_TYPE, userServiceInformation.modemType);
            }
            if (userServiceInformation.l2UserInformation > 0) {
                xml.setAttribute(UserServiceInformationBaseImpl.L2_USER_INFORMATION, userServiceInformation.l2UserInformation);
            }
            if (userServiceInformation.l3UserInformation > 0) {
                xml.setAttribute(UserServiceInformationBaseImpl.L3_USER_INFORMATION, userServiceInformation.l3UserInformation);
                xml.setAttribute(UserServiceInformationBaseImpl.L3_PROTOCOL, userServiceInformation.l3Protocol);
            }
        }
    };

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 2 || b.length > 13) {
            throw new IllegalArgumentException("byte[] must not be null and should be between 2 and 13 bytes in length");
        }
        byte v = 0;
        int index = 0;
        int layerId = 0;
        int extBit = 0;
        v = b[index++];
        this.informationTransferCapability = v & 0x1F;
        this.codingStandart = v >> 5 & 3;
        v = b[index++];
        this.informationTransferRate = v & 0x1F;
        this.transferMode = v >> 5 & 3;
        if (this.informationTransferRate == 24) {
            if (b.length < 3) {
                throw new IllegalArgumentException("byte[] should be at least 3 bytes in length");
            }
            v = b[index++];
            this.customInformationTransferRate = v & 0x7F;
        }
        block12: while (index < b.length) {
            v = b[index++];
            layerId = v >> 5 & 3;
            switch (layerId) {
                case 1: {
                    this.l1UserInformation = v & 0x1F;
                    extBit = v & 0x80;
                    if (this.informationTransferCapability == 8) {
                        switch (this.l1UserInformation) {
                            case 1: 
                            case 7: {
                                if (extBit != 0) break;
                                v = b[index++];
                                this.syncMode = v >> 6 & 1;
                                this.negotiation = v >> 5 & 1;
                                this.userRate = v & 0x1F;
                                extBit = v & 0x80;
                                if (extBit != 0) break;
                                v = b[index++];
                                this.intermediateRate = v >> 5 & 3;
                                this.nicOnTx = v >> 4 & 1;
                                this.nicOnRx = v >> 3 & 1;
                                this.fcOnTx = v >> 2 & 1;
                                this.fcOnRx = v >> 1 & 1;
                                extBit = v & 0x80;
                                if (extBit != 0) break;
                                v = b[index++];
                                this.stopBits = v >> 5 & 3;
                                this.dataBits = v >> 3 & 3;
                                this.parity = v & 7;
                                extBit = v & 0x80;
                                if (extBit != 0) break;
                                v = b[index++];
                                this.duplexMode = v >> 6 & 1;
                                this.modemType = v & 0x1F;
                                extBit = v & 0x80;
                                break;
                            }
                            case 8: {
                                if (extBit != 0) break;
                                v = b[index++];
                                this.syncMode = v >> 6 & 1;
                                this.negotiation = v >> 5 & 1;
                                this.userRate = v & 0x1F;
                                extBit = v & 0x80;
                                if (extBit != 0) break;
                                v = b[index++];
                                this.hdr = v >> 6 & 1;
                                this.multiframe = v >> 5 & 1;
                                this.mode = v >> 4 & 1;
                                this.lli = v >> 3 & 1;
                                this.assignor = v >> 2 & 1;
                                this.inBandNegotiation = v >> 1 & 1;
                                extBit = v & 0x80;
                                if (extBit != 0) break;
                                v = b[index++];
                                this.stopBits = v >> 5 & 3;
                                this.dataBits = v >> 3 & 3;
                                this.parity = v & 7;
                                extBit = v & 0x80;
                                if (extBit != 0) break;
                                v = b[index++];
                                this.duplexMode = v >> 6 & 1;
                                this.modemType = v & 0x1F;
                                extBit = v & 0x80;
                            }
                        }
                    } else if (this.informationTransferCapability == 16) {
                        switch (this.l1UserInformation) {
                            case 2: 
                            case 3: {
                                if (extBit != 0) break;
                                v = b[index++];
                                this.syncMode = v >> 6 & 1;
                                this.negotiation = v >> 5 & 1;
                                this.userRate = v & 0x1F;
                                extBit = v & 0x80;
                                if (extBit != 0) break;
                                v = b[index++];
                                this.intermediateRate = v >> 5 & 3;
                                this.nicOnTx = v >> 4 & 1;
                                this.nicOnRx = v >> 3 & 1;
                                this.fcOnTx = v >> 2 & 1;
                                this.fcOnRx = v >> 1 & 1;
                                extBit = v & 0x80;
                                if (extBit != 0) break;
                                v = b[index++];
                                this.stopBits = v >> 5 & 3;
                                this.dataBits = v >> 3 & 3;
                                this.parity = v & 7;
                                extBit = v & 0x80;
                                if (extBit != 0) break;
                                v = b[index++];
                                this.duplexMode = v >> 6 & 1;
                                this.modemType = v & 0x1F;
                                extBit = v & 0x80;
                            }
                        }
                    }
                    while (index < b.length && extBit == 0) {
                        v = b[index++];
                        extBit = v & 0x80;
                    }
                    continue block12;
                }
                case 2: {
                    this.l2UserInformation = v & 0x1F;
                    continue block12;
                }
                case 3: {
                    this.l3UserInformation = v & 0x1F;
                    extBit = v & 0x80;
                    if (extBit == 0 && this.l3UserInformation == 11) {
                        v = b[index++];
                        this.l3Protocol = (v & 0xF) << 4;
                        v = b[index++];
                        this.l3Protocol |= v & 0xF;
                    }
                    while (index < b.length && extBit == 0) {
                        v = b[index++];
                        extBit = v & 0x80;
                    }
                    continue block12;
                }
            }
            throw new IllegalArgumentException("invalid layer identifier");
        }
        return 0;
    }

    public byte[] encode() throws ParameterException {
        int byteLength = 2;
        if (this.informationTransferRate == 24) {
            ++byteLength;
        }
        if (this.l1UserInformation > 0) {
            ++byteLength;
            switch (this.l1UserInformation) {
                case 1: 
                case 7: 
                case 8: {
                    if (this.informationTransferCapability != 8) break;
                    byteLength += 4;
                    break;
                }
                case 2: 
                case 3: {
                    if (this.informationTransferCapability != 16) break;
                    byteLength += 4;
                }
            }
        }
        if (this.l2UserInformation > 0) {
            ++byteLength;
        }
        if (this.l3UserInformation > 0) {
            ++byteLength;
            if (this.l3UserInformation == 11) {
                byteLength += 2;
            }
        }
        byte[] b = new byte[byteLength];
        b[0] = (byte)(b[0] | 0x80);
        b[0] = (byte)(b[0] | (this.codingStandart & 3) << 5);
        b[0] = (byte)(b[0] | this.informationTransferCapability & 0x1F);
        b[1] = (byte)(b[1] | 0x80);
        b[1] = (byte)(b[1] | (this.transferMode & 3) << 5);
        b[1] = (byte)(b[1] | this.informationTransferRate & 0x1F);
        byteLength = 2;
        if (this.informationTransferRate == 24) {
            int n = byteLength;
            b[n] = (byte)(b[n] | 0x80);
            int n2 = byteLength++;
            b[n2] = (byte)(b[n2] | this.customInformationTransferRate);
        }
        if (this.l1UserInformation > 0) {
            int n = byteLength;
            b[n] = (byte)(b[n] | 0x20);
            int n3 = byteLength++;
            b[n3] = (byte)(b[n3] | this.l1UserInformation & 0x1F);
            switch (this.l1UserInformation) {
                case 1: 
                case 7: {
                    if (this.informationTransferCapability != 8) break;
                    int n4 = byteLength;
                    b[n4] = (byte)(b[n4] | this.syncMode << 6);
                    int n5 = byteLength;
                    b[n5] = (byte)(b[n5] | this.negotiation << 5);
                    int n6 = byteLength++;
                    b[n6] = (byte)(b[n6] | this.userRate);
                    int n7 = byteLength;
                    b[n7] = (byte)(b[n7] | this.intermediateRate << 5);
                    int n8 = byteLength;
                    b[n8] = (byte)(b[n8] | this.nicOnTx << 4);
                    int n9 = byteLength;
                    b[n9] = (byte)(b[n9] | this.nicOnRx << 3);
                    int n10 = byteLength;
                    b[n10] = (byte)(b[n10] | this.fcOnTx << 2);
                    int n11 = byteLength++;
                    b[n11] = (byte)(b[n11] | this.fcOnRx << 1);
                    int n12 = byteLength;
                    b[n12] = (byte)(b[n12] | this.stopBits << 5);
                    int n13 = byteLength;
                    b[n13] = (byte)(b[n13] | this.dataBits << 3);
                    int n14 = byteLength++;
                    b[n14] = (byte)(b[n14] | this.parity);
                    int n15 = byteLength;
                    b[n15] = (byte)(b[n15] | this.duplexMode << 6);
                    int n16 = byteLength++;
                    b[n16] = (byte)(b[n16] | this.modemType);
                    break;
                }
                case 8: {
                    if (this.informationTransferCapability != 8) break;
                    int n17 = byteLength;
                    b[n17] = (byte)(b[n17] | this.syncMode << 6);
                    int n18 = byteLength;
                    b[n18] = (byte)(b[n18] | this.negotiation << 5);
                    int n19 = byteLength++;
                    b[n19] = (byte)(b[n19] | this.userRate);
                    int n20 = byteLength;
                    b[n20] = (byte)(b[n20] | this.hdr << 6);
                    int n21 = byteLength;
                    b[n21] = (byte)(b[n21] | this.multiframe << 5);
                    int n22 = byteLength;
                    b[n22] = (byte)(b[n22] | this.mode << 4);
                    int n23 = byteLength;
                    b[n23] = (byte)(b[n23] | this.lli << 3);
                    int n24 = byteLength;
                    b[n24] = (byte)(b[n24] | this.assignor << 3);
                    int n25 = byteLength++;
                    b[n25] = (byte)(b[n25] | this.inBandNegotiation << 1);
                    int n26 = byteLength;
                    b[n26] = (byte)(b[n26] | this.stopBits << 5);
                    int n27 = byteLength;
                    b[n27] = (byte)(b[n27] | this.dataBits << 3);
                    int n28 = byteLength++;
                    b[n28] = (byte)(b[n28] | this.parity);
                    int n29 = byteLength;
                    b[n29] = (byte)(b[n29] | this.duplexMode << 6);
                    int n30 = byteLength++;
                    b[n30] = (byte)(b[n30] | this.modemType);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.informationTransferCapability != 16) break;
                    int n31 = byteLength;
                    b[n31] = (byte)(b[n31] | this.syncMode << 6);
                    int n32 = byteLength;
                    b[n32] = (byte)(b[n32] | this.negotiation << 5);
                    int n33 = byteLength++;
                    b[n33] = (byte)(b[n33] | this.userRate);
                    int n34 = byteLength;
                    b[n34] = (byte)(b[n34] | this.intermediateRate << 5);
                    int n35 = byteLength;
                    b[n35] = (byte)(b[n35] | this.nicOnTx << 4);
                    int n36 = byteLength;
                    b[n36] = (byte)(b[n36] | this.nicOnRx << 3);
                    int n37 = byteLength;
                    b[n37] = (byte)(b[n37] | this.fcOnTx << 2);
                    int n38 = byteLength++;
                    b[n38] = (byte)(b[n38] | this.fcOnRx << 1);
                    int n39 = byteLength;
                    b[n39] = (byte)(b[n39] | this.stopBits << 5);
                    int n40 = byteLength;
                    b[n40] = (byte)(b[n40] | this.dataBits << 3);
                    int n41 = byteLength++;
                    b[n41] = (byte)(b[n41] | this.parity);
                    int n42 = byteLength;
                    b[n42] = (byte)(b[n42] | this.duplexMode << 6);
                    int n43 = byteLength++;
                    b[n43] = (byte)(b[n43] | this.modemType);
                }
            }
            int n44 = byteLength - 1;
            b[n44] = (byte)(b[n44] | 0x80);
        }
        if (this.l2UserInformation > 0) {
            int n = byteLength;
            b[n] = (byte)(b[n] | 0x80);
            int n45 = byteLength;
            b[n45] = (byte)(b[n45] | 0x40);
            int n46 = byteLength++;
            b[n46] = (byte)(b[n46] | this.l2UserInformation & 0x1F);
        }
        if (this.l3UserInformation > 0) {
            int n = byteLength;
            b[n] = (byte)(b[n] | 0x60);
            int n47 = byteLength++;
            b[n47] = (byte)(b[n47] | this.l3UserInformation & 0x1F);
            if (this.l3UserInformation == 11) {
                int n48 = byteLength++;
                b[n48] = (byte)(b[n48] | this.l3Protocol >> 4 & 0xF);
                int n49 = byteLength++;
                b[n49] = (byte)(b[n49] | this.l3Protocol & 0xF);
            }
            int n50 = byteLength - 1;
            b[n50] = (byte)(b[n50] | 0x80);
        }
        return b;
    }

    public UserServiceInformationBaseImpl() {
    }

    public UserServiceInformationBaseImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public int getCodingStandart() {
        return this.codingStandart;
    }

    public void setCodingStandart(int codingStandart) {
        this.codingStandart = codingStandart;
    }

    public int getInformationTransferCapability() {
        return this.informationTransferCapability;
    }

    public void setInformationTransferCapability(int informationTransferCapability) {
        this.informationTransferCapability = informationTransferCapability;
    }

    public int getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(int transferMode) {
        this.transferMode = transferMode;
    }

    public int getInformationTransferRate() {
        return this.informationTransferRate;
    }

    public void setInformationTransferRate(int informationTransferRate) {
        this.informationTransferRate = informationTransferRate;
    }

    public int getCustomInformationTransferRate() {
        return this.customInformationTransferRate;
    }

    public void setCustomInformationTransferRate(int customInformationTransferRate) {
        this.customInformationTransferRate = customInformationTransferRate;
    }

    public int getL1UserInformation() {
        return this.l1UserInformation;
    }

    public void setL1UserInformation(int l1UserInformation) {
        this.l1UserInformation = l1UserInformation;
    }

    public int getL2UserInformation() {
        return this.l2UserInformation;
    }

    public void setL2UserInformation(int l2UserInformation) {
        this.l2UserInformation = l2UserInformation;
    }

    public int getL3UserInformation() {
        return this.l3UserInformation;
    }

    public void setL3UserInformation(int l3UserInformation) {
        this.l3UserInformation = l3UserInformation;
    }

    public int getSyncMode() {
        return this.syncMode;
    }

    public void setSyncMode(int syncMode) {
        this.syncMode = syncMode;
    }

    public int getNegotiation() {
        return this.negotiation;
    }

    public void setNegotiation(int negotiation) {
        this.negotiation = negotiation;
    }

    public int getUserRate() {
        return this.userRate;
    }

    public void setUserRate(int userRate) {
        this.userRate = userRate;
    }

    public int getIntermediateRate() {
        return this.intermediateRate;
    }

    public void setIntermediateRate(int intermediateRate) {
        this.intermediateRate = intermediateRate;
    }

    public int getNicOnTx() {
        return this.nicOnTx;
    }

    public void setNicOnTx(int nicOnTx) {
        this.nicOnTx = nicOnTx;
    }

    public int getNicOnRx() {
        return this.nicOnRx;
    }

    public void setNicOnRx(int nicOnRx) {
        this.nicOnRx = nicOnRx;
    }

    public int getFlowControlOnTx() {
        return this.fcOnTx;
    }

    public void setFlowControlOnTx(int fcOnTx) {
        this.fcOnTx = fcOnTx;
    }

    public int getFlowControlOnRx() {
        return this.fcOnRx;
    }

    public void setFlowControlOnRx(int fcOnRx) {
        this.fcOnRx = fcOnRx;
    }

    public int getHDR() {
        return this.hdr;
    }

    public void setHDR(int hdr) {
        this.hdr = hdr;
    }

    public int getMultiframe() {
        return this.multiframe;
    }

    public void setMultiframe(int multiframe) {
        this.multiframe = multiframe;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getLLINegotiation() {
        return this.lli;
    }

    public void setLLINegotiation(int lli) {
        this.lli = lli;
    }

    public int getAssignor() {
        return this.assignor;
    }

    public void setAssignor(int assignor) {
        this.assignor = assignor;
    }

    public int getInBandNegotiation() {
        return this.inBandNegotiation;
    }

    public void setInBandNegotiation(int inBandNegotiation) {
        this.inBandNegotiation = inBandNegotiation;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(int stopBits) {
        this.stopBits = stopBits;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public void setDataBits(int dataBits) {
        this.dataBits = dataBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setParity(int parity) {
        this.parity = parity;
    }

    public int getDuplexMode() {
        return this.duplexMode;
    }

    public void setDuplexMode(int duplexMode) {
        this.duplexMode = duplexMode;
    }

    public int getModemType() {
        return this.modemType;
    }

    public void setModemType(int modemType) {
        this.modemType = modemType;
    }

    public int getL3Protocol() {
        return this.l3Protocol;
    }

    public void setL3Protocol(int l3Protocol) {
        this.l3Protocol = l3Protocol;
    }

    protected abstract String getPrimitiveName();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPrimitiveName());
        sb.append(" [codingStandart=");
        sb.append(this.codingStandart);
        sb.append(", informationTransferCapability=");
        sb.append(this.informationTransferCapability);
        sb.append(", transferMode=");
        sb.append(this.transferMode);
        sb.append(", informationTransferRate=");
        sb.append(this.informationTransferRate);
        sb.append(", customInformationTransferRate=");
        sb.append(this.customInformationTransferRate);
        if (this.l1UserInformation > 0) {
            sb.append(",\nl1UserInformation=");
            sb.append(this.l1UserInformation);
            sb.append(", syncMode=");
            sb.append(this.syncMode);
            sb.append(", negotiation=");
            sb.append(this.negotiation);
            sb.append(", userRate=");
            sb.append(this.userRate);
            sb.append(", intermediateRate=");
            sb.append(this.intermediateRate);
            sb.append(", nicOnTx=");
            sb.append(this.nicOnTx);
            sb.append(", fcOnTx=");
            sb.append(this.fcOnTx);
            sb.append(", hdr=");
            sb.append(this.hdr);
            sb.append(", multiframe=");
            sb.append(this.multiframe);
            sb.append(", mode=");
            sb.append(this.mode);
            sb.append(", lli=");
            sb.append(this.lli);
            sb.append(", assignor=");
            sb.append(this.assignor);
            sb.append(", inBandNegotiation=");
            sb.append(this.inBandNegotiation);
            sb.append(", stopBits=");
            sb.append(this.stopBits);
            sb.append(", dataBits=");
            sb.append(this.dataBits);
            sb.append(", parity=");
            sb.append(this.parity);
            sb.append(", duplexMode=");
            sb.append(this.duplexMode);
            sb.append(", modemType=");
            sb.append(this.modemType);
        }
        if (this.l2UserInformation > 0) {
            sb.append("\nl2UserInformation=");
            sb.append(this.l2UserInformation);
        }
        if (this.l3UserInformation > 0) {
            sb.append("\nl3UserInformation=");
            sb.append(this.l3UserInformation);
            sb.append(", l3Protocol=");
            sb.append(this.l3Protocol);
        }
        sb.append("]");
        return sb.toString();
    }
}

