/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup;

import java.util.EventObject;
import org.mobicents.protocols.ss7.isup.ISUPTimeout;
import org.mobicents.protocols.ss7.isup.message.ISUPMessage;

public class ISUPTimeoutEvent
extends EventObject
implements ISUPTimeout {
    protected final ISUPMessage message;
    protected final int timerId;
    protected final int dpc;

    public ISUPTimeoutEvent(Object source, ISUPMessage message, int timerId, int dpc) {
        super(source);
        this.message = message;
        this.timerId = timerId;
        this.dpc = dpc;
    }

    public ISUPMessage getMessage() {
        return this.message;
    }

    public int getTimerId() {
        return this.timerId;
    }

    public int getDpc() {
        return this.dpc;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.message != null) {
            result = 31 * result + this.message.getMessageType().getCode();
            result = 31 * result + this.message.getCircuitIdentificationCode().getCIC();
        }
        result = 31 * result + this.timerId;
        result = 31 * result + this.dpc;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ISUPTimeoutEvent other = (ISUPTimeoutEvent)obj;
        if (this.message != null && other.message == null) {
            return false;
        }
        if (this.message == null && other.message != null) {
            return false;
        }
        if (this.message.getCircuitIdentificationCode().getCIC() != other.message.getCircuitIdentificationCode().getCIC()) {
            return false;
        }
        if (this.message.getMessageType().getCode() != other.message.getMessageType().getCode()) {
            return false;
        }
        if (this.dpc != other.dpc) {
            return false;
        }
        return this.timerId == other.timerId;
    }

    public String toString() {
        return "ISUPTimeoutEvent [message=" + this.message + ", timerId=" + this.timerId + "]";
    }
}

