/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.TimerID;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ResetTimerRequest;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;

public class ResetTimerRequestImpl
extends CircuitSwitchedCallMessageImpl
implements ResetTimerRequest {
    public static final int _ID_timerID = 0;
    public static final int _ID_timervalue = 1;
    public static final int _ID_extensions = 2;
    public static final int _ID_callSegmentID = 3;
    public static final String _PrimitiveName = "ConnectToResourceIndication";
    private TimerID timerID;
    private int timerValue;
    private CAPExtensions extensions;
    private Integer callSegmentID;

    public ResetTimerRequestImpl() {
    }

    public ResetTimerRequestImpl(TimerID timerID, int timerValue, CAPExtensions extensions, Integer callSegmentID) {
        this.timerID = timerID;
        this.timerValue = timerValue;
        this.extensions = extensions;
        this.callSegmentID = callSegmentID;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.resetTimer_Request;
    }

    public int getOperationCode() {
        return 33;
    }

    public TimerID getTimerID() {
        return this.timerID;
    }

    public int getTimerValue() {
        return this.timerValue;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public Integer getCallSegmentID() {
        return this.callSegmentID;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ConnectToResourceIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ConnectToResourceIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ConnectToResourceIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ConnectToResourceIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.timerID = TimerID.tssf;
        this.timerValue = -1;
        this.extensions = null;
        this.callSegmentID = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        int i1 = (int)ais.readInteger();
                        this.timerID = TimerID.getInstance(i1);
                        break;
                    }
                    case 1: {
                        this.timerValue = (int)ais.readInteger();
                        break;
                    }
                    case 2: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    case 3: {
                        this.callSegmentID = (int)ais.readInteger();
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.timerValue == -1) {
            throw new CAPParsingComponentException("Error while decoding ConnectToResourceIndication: timerValue is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ConnectToResourceIndication: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.timerID == null) {
            this.timerID = TimerID.tssf;
        }
        try {
            aos.writeInteger(2, 0, this.timerID.getCode());
            aos.writeInteger(2, 1, this.timerValue);
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 2);
            }
            if (this.callSegmentID != null) {
                aos.writeInteger(2, 3, this.callSegmentID.intValue());
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding ConnectToResourceIndication: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ConnectToResourceIndication: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.timerID != null) {
            sb.append(", timerID=");
            sb.append(this.timerID.toString());
        }
        sb.append(", timerValue=");
        sb.append(this.timerValue);
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.callSegmentID != null) {
            sb.append(", callSegmentID=");
            sb.append(this.callSegmentID.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

