/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.CauseCap;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ReleaseCallRequest;
import org.mobicents.protocols.ss7.cap.isup.CauseCapImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class ReleaseCallRequestImpl
extends CircuitSwitchedCallMessageImpl
implements ReleaseCallRequest {
    public static final String _PrimitiveName = "ReleaseCalltRequestIndication";
    private static final String CAUSE = "cause";
    private CauseCap cause;
    protected static final XMLFormat<ReleaseCallRequestImpl> RELEASE_CALL_REQUEST_XML = new XMLFormat<ReleaseCallRequestImpl>(ReleaseCallRequestImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, ReleaseCallRequestImpl releaseCallRequest) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.read(xml, releaseCallRequest);
            releaseCallRequest.cause = xml.get(ReleaseCallRequestImpl.CAUSE, CauseCapImpl.class);
        }

        @Override
        public void write(ReleaseCallRequestImpl releaseCallRequest, XMLFormat.OutputElement xml) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.write(releaseCallRequest, xml);
            if (releaseCallRequest.getCause() != null) {
                xml.add((CauseCapImpl)releaseCallRequest.getCause(), ReleaseCallRequestImpl.CAUSE, CauseCapImpl.class);
            }
        }
    };

    public ReleaseCallRequestImpl() {
    }

    public ReleaseCallRequestImpl(CauseCap cause) {
        this.cause = cause;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.releaseCall_Request;
    }

    public int getOperationCode() {
        return 22;
    }

    public CauseCap getCause() {
        return this.cause;
    }

    public int getTag() throws CAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ReleaseCalltRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ReleaseCalltRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ReleaseCalltRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ReleaseCalltRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ReleaseCalltRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ReleaseCalltRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, MAPParsingComponentException, IOException, AsnException {
        this.cause = new CauseCapImpl();
        ((CauseCapImpl)this.cause).decodeData(ansIS, length);
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ReleaseCalltRequestIndication: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.cause == null) {
            throw new CAPException("Error while encoding ReleaseCalltRequestIndication: cause must not be null");
        }
        ((CauseCapImpl)this.cause).encodeData(asnOs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.cause != null) {
            sb.append(", cause=");
            sb.append(this.cause.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

