/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.CAPProviderImpl;
import org.mobicents.protocols.ss7.cap.api.CAPApplicationContext;
import org.mobicents.protocols.ss7.cap.api.CAPDialog;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPServiceBase;
import org.mobicents.protocols.ss7.cap.api.dialog.CAPDialogState;
import org.mobicents.protocols.ss7.cap.api.dialog.CAPGeneralAbortReason;
import org.mobicents.protocols.ss7.cap.api.dialog.CAPGprsReferenceNumber;
import org.mobicents.protocols.ss7.cap.api.dialog.CAPUserAbortReason;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessage;
import org.mobicents.protocols.ss7.cap.errors.CAPErrorMessageImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.MessageType;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.TCAPSendException;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndRequest;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.Reject;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnError;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultLast;

public abstract class CAPDialogImpl
implements CAPDialog {
    private static final Logger logger = Logger.getLogger(CAPDialogImpl.class);
    protected Dialog tcapDialog = null;
    protected CAPProviderImpl capProviderImpl = null;
    protected CAPServiceBase capService = null;
    protected CAPApplicationContext appCntx;
    protected CAPGprsReferenceNumber gprsReferenceNumber = null;
    protected CAPGprsReferenceNumber receivedGprsReferenceNumber;
    protected CAPDialogState state = CAPDialogState.Idle;
    boolean returnMessageOnError = false;
    protected MessageType tcapMessageType;
    protected DelayedAreaState delayedAreaState;

    protected CAPDialogImpl(CAPApplicationContext appCntx, Dialog tcapDialog, CAPProviderImpl capProviderImpl, CAPServiceBase capService) {
        this.appCntx = appCntx;
        this.tcapDialog = tcapDialog;
        this.capProviderImpl = capProviderImpl;
        this.capService = capService;
    }

    public SccpAddress getLocalAddress() {
        return this.tcapDialog.getLocalAddress();
    }

    public void setLocalAddress(SccpAddress localAddress) {
        this.tcapDialog.setLocalAddress(localAddress);
    }

    public SccpAddress getRemoteAddress() {
        return this.tcapDialog.getRemoteAddress();
    }

    public void setRemoteAddress(SccpAddress remoteAddress) {
        this.tcapDialog.setRemoteAddress(remoteAddress);
    }

    public void setReturnMessageOnError(boolean val) {
        this.returnMessageOnError = val;
    }

    public boolean getReturnMessageOnError() {
        return this.returnMessageOnError;
    }

    public MessageType getTCAPMessageType() {
        return this.tcapMessageType;
    }

    public int getNetworkId() {
        return this.tcapDialog.getNetworkId();
    }

    public void setNetworkId(int networkId) {
        this.tcapDialog.setNetworkId(networkId);
    }

    public void keepAlive() {
        this.tcapDialog.keepAlive();
    }

    public Long getLocalDialogId() {
        return this.tcapDialog.getLocalDialogId();
    }

    public Long getRemoteDialogId() {
        return this.tcapDialog.getRemoteDialogId();
    }

    public CAPServiceBase getService() {
        return this.capService;
    }

    public Dialog getTcapDialog() {
        return this.tcapDialog;
    }

    public void release() {
        this.setState(CAPDialogState.Expunged);
        if (this.tcapDialog != null) {
            this.tcapDialog.release();
        }
    }

    public CAPDialogState getState() {
        return this.state;
    }

    protected synchronized void setState(CAPDialogState newState) {
        if (this.state == CAPDialogState.Expunged) {
            return;
        }
        this.state = newState;
    }

    public void setGprsReferenceNumber(CAPGprsReferenceNumber gprsReferenceNumber) {
        this.gprsReferenceNumber = gprsReferenceNumber;
    }

    public CAPGprsReferenceNumber getGprsReferenceNumber() {
        return this.gprsReferenceNumber;
    }

    public CAPGprsReferenceNumber getReceivedGprsReferenceNumber() {
        return this.receivedGprsReferenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send() throws CAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.getTcapDialog().getDialogLock().lock();
            switch (this.tcapDialog.getState()) {
                case Idle: {
                    ApplicationContextName acn = this.capProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    this.setState(CAPDialogState.InitialSent);
                    this.capProviderImpl.fireTCBegin(this.getTcapDialog(), acn, this.gprsReferenceNumber, this.getReturnMessageOnError());
                    this.gprsReferenceNumber = null;
                    return;
                }
                case Active: {
                    this.capProviderImpl.fireTCContinue(this.getTcapDialog(), null, null, this.getReturnMessageOnError());
                    return;
                }
                case InitialReceived: {
                    ApplicationContextName acn1 = this.capProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    this.capProviderImpl.fireTCContinue(this.getTcapDialog(), acn1, this.gprsReferenceNumber, this.getReturnMessageOnError());
                    this.gprsReferenceNumber = null;
                    this.setState(CAPDialogState.Active);
                    return;
                }
                case InitialSent: {
                    throw new CAPException("Awaiting TC-BEGIN response, can not send another dialog initiating primitive!");
                }
                case Expunged: {
                    throw new CAPException("Dialog has been terminated, can not send primitives!");
                }
            }
            return;
        }
        finally {
            this.getTcapDialog().getDialogLock().unlock();
        }
    }

    public void sendDelayed() throws CAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        if (this.delayedAreaState == null) {
            this.send();
        } else {
            switch (this.delayedAreaState) {
                case No: {
                    this.delayedAreaState = DelayedAreaState.Continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(boolean prearrangedEnd) throws CAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.getTcapDialog().getDialogLock().lock();
            switch (this.tcapDialog.getState()) {
                case InitialReceived: {
                    ApplicationContextName acn = this.capProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    this.capProviderImpl.fireTCEnd(this.getTcapDialog(), prearrangedEnd, acn, this.gprsReferenceNumber, this.getReturnMessageOnError());
                    this.gprsReferenceNumber = null;
                    this.setState(CAPDialogState.Expunged);
                    return;
                }
                case Active: {
                    this.capProviderImpl.fireTCEnd(this.getTcapDialog(), prearrangedEnd, null, null, this.getReturnMessageOnError());
                    this.setState(CAPDialogState.Expunged);
                    return;
                }
                case Idle: {
                    throw new CAPException("Awaiting TC-BEGIN to be sent, can not send another dialog initiating primitive!");
                }
                case InitialSent: {
                    throw new CAPException("Awaiting TC-BEGIN response, can not send another dialog initiating primitive!");
                }
                case Expunged: {
                    throw new CAPException("Dialog has been terminated, can not send primitives!");
                }
            }
            return;
        }
        finally {
            this.getTcapDialog().getDialogLock().unlock();
        }
    }

    public void closeDelayed(boolean prearrangedEnd) throws CAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        if (this.delayedAreaState == null) {
            this.close(prearrangedEnd);
        } else if (prearrangedEnd) {
            switch (this.delayedAreaState) {
                case No: 
                case Continue: 
                case End: {
                    this.delayedAreaState = DelayedAreaState.PrearrangedEnd;
                }
            }
        } else {
            switch (this.delayedAreaState) {
                case No: 
                case Continue: {
                    this.delayedAreaState = DelayedAreaState.End;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(CAPUserAbortReason abortReason) throws CAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.getTcapDialog().getDialogLock().lock();
            if (this.getState() == CAPDialogState.Expunged || this.getState() == CAPDialogState.Idle) {
                this.setState(CAPDialogState.Expunged);
                return;
            }
            this.capProviderImpl.fireTCAbort(this.getTcapDialog(), CAPGeneralAbortReason.UserSpecific, abortReason, this.getReturnMessageOnError());
            this.setState(CAPDialogState.Expunged);
        }
        finally {
            this.getTcapDialog().getDialogLock().unlock();
        }
    }

    public void processInvokeWithoutAnswer(Long invokeId) {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        this.tcapDialog.processInvokeWithoutAnswer(invokeId);
    }

    public void sendInvokeComponent(Invoke invoke) throws CAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.tcapDialog.sendComponent(invoke);
        }
        catch (TCAPSendException e) {
            throw new CAPException(e.getMessage(), e);
        }
    }

    public void sendReturnResultLastComponent(ReturnResultLast returnResultLast) throws CAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.tcapDialog.sendComponent(returnResultLast);
        }
        catch (TCAPSendException e) {
            throw new CAPException(e.getMessage(), e);
        }
    }

    public void sendErrorComponent(Long invokeId, CAPErrorMessage mem) throws CAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        CAPErrorMessageImpl capErrorMessage = (CAPErrorMessageImpl)mem;
        ReturnError returnError = this.capProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCReturnErrorRequest();
        try {
            returnError.setInvokeId(invokeId);
            ErrorCode ec = TcapFactory.createErrorCode();
            ec.setLocalErrorCode(capErrorMessage.getErrorCode());
            returnError.setErrorCode(ec);
            AsnOutputStream aos = new AsnOutputStream();
            capErrorMessage.encodeData(aos);
            byte[] buf = aos.toByteArray();
            if (buf.length != 0) {
                Parameter p = this.capProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createParameter();
                p.setTagClass(capErrorMessage.getTagClass());
                p.setPrimitive(capErrorMessage.getIsPrimitive());
                p.setTag(capErrorMessage.getTag());
                p.setData(buf);
                returnError.setParameter(p);
            }
            this.tcapDialog.sendComponent(returnError);
        }
        catch (TCAPSendException e) {
            throw new CAPException(e.getMessage(), e);
        }
    }

    public void sendRejectComponent(Long invokeId, Problem problem) throws CAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        Reject reject = this.capProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCRejectRequest();
        try {
            reject.setInvokeId(invokeId);
            reject.setProblem(problem);
            this.tcapDialog.sendComponent(reject);
        }
        catch (TCAPSendException e) {
            throw new CAPException(e.getMessage(), e);
        }
    }

    public void resetInvokeTimer(Long invokeId) throws CAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.getTcapDialog().resetTimer(invokeId);
        }
        catch (TCAPException e) {
            throw new CAPException("TCAPException occure: " + e.getMessage(), e);
        }
    }

    public boolean cancelInvocation(Long invokeId) throws CAPException {
        try {
            return this.getTcapDialog().cancelInvocation(invokeId);
        }
        catch (TCAPException e) {
            throw new CAPException("TCAPException occure: " + e.getMessage(), e);
        }
    }

    public Object getUserObject() {
        return this.tcapDialog.getUserObject();
    }

    public void setUserObject(Object userObject) {
        this.tcapDialog.setUserObject(userObject);
    }

    public CAPApplicationContext getApplicationContext() {
        return this.appCntx;
    }

    public int getMaxUserDataLength() {
        return this.getTcapDialog().getMaxUserDataLength();
    }

    public int getMessageUserDataLengthOnSend() throws CAPException {
        try {
            switch (this.tcapDialog.getState()) {
                case Idle: {
                    ApplicationContextName acn = this.capProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    TCBeginRequest tb = this.capProviderImpl.encodeTCBegin(this.getTcapDialog(), acn, this.gprsReferenceNumber);
                    return this.tcapDialog.getDataLength(tb);
                }
                case Active: {
                    TCContinueRequest tc = this.capProviderImpl.encodeTCContinue(this.getTcapDialog(), null, null);
                    return this.tcapDialog.getDataLength(tc);
                }
                case InitialReceived: {
                    ApplicationContextName acn1 = this.capProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    TCContinueRequest tc = this.capProviderImpl.encodeTCContinue(this.getTcapDialog(), acn1, this.gprsReferenceNumber);
                    return this.tcapDialog.getDataLength(tc);
                }
            }
        }
        catch (TCAPSendException e) {
            throw new CAPException("TCAPSendException when getMessageUserDataLengthOnSend", e);
        }
        throw new CAPException("Bad TCAP Dialog state: " + (Object)((Object)this.tcapDialog.getState()));
    }

    public int getMessageUserDataLengthOnClose(boolean prearrangedEnd) throws CAPException {
        try {
            switch (this.tcapDialog.getState()) {
                case InitialReceived: {
                    ApplicationContextName acn = this.capProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    TCEndRequest te = this.capProviderImpl.encodeTCEnd(this.getTcapDialog(), prearrangedEnd, acn, this.gprsReferenceNumber);
                    return this.tcapDialog.getDataLength(te);
                }
                case Active: {
                    TCEndRequest te = this.capProviderImpl.encodeTCEnd(this.getTcapDialog(), prearrangedEnd, null, null);
                    return this.tcapDialog.getDataLength(te);
                }
            }
        }
        catch (TCAPSendException e) {
            throw new CAPException("TCAPSendException when getMessageUserDataLengthOnSend", e);
        }
        throw new CAPException("Bad TCAP Dialog state: " + (Object)((Object)this.tcapDialog.getState()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CAPDialog: LocalDialogId=").append(this.getLocalDialogId()).append(" RemoteDialogId=").append(this.getRemoteDialogId()).append(" CAPDialogState=").append((Object)this.getState()).append(" CAPApplicationContext=").append((Object)this.appCntx).append(" TCAPDialogState=").append((Object)this.tcapDialog.getState());
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DelayedAreaState {
        No,
        Continue,
        End,
        PrearrangedEnd;

    }
}

