/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.Cksn;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.GSMSecurityContextData;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.Kc;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.CksnImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.KcImpl;

public class GSMSecurityContextDataImpl
extends SequenceBase
implements GSMSecurityContextData {
    private Kc kc;
    private Cksn cksn;

    public GSMSecurityContextDataImpl() {
        super("GSMSecurityContextData");
    }

    public GSMSecurityContextDataImpl(Kc kc, Cksn cksn) {
        super("GSMSecurityContextData");
        this.kc = kc;
        this.cksn = cksn;
    }

    public Kc getKc() {
        return this.kc;
    }

    public Cksn getCksn() {
        return this.cksn;
    }

    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (num) {
                case 0: {
                    if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".kc: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.kc = new KcImpl();
                    ((KcImpl)this.kc).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".cksn: Parameter 1 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.cksn = new CksnImpl();
                    ((CksnImpl)this.cksn).decodeAll(ais);
                    break;
                }
                default: {
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 2) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Needs at least 2 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.kc == null || this.cksn == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter kc or cksn is not defined");
        }
        if (this.kc != null) {
            ((KcImpl)this.kc).encodeAll(asnOs);
        }
        if (this.cksn != null) {
            ((CksnImpl)this.cksn).encodeAll(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.kc != null) {
            sb.append("kc=");
            sb.append(this.kc.toString());
            sb.append(", ");
        }
        if (this.cksn != null) {
            sb.append("cksn=");
            sb.append(this.cksn.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

